/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.TlsUtils;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.IRunnableExt;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.SCLoginException;
import com.blixx.log.RTLogger;
import com.blixx.shared.IODataStream;
import com.blixx.shared.SEvent;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocket;

public abstract class ServerClient
implements Runnable,
IRunnableExt {
    public static final String T = "T";
    public static final int DEFAULT_TIMEOUT_60000 = 60000;
    private static ExecutorService m_executor = new ThreadPoolExecutor(0, 50, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    protected String m_action = null;
    protected String[] m_parameters = null;
    public String m_command = null;
    protected Object m_result = null;
    protected boolean isFinished = false;
    protected boolean isOKFinished = false;
    protected boolean isSupported = true;
    protected IODataStream[] m_object = null;
    protected SEvent[] m_events = null;
    protected int m_timeout = -1;
    protected IServerAuth m_auth = null;
    protected List<ICmdPostProcess> m_cmdPostProcess = new ArrayList<ICmdPostProcess>(1);
    protected Throwable m_lastException = null;
    protected Map<String, Object> m_optionalData = new HashMap<String, Object>();
    protected boolean isTlsActive = false;
    protected String tlsVersion = "";

    protected ServerClient(IServerAuth auth) {
        this.m_auth = auth;
    }

    protected void setCommand(String command) {
        this.m_command = command;
    }

    protected void setAction(String action) {
        this.m_action = action;
    }

    protected void setCommand(String command, String action) {
        this.setCommand(command);
        this.setAction(action);
    }

    protected void setCommand(String command, String action, String[] parameters) {
        this.setCommand(command, action);
        this.m_parameters = parameters;
        this.m_object = null;
        this.m_events = null;
    }

    protected void setCommand(String command, String action, IODataStream[] objects) {
        this.setCommand(command, action);
        this.m_object = objects;
        this.m_events = null;
        this.m_parameters = null;
    }

    protected void setCommand(String command, String action, SEvent[] events) {
        this.setCommand(command, action);
        this.m_events = events;
        this.m_object = null;
        this.m_parameters = null;
    }

    public void addCmdPostProcess(ICmdPostProcess process) {
        if (!this.m_cmdPostProcess.contains(process)) {
            this.m_cmdPostProcess.add(process);
        }
    }

    @Override
    public void run() {
        block5: {
            try {
                try {
                    this.runCommand();
                }
                catch (Throwable throwable) {
                    this.isFinished = true;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.isFinished = true;
                throw throwable;
            }
            this.isFinished = true;
        }
        this.postProcess();
    }

    public void postProcess() {
        try {
            for (ICmdPostProcess p : this.m_cmdPostProcess) {
                if (p == null) continue;
                try {
                    p.postProcess(this);
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder("ICmdPostProcess ");
                    sb.append(this.m_command).append(' ').append(this.isOKFinished);
                    RTLogger.print(3, sb.toString(), e);
                }
            }
        }
        catch (Exception e) {
            RTLogger.print(4, "Error postprocess " + this.getCommand(), e);
        }
    }

    @Override
    public synchronized void start() {
        boolean started = false;
        do {
            try {
                m_executor.execute(this);
                started = true;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                try {
                    this.wait(10L);
                }
                catch (Throwable throwable) {}
            }
        } while (!started);
    }

    protected void runCommand() {
        block44: {
            Socket sock = null;
            SDataOutputStream os = null;
            SDataInputStream is = null;
            try {
                try {
                    sock = new Socket();
                    sock.bind(null);
                    sock.setSoTimeout(60000);
                    if (this.m_timeout > 0) {
                        sock.setSoTimeout(this.m_timeout);
                    }
                    sock.setTcpNoDelay(true);
                    sock.setSoLinger(true, 1);
                    sock.connect(new InetSocketAddress(this.m_auth.getHostName(), this.m_auth.getPort()), 20000);
                    is = new SDataInputStream(sock.getInputStream());
                    os = new SDataOutputStream(sock.getOutputStream(), com.blixx.boom.engine.ServerClient.getDetectedServerProtocolVersion());
                    if (BMUI.m_activateTls) {
                        sock = TlsUtils.upgradeToTLS(sock);
                        this.tlsVersion = ((SSLSocket)sock).getSession().getProtocol();
                        this.isTlsActive = true;
                    }
                    String str = is.readUTF();
                    com.blixx.boom.engine.ServerClient.setDetectedServerProtocolVersion(is.getLastProtocolVersion());
                    int res = this.processServerQuestion(str, os, is);
                    if (res != 0) {
                        throw new SCLoginException("Login failed!");
                    }
                    this.runDirect(is, os);
                    os.writeUTF("EXIT");
                }
                catch (Throwable e) {
                    RTLogger.print(1, "", e);
                    this.m_lastException = e;
                    this.isFinished = true;
                    if (os != null) {
                        try {
                            os.write(0);
                        }
                        catch (Throwable throwable) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (sock != null) {
                        try {
                            sock.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    break block44;
                }
            }
            catch (Throwable throwable) {
                this.isFinished = true;
                if (os != null) {
                    try {
                        os.write(0);
                    }
                    catch (Throwable throwable2) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable3) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable4) {}
                }
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (Throwable throwable5) {}
                }
                throw throwable;
            }
            this.isFinished = true;
            if (os != null) {
                try {
                    os.write(0);
                }
                catch (Throwable throwable) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable throwable) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void setTimeout(int milliseconds) {
        this.m_timeout = milliseconds;
    }

    protected abstract void runCommand(SDataInputStream var1, SDataOutputStream var2) throws IOException, InterruptedException;

    public void runDirect(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        try {
            if (this.validate(is, os)) {
                this.runCommand(is, os);
            } else {
                this.onCommandUnsupported(is, os);
            }
        }
        finally {
            this.isFinished = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int processServerQuestion(String question, SDataOutputStream os, SDataInputStream is) throws IOException {
        int res = 0;
        if (question.equalsIgnoreCase("login")) {
            String userPlusAuth = this.m_auth.getUser();
            if (this.m_auth.getSessionID() != null) {
                userPlusAuth = String.valueOf(userPlusAuth) + '\u25ba' + this.m_auth.getSessionID();
            }
            os.writeUTF(userPlusAuth);
            String nextToken = is.readUTF();
            if (!nextToken.equalsIgnoreCase("password")) throw new IOException("login name unknown");
            os.writeUTF(this.m_auth.getPasswordEncrypted());
            String response = is.readUTF();
            if (response.equals("OK")) return res;
            throw new IOException(response);
        }
        if (!question.equalsIgnoreCase("valid")) return res;
        return 7;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isSuccess() {
        return this.isOKFinished;
    }

    public Object getResultObject() {
        return this.m_result;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(this.m_command);
        if (this.m_action != null) {
            res.append(" ").append(this.m_action);
        }
        if (this.m_parameters != null) {
            int i = 0;
            while (i < this.m_parameters.length) {
                res.append(" ").append(this.m_parameters[i]);
                ++i;
            }
        }
        return res.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ServerClient) {
            ServerClient sc = (ServerClient)obj;
            if ((this.m_command == sc.m_command || this.m_command != null && this.m_command.equals(sc.m_command)) && (this.m_action == sc.m_action || this.m_action != null && this.m_action.equals(sc.m_action))) {
                if (this.m_parameters == sc.m_parameters) {
                    return true;
                }
                if (this.m_parameters != null && sc.m_parameters != null && this.m_parameters.length == sc.m_parameters.length && this.m_parameters.length < 10) {
                    int i = 0;
                    while (i < this.m_parameters.length) {
                        if (!(this.m_parameters[i] == sc.m_parameters[i] || this.m_parameters[i] != null && this.m_parameters[i].equals(sc.m_parameters[i]))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.m_command == null ? 0 : this.m_command.hashCode();
    }

    public Throwable getLastException() {
        return this.m_lastException;
    }

    public Object getData(String key) {
        return this.m_optionalData.get(key);
    }

    public void setData(String key, Object obj) {
        this.m_optionalData.put(key, obj);
    }

    public void clearData() {
        this.m_optionalData.clear();
    }

    public String getAction() {
        return this.m_action;
    }

    public String[] getParameters() {
        return this.m_parameters;
    }

    @Deprecated
    public IODataStream[] getObjects() {
        return this.m_object;
    }

    @Deprecated
    public SEvent[] getEvents() {
        return this.m_events;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public Map<String, Object> getOptionalData() {
        return this.m_optionalData;
    }

    public IServerAuth getServerAuth() {
        return this.m_auth;
    }

    public String getCommand() {
        return this.m_command;
    }

    public List<ICmdPostProcess> getPostProcessors() {
        return this.m_cmdPostProcess;
    }

    protected void onCommandUnsupported(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        this.isSupported = false;
        RTLogger.print(4, "Unsupported command: " + this.getCommand());
    }

    public boolean validate(SDataInputStream is, SDataOutputStream os) throws IOException {
        boolean isCmdSupported = true;
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF(this.m_command);
        String answ = is.readUTF();
        if (T.equals(answ)) {
            isCmdSupported = true;
        } else if ("F".equals(answ)) {
            isCmdSupported = false;
        } else {
            throw new IOException("Server Error occured");
        }
        return isCmdSupported;
    }

    public boolean isTlsActive() {
        return this.isTlsActive;
    }

    public String getActiveTlsVersion() {
        return this.tlsVersion;
    }
}

