/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.TlsUtils;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.SCException;
import com.blixx.ctrl.sc.SCLoginException;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.log.RTLogger;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ServerClientBatch
extends ServerClient {
    protected Socket m_sock;
    protected SDataInputStream m_is;
    protected SDataOutputStream m_os;

    public ServerClientBatch(IServerAuth auth) {
        super(auth);
    }

    public void openSocket() throws SCException {
        this.m_sock = null;
        try {
            this.m_sock = new Socket();
            this.m_sock.bind(null);
            this.m_sock.setSoTimeout(60000);
            if (this.m_timeout > 0) {
                this.m_sock.setSoTimeout(this.m_timeout);
            }
            this.m_sock.setTcpNoDelay(true);
            this.m_sock.setSoLinger(true, 1);
            this.m_sock.connect(new InetSocketAddress(this.m_auth.getHostName(), this.m_auth.getPort()), 10000);
            this.m_is = new SDataInputStream(this.m_sock.getInputStream());
            this.m_os = new SDataOutputStream(this.m_sock.getOutputStream(), com.blixx.boom.engine.ServerClient.getDetectedServerProtocolVersion());
            if (BMUI.m_activateTls) {
                this.m_sock = TlsUtils.upgradeToTLS(this.m_sock);
            }
            String str = this.m_is.readUTF();
            com.blixx.boom.engine.ServerClient.setDetectedServerProtocolVersion(this.m_is.getLastProtocolVersion());
            int res = this.processServerQuestion(str, this.m_os, this.m_is);
            if (res != 0) {
                throw new SCLoginException("login failed");
            }
        }
        catch (Throwable e) {
            SCException re = new SCException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
    }

    public Object runBatch(ServerClient command) throws SCException {
        block5: {
            command.m_result = null;
            command.isOKFinished = false;
            command.isFinished = false;
            if (this.m_sock == null || this.m_sock.isClosed()) {
                this.openSocket();
            }
            try {
                command.runCommand(this.m_is, this.m_os);
            }
            catch (Throwable e) {
                if (this.m_sock != null && !this.m_sock.isClosed()) break block5;
                try {
                    this.openSocket();
                    command.runCommand(this.m_is, this.m_os);
                }
                catch (Throwable e1) {
                    RTLogger.print(1, "error processing " + this.m_command + " " + e.getMessage());
                    RTLogger.print(2, "", e);
                    throw new SCException(e1);
                }
            }
        }
        command.postProcess();
        return command.m_result;
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
    }

    public void close() {
        block23: {
            try {
                try {
                    this.m_os.writeUTF("EXIT");
                }
                catch (Throwable e) {
                    RTLogger.print(3, "", e);
                    RTLogger.print(3, "cmd batch finished");
                    try {
                        this.m_os.write(0);
                        this.m_os.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        this.m_is.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        this.m_sock.close();
                    }
                    catch (Throwable throwable) {}
                    break block23;
                }
            }
            catch (Throwable throwable) {
                RTLogger.print(3, "cmd batch finished");
                try {
                    this.m_os.write(0);
                    this.m_os.close();
                }
                catch (Throwable throwable2) {}
                try {
                    this.m_is.close();
                }
                catch (Throwable throwable3) {}
                try {
                    this.m_sock.close();
                }
                catch (Throwable throwable4) {}
                throw throwable;
            }
            RTLogger.print(3, "cmd batch finished");
            try {
                this.m_os.write(0);
                this.m_os.close();
            }
            catch (Throwable throwable) {}
            try {
                this.m_is.close();
            }
            catch (Throwable throwable) {}
            try {
                this.m_sock.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

