/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc.in;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.log.RTLogger;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ScGetAssigned
extends ServerClient {
    public ScGetAssigned(IServerAuth auth, String agentID) {
        super(auth);
        this.setCommand("GETASSIGNED", agentID);
    }

    @Override
    public GroupTreeObject getResultObject() {
        return (GroupTreeObject)this.m_result;
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        this.processAssigned(is, os);
    }

    public void processAssigned(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        AgentCard ac = Repository.getInstance().getAgentCard(this.m_action);
        RTLogger.print(5, "Request Assigned on Agent:" + ac + " ID:" + this.m_action);
        if (ac == null) {
            return;
        }
        ac.m_assignedMonitorPolicies.clear();
        ac.m_assignedMessagePolicies.clear();
        ac.m_assignedBinaries.clear();
        try {
            String version;
            String monitor;
            os.writeUTF(this.m_command);
            os.writeUTF(this.m_action);
            String type = is.readUTF();
            if (type.equals("F")) {
                ac.m_asn.clean();
                ac.m_asn.addElement(new GroupTreeObjectLast(new TreeObject("Agent can not be accessed", BMUI.type_agt, null), null, null));
                return;
            }
            int size = is.readInt();
            int i = 0;
            while (i < size) {
                monitor = is.readUTF();
                version = is.readUTF();
                version = String.valueOf(version) + this.checkVersions(version);
                ac.m_assignedMonitorPolicies.put(monitor, version);
                RTLogger.print(4, "Assigned: " + monitor + " ver=" + version);
                ++i;
            }
            type = is.readUTF();
            size = is.readInt();
            i = 0;
            while (i < size) {
                monitor = is.readUTF();
                version = is.readUTF();
                version = String.valueOf(version) + this.checkVersions(version);
                ac.m_assignedMessagePolicies.put(monitor, version);
                RTLogger.print(4, "Assigned: " + monitor + " ver=" + version);
                ++i;
            }
            type = is.readUTF();
            size = is.readInt();
            HashMap<String, String> singles = new HashMap<String, String>();
            HashMap<String, String> groups = new HashMap<String, String>();
            int i2 = 0;
            while (i2 < size) {
                String assignmentName = is.readUTF();
                String typeOfAssignment = is.readUTF();
                String userAssign = is.readUTF();
                is.readInt();
                if (!typeOfAssignment.equals(BMUI.type_assignment_pol)) {
                    if (typeOfAssignment.equals(BMUI.type_assignment_bin)) {
                        String state = "";
                        if (userAssign.length() > 0) {
                            state = userAssign;
                        }
                        ac.m_assignedBinaries.put(assignmentName, state);
                        RTLogger.print(5, "Assigned bin: " + assignmentName);
                    }
                    StringBuffer sb = new StringBuffer(assignmentName);
                    sb.append('_').append(typeOfAssignment);
                    singles.put(sb.toString(), typeOfAssignment);
                } else {
                    if (userAssign.length() == 32) {
                        typeOfAssignment = String.valueOf(typeOfAssignment) + userAssign;
                    }
                    groups.put(assignmentName, typeOfAssignment);
                }
                ++i2;
            }
            try {
                this.postProcessAssigned(ac, singles, groups);
            }
            catch (Throwable e) {
                RTLogger.print(5, "PPA3846", e);
            }
            String status = is.readUTF();
            if (status.equals("T")) {
                this.isOKFinished = true;
            }
        }
        catch (RuntimeException e) {
            ac.m_assignedMonitorPolicies.put("Failed to update list. Please retry", "");
            RTLogger.print(5, "PPA3946", e);
        }
        catch (Throwable e) {
            RTLogger.print(5, "PPA3546", e);
        }
    }

    private String checkVersions(String version) {
        String ok = " (OK)";
        if (version.indexOf("(DELETED)") != -1) {
            return " (X)";
        }
        String[] aa = version.split("[()]");
        if (aa.length >= 2 && !aa[0].trim().equals(aa[1].trim())) {
            ok = " (!)";
        }
        return ok;
    }

    private void postProcessAssigned(AgentCard ac, Map<String, String> singles, Map<String, String> groups) {
        String ver;
        if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, " Singles " + singles);
            RTLogger.print(5, " groups " + groups);
        }
        GroupTreeObject assignmentROOT = PolicyManager.getInstance().getAsnTree();
        ac.m_asn.clean();
        HashMap<String, String> tempDeleted = new HashMap<String, String>();
        Iterator<String> grIT = groups.keySet().iterator();
        LinkedList<String> processed = new LinkedList<String>();
        while (grIT.hasNext()) {
            String asGroup = grIT.next();
            groups.get(asGroup);
            GroupTreeObject assignment = assignmentROOT.searchPath("/root/Assignments/" + asGroup, BMUI.type_assignment_pol);
            if (assignment == null) continue;
            GroupTreeObject clone = null;
            try {
                clone = assignment.clone();
                clone.getTreeObject().setObject(clone.getName());
                ac.m_asn.addElement(clone);
            }
            catch (CloneNotSupportedException e) {
                RTLogger.print(4, "", e);
            }
            List<GroupTreeObjectLast> els = GroupTreeObject.collectElements(clone);
            for (GroupTreeObjectLast el : els) {
                String elementName = el.getName();
                if (singles.containsKey(el.getNameType()) || tempDeleted.containsKey(el.getNameType())) {
                    String type = el.getType();
                    List<GroupTreeObject> list = ac.m_asn.findElements(elementName, type);
                    for (GroupTreeObject gl : list) {
                        String val;
                        gl.getTreeObject().setObject(gl.getName());
                        String notDeployed = String.valueOf(gl.getName()) + " (X)";
                        if (type.equals(BMUI.type_msg)) {
                            val = ac.m_assignedMessagePolicies.get(elementName);
                            if (val == null) {
                                val = (String)tempDeleted.get(el.getNameType());
                                if (val == null) {
                                    gl.setName(notDeployed);
                                    this.checkInconsistent(clone, notDeployed);
                                    continue;
                                }
                                gl.setName(String.valueOf(gl.getName()) + " " + val);
                                continue;
                            }
                            tempDeleted.put(el.getNameType(), val);
                            gl.setName(String.valueOf(gl.getName()) + " " + val);
                            this.checkInconsistent(clone, val);
                            continue;
                        }
                        if (type.equals(BMUI.type_mon)) {
                            val = ac.m_assignedMonitorPolicies.get(elementName);
                            if (val == null) {
                                val = (String)tempDeleted.get(el.getNameType());
                                if (val == null) {
                                    gl.setName(notDeployed);
                                    this.checkInconsistent(clone, notDeployed);
                                    continue;
                                }
                                gl.setName(String.valueOf(gl.getName()) + " " + val);
                                continue;
                            }
                            tempDeleted.put(el.getNameType(), val);
                            gl.setName(String.valueOf(gl.getName()) + " " + val);
                            this.checkInconsistent(clone, val);
                            continue;
                        }
                        if (!type.equals(BMUI.type_assignment_bin)) continue;
                        val = ac.m_assignedBinaries.get(elementName);
                        if (val == null) {
                            val = (String)tempDeleted.get(el.getNameType());
                            if (val == null) {
                                gl.setName(notDeployed);
                                this.checkInconsistent(clone, notDeployed);
                                continue;
                            }
                            gl.setName(String.valueOf(gl.getName()) + " " + val);
                            continue;
                        }
                        tempDeleted.put(el.getNameType(), val);
                        gl.setName(String.valueOf(gl.getName()) + " " + val);
                        this.checkInconsistent(clone, val);
                    }
                    if (type.equals(BMUI.type_msg)) {
                        ac.m_assignedMessagePolicies.remove(elementName);
                    } else if (type.equals(BMUI.type_mon)) {
                        ac.m_assignedMonitorPolicies.remove(elementName);
                    } else if (type.equals(BMUI.type_assignment_bin)) {
                        ac.m_assignedBinaries.remove(elementName);
                    }
                    singles.remove(el.getTreeObject().getObject() + "_" + type);
                    processed.add(el.getTreeObject().getObject() + "_" + type);
                } else if (!processed.contains(el.getNameType())) {
                    el.getTreeObject().setObject(el.getName());
                    el.setName(String.valueOf(elementName) + " (X)");
                    String name = clone.getName();
                    if (!name.startsWith("!")) {
                        clone.setName("! " + name);
                    }
                }
                RTLogger.print(4, "Assigned GRP: " + asGroup + " EL: " + el + " OrigNameAsObject: " + el.getTreeObject().getObject());
            }
        }
        GroupTreeObject gtoSingles = new GroupTreeObject(new TreeObject("Single deployed", BMUI.type_folder, null));
        ac.m_asn.addElement(gtoSingles);
        for (String monName : ac.m_assignedMessagePolicies.keySet()) {
            ver = ac.m_assignedMessagePolicies.get(monName);
            gtoSingles.addElement(new GroupTreeObjectLast(new TreeObject(String.valueOf(monName) + " " + ver, BMUI.type_msg, monName), null, "IMAGE_MSG_LNK"));
            singles.remove(String.valueOf(monName) + "_" + BMUI.type_msg);
        }
        for (String monName : ac.m_assignedMonitorPolicies.keySet()) {
            ver = ac.m_assignedMonitorPolicies.get(monName);
            gtoSingles.addElement(new GroupTreeObjectLast(new TreeObject(String.valueOf(monName) + " " + ver, BMUI.type_mon, monName), null, "IMAGE_MON_LNK"));
            singles.remove(String.valueOf(monName) + "_" + BMUI.type_mon);
        }
        for (String monName : ac.m_assignedBinaries.keySet()) {
            ver = ac.m_assignedBinaries.get(monName);
            gtoSingles.addElement(new GroupTreeObjectLast(new TreeObject(String.valueOf(monName) + " " + ver, BMUI.type_assignment_bin, monName), null, "IMAGE_PKG_LNK"));
            singles.remove(String.valueOf(monName) + "_" + BMUI.type_assignment_bin);
        }
        for (String name : singles.keySet()) {
            String type = singles.get(name);
            name = name.substring(0, name.lastIndexOf(95));
            String icon = "IMAGE_UNKNOWN";
            if (type.equals(BMUI.type_mon)) {
                icon = "IMAGE_MON_LNK";
            } else if (type.equals(BMUI.type_msg)) {
                icon = "IMAGE_MSG_LNK";
            } else if (type.equals(BMUI.type_assignment_bin)) {
                icon = "IMAGE_PKG_LNK";
            }
            gtoSingles.addElement(new GroupTreeObjectLast(new TreeObject(String.valueOf(name) + " (X)", type, name), null, icon));
        }
        this.m_result = ac.m_asn;
    }

    private void checkInconsistent(GroupTreeObject assignment, Object val) {
        String name;
        String string = val.toString();
        if (string.indexOf(40) != -1 && (string.endsWith("(!)") || string.endsWith("(DELETED)") || string.endsWith("(X)")) && !(name = assignment.getName()).startsWith("!")) {
            assignment.setName("! " + name);
        }
    }
}

