/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.shared.os.SystemUtils;
import com.blixx.shared.utils.StrUtils;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExecUtils {
    public static final String EMERGENCY_UNIX_PATH = "PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local:/usr/local/bin:/usr/local/sbin";
    public static final String EMERGENCY_WIN_PATH = "Path=%SystemRoot%;%SystemRoot%\\system32";
    public static final String EMERGENCY_UNIX_LDATH = "LD_LIBRARY_PATH=/lib:/usr/lib:/usr/share/lib";
    public static final int MAX_CHARS_TOREAD = 0x800000;
    private static String[] envp = null;
    Charset s_charset = Charset.defaultCharset();
    private static Charset m_win_charset;
    private static Map<String, String> envMap;
    private Map<InputStream, CharArrayWriter> m_tempBuffer = new HashMap<InputStream, CharArrayWriter>(3, 100.0f);
    private int m_totalBytes = 0;
    private static boolean isWindows;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        envMap = new HashMap<String, String>();
        isWindows = false;
        Class<ExecUtils> clazz = ExecUtils.class;
        synchronized (ExecUtils.class) {
            for (Map.Entry<Object, Object> en : System.getProperties().entrySet()) {
                if (en.getKey() == null || en.getValue() == null || !(en.getValue() instanceof String) || !(en.getKey() instanceof String)) continue;
                envMap.put((String)en.getKey(), (String)en.getValue());
            }
            envMap.putAll(System.getenv());
            Iterator<String> it0 = envMap.keySet().iterator();
            while (it0.hasNext()) {
                String name = it0.next();
                if (!name.startsWith("java.") && !name.startsWith("sun.") && !name.startsWith("awt.")) continue;
                it0.remove();
            }
            ManagementFactory.getOperatingSystemMXBean();
            String osName = System.getProperty("os.name");
            if (osName != null && osName.toLowerCase().contains("windows")) {
                isWindows = true;
            }
            if (!isWindows) {
                envp = new String[envMap.size() + 1];
                ExecUtils.envp[ExecUtils.envMap.size()] = "UNIX95=1";
            } else {
                envp = new String[envMap.size()];
                ExecUtils.getWindowsConsoleCharset();
                if (m_win_charset == null) {
                    RTLogger.print(2, "CHARSET can't be detected");
                }
            }
            int i = 0;
            boolean pathFound = false;
            boolean ldPathFound = false;
            for (String name : envMap.keySet()) {
                if ("PATH".equalsIgnoreCase(name)) {
                    pathFound = true;
                }
                if ("LD_LIBRARY_PATH".equalsIgnoreCase(name)) {
                    ldPathFound = true;
                }
                ExecUtils.envp[i] = String.valueOf(name) + "=" + envMap.get(name);
                RTLogger.print(3, "ENV>> " + envp[i]);
                ++i;
            }
            if (!pathFound) {
                if (!isWindows) {
                    ExecUtils.addEnvVariable(EMERGENCY_UNIX_PATH);
                } else {
                    ExecUtils.addEnvVariable(EMERGENCY_WIN_PATH);
                }
            }
            if (!ldPathFound && !isWindows) {
                ExecUtils.addEnvVariable(EMERGENCY_UNIX_LDATH);
            }
            ExecUtils.setPATHForUnix();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void addEnvVariable(String variable) {
        String[] nenvp = new String[envp.length + 1];
        System.arraycopy(envp, 0, nenvp, 0, envp.length);
        nenvp[ExecUtils.envp.length] = variable;
        envp = nenvp;
    }

    public static void setPATHForUnix() {
        StringBuilder sb = new StringBuilder();
        File root = new File("spi");
        if (root.exists() && root.isDirectory()) {
            ExecUtils.addSubDirs(sb, root);
            sb.append("spi");
            int i = 0;
            while (i < envp.length) {
                if (envp[i].startsWith("PATH=") || envp[i].startsWith("Path=") || envp[i].startsWith("LD_LIBRARY_PATH=") || envp[i].startsWith("java.library.path=")) {
                    if (!envp[i].contains(sb)) {
                        ExecUtils.envp[i] = String.valueOf(envp[i]) + File.pathSeparatorChar + sb.toString();
                    }
                    RTLogger.print(3, "ENV>> " + envp[i]);
                }
                ++i;
            }
        }
    }

    public static void addSubDirs(StringBuilder sb, File root) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        File[] files = root.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                try {
                    String nn = String.valueOf(files[i].getPath()) + File.pathSeparatorChar;
                    if (sb.indexOf(nn) == -1) {
                        sb.append(nn);
                    }
                }
                catch (Throwable throwable) {}
                ExecUtils.addSubDirs(sb, files[i]);
            }
            ++i;
        }
    }

    private ExecUtils() {
        if (SystemUtils.UNIX_WHO == 6) {
            String codePage = System.getProperty("os400.job.file.encoding");
            try {
                this.s_charset = Charset.forName(codePage);
            }
            catch (Throwable throwable) {
                RTLogger.print(1, "Error init charset: " + codePage);
            }
        }
    }

    public static synchronized Process execRuntime(String cmd) throws IOException {
        cmd = cmd.trim();
        return Runtime.getRuntime().exec(cmd);
    }

    public static synchronized Process execRuntime(String[] cmd) throws IOException {
        return Runtime.getRuntime().exec(cmd);
    }

    public static ExecResult exec2(String cmd, File workingDir, int seconds) throws IOException {
        if (workingDir == null) {
            workingDir = new File(".");
        }
        cmd = cmd.trim();
        RTLogger.print(3, "Exec: " + cmd);
        ExecResult result = new ExecUtils().exec2(cmd, SystemUtils.OS, workingDir, seconds);
        return result;
    }

    ExecResult exec2(String cmd, int os, File workingDir, int seconds) throws IOException {
        if (cmd == null) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (os) {
            case 1: {
                return this.execWindows2(cmd, workingDir, seconds);
            }
            case 2: {
                return this.execUnix2(cmd, workingDir, seconds);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    /*
     * Unable to fully structure code
     */
    private ExecResult execUnix2(String cmd, File workingDir, int seconds) throws IOException {
        block290: {
            block285: {
                block292: {
                    block286: {
                        block288: {
                            in = null;
                            err = null;
                            errorStream = null;
                            inputStream = null;
                            result = new ExecResult();
                            pr = null;
                            su = new StrUtils();
                            inCMD = su.processQuoted(cmd);
                            i = 0;
                            while (i < inCMD.length) {
                                inCMD[i] = su.removeQuotes(inCMD[i]);
                                ++i;
                            }
                            RTLogger.print(5, "Exec recon3: " + Arrays.toString(inCMD));
                            startTime = System.currentTimeMillis();
                            maxWaitTime = startTime + (long)(seconds * 1000);
                            try {
                                pr = Runtime.getRuntime().exec((String[])inCMD, ExecUtils.envp, workingDir);
                                errorStream = pr.getErrorStream();
                                inputStream = pr.getInputStream();
                                err = new InputStreamReader(errorStream, this.s_charset);
                                in = new InputStreamReader(inputStream, this.s_charset);
                                this.readResults(in, err, errorStream, inputStream, result);
                                break block285;
                            }
                            catch (Throwable v0) {
                                if (pr != null) break block286;
                                maxWaitTime = 0L;
                                result.resultCode = 1;
                                result.m_errorMessages.add("Error executing command: " + cmd);
                                var17_15 = result;
                                sec = 0L;
                                ** while (System.currentTimeMillis() < maxWaitTime)
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (sec != (maxWaitTime - System.currentTimeMillis()) / 1000L) {
                                    sec = (maxWaitTime - System.currentTimeMillis()) / 1000L;
                                    RTLogger.print(5, "Exec: seconds to wait=" + (maxWaitTime - System.currentTimeMillis()) / 1000L);
                                }
                                result.resultCode = pr.exitValue();
                                this.readTillEnd(in, err, inputStream, errorStream, result);
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException v1) {}
                                break;
                                catch (IllegalThreadStateException v2) {
                                    RTLogger.print(5, String.valueOf(Arrays.toString(inCMD)) + " process still running");
                                    this.readDuringRun(in, err, errorStream, inputStream, result);
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException v3) {}
                                    continue;
                                }
                                catch (Throwable v4) {
                                    ** try [egrp 6[TRYBLOCK] [8 : 393->394)] { 
lbl-1000:
                                    // 3 sources

                                    {
                                        catch (Throwable var20_20) {
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (InterruptedException v5) {}
                                            throw var20_20;
                                        }
                                    }
lbl63:
                                    // 1 sources

                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException v6) {}
                                    continue;
                                }
                            }
lbl68:
                            // 3 sources

                            if (maxWaitTime > 0L && System.currentTimeMillis() >= maxWaitTime) {
                                result.resultCode = 0x7FFFFFFF;
                                RTLogger.print(5, String.valueOf(Arrays.toString(inCMD)) + "Process has been not finished. Timeout reached");
                            }
                            try {
                                caw = this.m_tempBuffer.get(errorStream);
                                if (caw != null && caw.size() > 0) {
                                    result.m_errorMessages.add(caw.toString());
                                }
                            }
                            catch (Throwable v7) {}
                            try {
                                try {
                                    caw = this.m_tempBuffer.get(inputStream);
                                    if (caw != null && caw.size() > 0) {
                                        result.m_outMessages.add(caw.toString());
                                    }
                                }
                                catch (Throwable v8) {
                                    this.m_tempBuffer.clear();
                                    if (in != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable v9) {}
                                    }
                                    if (err != null) {
                                        try {
                                            err.close();
                                        }
                                        catch (Throwable v10) {}
                                    }
                                    if (inputStream != null) {
                                        try {
                                            inputStream.close();
                                        }
                                        catch (Throwable v11) {}
                                    }
                                    if (errorStream != null) {
                                        try {
                                            errorStream.close();
                                        }
                                        catch (Throwable v12) {}
                                    }
                                    if (pr != null && pr.getOutputStream() != null) {
                                        try {
                                            pr.getOutputStream().close();
                                        }
                                        catch (Throwable v13) {}
                                    }
                                    break block288;
                                }
                            }
                            catch (Throwable var21_28) {
                                this.m_tempBuffer.clear();
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable v14) {}
                                }
                                if (err != null) {
                                    try {
                                        err.close();
                                    }
                                    catch (Throwable v15) {}
                                }
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable v16) {}
                                }
                                if (errorStream != null) {
                                    try {
                                        errorStream.close();
                                    }
                                    catch (Throwable v17) {}
                                }
                                if (pr != null && pr.getOutputStream() != null) {
                                    try {
                                        pr.getOutputStream().close();
                                    }
                                    catch (Throwable v18) {}
                                }
                                throw var21_28;
                            }
                            this.m_tempBuffer.clear();
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable v19) {}
                            }
                            if (err != null) {
                                try {
                                    err.close();
                                }
                                catch (Throwable v20) {}
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable v21) {}
                            }
                            if (errorStream != null) {
                                try {
                                    errorStream.close();
                                }
                                catch (Throwable v22) {}
                            }
                            if (pr != null && pr.getOutputStream() != null) {
                                try {
                                    pr.getOutputStream().close();
                                }
                                catch (Throwable v23) {}
                            }
                        }
                        return var17_15;
                    }
                    sec = 0L;
                    while (System.currentTimeMillis() < maxWaitTime) {
                        if (sec != (maxWaitTime - System.currentTimeMillis()) / 1000L) {
                            sec = (maxWaitTime - System.currentTimeMillis()) / 1000L;
                            RTLogger.print(5, "Exec: seconds to wait=" + (maxWaitTime - System.currentTimeMillis()) / 1000L);
                        }
                        result.resultCode = pr.exitValue();
                        this.readTillEnd(in, err, inputStream, errorStream, result);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException v24) {}
                        break;
                        catch (IllegalThreadStateException v25) {
                            RTLogger.print(5, String.valueOf(Arrays.toString(inCMD)) + " process still running");
                            this.readDuringRun(in, err, errorStream, inputStream, result);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException v26) {}
                            continue;
                        }
                        catch (Throwable v27) {
                            ** try [egrp 31[TRYBLOCK] [35 : 1019->1020)] { 
lbl-1000:
                            // 3 sources

                            {
                                catch (Throwable caw) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException v28) {}
                                    throw caw;
                                }
                            }
lbl201:
                            // 1 sources

                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException v29) {}
                        }
                    }
                    if (maxWaitTime > 0L && System.currentTimeMillis() >= maxWaitTime) {
                        result.resultCode = 0x7FFFFFFF;
                        RTLogger.print(5, String.valueOf(Arrays.toString(inCMD)) + "Process has been not finished. Timeout reached");
                    }
                    try {
                        caw = this.m_tempBuffer.get(errorStream);
                        if (caw != null && caw.size() > 0) {
                            result.m_errorMessages.add(caw.toString());
                        }
                    }
                    catch (Throwable v30) {}
                    try {
                        try {
                            caw = this.m_tempBuffer.get(inputStream);
                            if (caw != null && caw.size() > 0) {
                                result.m_outMessages.add(caw.toString());
                            }
                        }
                        catch (Throwable v31) {
                            this.m_tempBuffer.clear();
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable v32) {}
                            }
                            if (err != null) {
                                try {
                                    err.close();
                                }
                                catch (Throwable v33) {}
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable v34) {}
                            }
                            if (errorStream != null) {
                                try {
                                    errorStream.close();
                                }
                                catch (Throwable v35) {}
                            }
                            if (pr != null && pr.getOutputStream() != null) {
                                try {
                                    pr.getOutputStream().close();
                                }
                                catch (Throwable v36) {}
                            }
                            break block290;
                        }
                    }
                    catch (Throwable var21_29) {
                        this.m_tempBuffer.clear();
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable v37) {}
                        }
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (Throwable v38) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable v39) {}
                        }
                        if (errorStream != null) {
                            try {
                                errorStream.close();
                            }
                            catch (Throwable v40) {}
                        }
                        if (pr != null && pr.getOutputStream() != null) {
                            try {
                                pr.getOutputStream().close();
                            }
                            catch (Throwable v41) {}
                        }
                        throw var21_29;
                    }
                    this.m_tempBuffer.clear();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable v42) {}
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable v43) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable v44) {}
                    }
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable v45) {}
                    }
                    if (pr != null && pr.getOutputStream() != null) {
                        try {
                            pr.getOutputStream().close();
                        }
                        catch (Throwable v46) {}
                    }
                    break block290;
                    catch (Throwable var16_32) {
                        sec = 0L;
                        ** while (System.currentTimeMillis() < maxWaitTime)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (sec != (maxWaitTime - System.currentTimeMillis()) / 1000L) {
                            sec = (maxWaitTime - System.currentTimeMillis()) / 1000L;
                            RTLogger.print(5, "Exec: seconds to wait=" + (maxWaitTime - System.currentTimeMillis()) / 1000L);
                        }
                        result.resultCode = pr.exitValue();
                        this.readTillEnd(in, err, inputStream, errorStream, result);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException v47) {}
                        break;
                        catch (IllegalThreadStateException v48) {
                            RTLogger.print(5, String.valueOf(Arrays.toString(inCMD)) + " process still running");
                            this.readDuringRun(in, err, errorStream, inputStream, result);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException v49) {}
                            continue;
                        }
                        catch (Throwable v50) {
                            ** try [egrp 56[TRYBLOCK] [63 : 1647->1648)] { 
lbl-1000:
                            // 3 sources

                            {
                                catch (Throwable caw) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException v51) {}
                                    throw caw;
                                }
                            }
lbl338:
                            // 1 sources

                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException v52) {}
                            continue;
                        }
                    }
lbl343:
                    // 3 sources

                    if (maxWaitTime > 0L && System.currentTimeMillis() >= maxWaitTime) {
                        result.resultCode = 0x7FFFFFFF;
                        RTLogger.print(5, String.valueOf(Arrays.toString(inCMD)) + "Process has been not finished. Timeout reached");
                    }
                    try {
                        caw = this.m_tempBuffer.get(errorStream);
                        if (caw != null && caw.size() > 0) {
                            result.m_errorMessages.add(caw.toString());
                        }
                    }
                    catch (Throwable v53) {}
                    try {
                        try {
                            caw = this.m_tempBuffer.get(inputStream);
                            if (caw != null && caw.size() > 0) {
                                result.m_outMessages.add(caw.toString());
                            }
                        }
                        catch (Throwable v54) {
                            this.m_tempBuffer.clear();
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable v55) {}
                            }
                            if (err != null) {
                                try {
                                    err.close();
                                }
                                catch (Throwable v56) {}
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable v57) {}
                            }
                            if (errorStream != null) {
                                try {
                                    errorStream.close();
                                }
                                catch (Throwable v58) {}
                            }
                            if (pr != null && pr.getOutputStream() != null) {
                                try {
                                    pr.getOutputStream().close();
                                }
                                catch (Throwable v59) {}
                            }
                            break block292;
                        }
                    }
                    catch (Throwable var21_30) {
                        this.m_tempBuffer.clear();
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable v60) {}
                        }
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (Throwable v61) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable v62) {}
                        }
                        if (errorStream != null) {
                            try {
                                errorStream.close();
                            }
                            catch (Throwable v63) {}
                        }
                        if (pr != null && pr.getOutputStream() != null) {
                            try {
                                pr.getOutputStream().close();
                            }
                            catch (Throwable v64) {}
                        }
                        throw var21_30;
                    }
                    this.m_tempBuffer.clear();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable v65) {}
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable v66) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable v67) {}
                    }
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable v68) {}
                    }
                    if (pr != null && pr.getOutputStream() != null) {
                        try {
                            pr.getOutputStream().close();
                        }
                        catch (Throwable v69) {}
                    }
                }
                throw var16_32;
            }
            sec = 0L;
            while (System.currentTimeMillis() < maxWaitTime) {
                if (sec != (maxWaitTime - System.currentTimeMillis()) / 1000L) {
                    sec = (maxWaitTime - System.currentTimeMillis()) / 1000L;
                    RTLogger.print(5, "Exec: seconds to wait=" + (maxWaitTime - System.currentTimeMillis()) / 1000L);
                }
                result.resultCode = pr.exitValue();
                this.readTillEnd(in, err, inputStream, errorStream, result);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException v70) {}
                break;
                catch (IllegalThreadStateException v71) {
                    RTLogger.print(5, String.valueOf(Arrays.toString(inCMD)) + " process still running");
                    this.readDuringRun(in, err, errorStream, inputStream, result);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException v72) {}
                    continue;
                }
                catch (Throwable v73) {
                    ** try [egrp 81[TRYBLOCK] [90 : 2273->2274)] { 
lbl-1000:
                    // 3 sources

                    {
                        catch (Throwable caw) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException v74) {}
                            throw caw;
                        }
                    }
lbl476:
                    // 1 sources

                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException v75) {}
                }
            }
            if (maxWaitTime > 0L && System.currentTimeMillis() >= maxWaitTime) {
                result.resultCode = 0x7FFFFFFF;
                RTLogger.print(5, String.valueOf(Arrays.toString(inCMD)) + "Process has been not finished. Timeout reached");
            }
            try {
                caw = this.m_tempBuffer.get(errorStream);
                if (caw != null && caw.size() > 0) {
                    result.m_errorMessages.add(caw.toString());
                }
            }
            catch (Throwable v76) {}
            try {
                try {
                    caw = this.m_tempBuffer.get(inputStream);
                    if (caw != null && caw.size() > 0) {
                        result.m_outMessages.add(caw.toString());
                    }
                }
                catch (Throwable v77) {
                    this.m_tempBuffer.clear();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable v78) {}
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable v79) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable v80) {}
                    }
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable v81) {}
                    }
                    if (pr != null && pr.getOutputStream() != null) {
                        try {
                            pr.getOutputStream().close();
                        }
                        catch (Throwable v82) {}
                    }
                    break block290;
                }
            }
            catch (Throwable var21_31) {
                this.m_tempBuffer.clear();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable v83) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Throwable v84) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable v85) {}
                }
                if (errorStream != null) {
                    try {
                        errorStream.close();
                    }
                    catch (Throwable v86) {}
                }
                if (pr != null && pr.getOutputStream() != null) {
                    try {
                        pr.getOutputStream().close();
                    }
                    catch (Throwable v87) {}
                }
                throw var21_31;
            }
            this.m_tempBuffer.clear();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable v88) {}
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (Throwable v89) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable v90) {}
            }
            if (errorStream != null) {
                try {
                    errorStream.close();
                }
                catch (Throwable v91) {}
            }
            if (pr != null && pr.getOutputStream() != null) {
                try {
                    pr.getOutputStream().close();
                }
                catch (Throwable v92) {}
            }
        }
        return result;
    }

    private void readDuringRun(InputStreamReader in, InputStreamReader err, InputStream errorStream, InputStream inputStream, ExecResult result) throws IOException {
        this.readInputStream(err, errorStream, result.m_errorMessages);
        this.readInputStream(in, inputStream, result.m_outMessages);
    }

    private void readTillEnd(InputStreamReader in, InputStreamReader err, InputStream inIS, InputStream errIS, ExecResult result) {
        try {
            this.readInputStreamTillEnd(err, errIS, result.m_errorMessages);
        }
        catch (Throwable throwable) {}
        try {
            this.readInputStreamTillEnd(in, inIS, result.m_outMessages);
        }
        catch (Throwable throwable) {}
    }

    private void readResults(InputStreamReader in, InputStreamReader err, InputStream errorStream, InputStream inputStream, ExecResult result) throws IOException {
        if (!in.ready() && !err.ready()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.readInputStream(err, errorStream, result.m_errorMessages);
        this.readInputStream(in, inputStream, result.m_outMessages);
    }

    private void readInputStream(InputStreamReader isr, InputStream is, List<String> output) throws IOException {
        if (isr == null) {
            return;
        }
        char[] arr = new char[1024];
        int count = 0;
        if (!isr.ready()) {
            return;
        }
        CharArrayWriter caw = this.m_tempBuffer.get(is);
        if (caw == null) {
            caw = new CharArrayWriter(1024);
            this.m_tempBuffer.put(is, caw);
        }
        while (is.available() > 0 && (count = isr.read(arr)) > 0) {
            if (this.m_totalBytes >= 0x800000) continue;
            int i = 0;
            while (i < count) {
                char ch = arr[i];
                if ('\r' != ch) {
                    if ('\n' == ch) {
                        String line = caw.toString();
                        output.add(line);
                        caw.reset();
                        RTLogger.print(6, String.valueOf('\t') + line);
                    } else {
                        caw.append(ch);
                        ++this.m_totalBytes;
                    }
                }
                ++i;
            }
        }
    }

    private void readInputStreamTillEnd(InputStreamReader isr, InputStream is, List<String> output) throws IOException {
        if (isr == null) {
            return;
        }
        char[] arr = new char[1024];
        int count = 0;
        if (isr != null && !isr.ready()) {
            return;
        }
        CharArrayWriter caw = this.m_tempBuffer.get(is);
        if (caw == null) {
            caw = new CharArrayWriter(1024);
            this.m_tempBuffer.put(is, caw);
        }
        while ((count = isr.read(arr)) != -1) {
            if (this.m_totalBytes >= 0x800000) continue;
            int i = 0;
            while (i < count) {
                char ch = arr[i];
                if ('\r' != ch) {
                    if ('\n' == ch) {
                        String line = caw.toString();
                        output.add(line);
                        caw.reset();
                        RTLogger.print(6, String.valueOf('\t') + line);
                    } else {
                        caw.append(ch);
                        ++this.m_totalBytes;
                    }
                }
                ++i;
            }
        }
        if (caw.size() > 0) {
            output.add(caw.toString());
            caw.reset();
        }
    }

    /*
     * Unable to fully structure code
     */
    private ExecResult execWindows2(String cmd, File workingDir, int sec) throws IOException {
        block291: {
            block293: {
                block287: {
                    block289: {
                        seconds = sec;
                        cmdAttrbs = new String[]{"cmd.exe", "/C", cmd};
                        su = new StrUtils();
                        arrPrg = su.processQuoted(cmd);
                        if (arrPrg != null && arrPrg.length > 0) {
                            programm = su.removeQuotesStrict(arrPrg[0]);
                            prgLowerCase = (programm = programm.replace("\"", "")).toLowerCase();
                            if (prgLowerCase.endsWith(".exe") || prgLowerCase.endsWith(".com") || prgLowerCase.endsWith(".application") || prgLowerCase.endsWith(".gadget")) {
                                prg = new File(workingDir, programm);
                                if (prg.exists() && prg.isFile() && prg.length() == 0L) {
                                    throw new IOException("Can't start application. It's a zero-size file: " + programm);
                                }
                                prg = new File(programm);
                                if (prg.exists() && prg.isFile() && prg.length() == 0L) {
                                    throw new IOException("Can't start application. It's a zero-size file: " + programm);
                                }
                            }
                        }
                        in = null;
                        err = null;
                        result = new ExecResult();
                        pr = null;
                        errorStream = null;
                        inputStream = null;
                        startTime = System.currentTimeMillis();
                        maxWaitTime = startTime + (long)(seconds * 1000);
                        try {
                            pr = Runtime.getRuntime().exec(cmdAttrbs, ExecUtils.envp, workingDir);
                            errorStream = pr.getErrorStream();
                            inputStream = pr.getInputStream();
                            if (ExecUtils.m_win_charset != null) {
                                in = new InputStreamReader(inputStream, ExecUtils.m_win_charset);
                                err = new InputStreamReader(errorStream, ExecUtils.m_win_charset);
                            } else {
                                in = new InputStreamReader(inputStream);
                                err = new InputStreamReader(errorStream);
                            }
                            this.readResults(in, err, errorStream, inputStream, result);
                            if (true) ** GOTO lbl497
                        }
                        catch (Throwable e) {
                            if (pr != null) break block287;
                            maxWaitTime = 0L;
                            result.resultCode = 1;
                            result.m_errorMessages.add("Exec cannot create a Process object.");
                            var20_17 = result;
                            ** while (System.currentTimeMillis() < maxWaitTime)
                        }
lbl-1000:
                        // 1 sources

                        {
                            result.resultCode = pr.exitValue();
                            this.readTillEnd(in, err, inputStream, errorStream, result);
                            --seconds;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException v0) {}
                            break;
                            catch (IllegalThreadStateException v1) {
                                this.readDuringRun(in, err, errorStream, inputStream, result);
                                --seconds;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException v2) {}
                                continue;
                            }
                            catch (Throwable v3) {
                                --seconds;
                                {
                                    catch (Throwable var21_18) {
                                        --seconds;
                                        try {
                                            Thread.sleep(100L);
                                        }
                                        catch (InterruptedException v4) {}
                                        throw var21_18;
                                    }
                                }
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException v5) {}
                                continue;
                            }
                        }
lbl77:
                        // 3 sources

                        if (maxWaitTime != 0L && System.currentTimeMillis() >= maxWaitTime) {
                            result.resultCode = 1;
                            error = "Timeout! Process has been not finished in specified " + sec + " seconds.";
                            result.m_errorMessages.add(error);
                            RTLogger.print(5, error);
                        }
                        try {
                            caw = this.m_tempBuffer.get(errorStream);
                            if (caw != null && caw.size() > 0) {
                                result.m_errorMessages.add(caw.toString());
                            }
                        }
                        catch (Throwable v6) {}
                        try {
                            try {
                                caw = this.m_tempBuffer.get(inputStream);
                                if (caw != null && caw.size() > 0) {
                                    result.m_outMessages.add(caw.toString());
                                }
                            }
                            catch (Throwable v7) {
                                this.m_tempBuffer.clear();
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable v8) {}
                                }
                                if (err != null) {
                                    try {
                                        err.close();
                                    }
                                    catch (Throwable v9) {}
                                }
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable v10) {}
                                }
                                if (errorStream != null) {
                                    try {
                                        errorStream.close();
                                    }
                                    catch (Throwable v11) {}
                                }
                                if (pr != null && pr.getOutputStream() != null) {
                                    try {
                                        pr.getOutputStream().close();
                                    }
                                    catch (Throwable v12) {}
                                }
                                break block289;
                            }
                        }
                        catch (Throwable var22_26) {
                            this.m_tempBuffer.clear();
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable v13) {}
                            }
                            if (err != null) {
                                try {
                                    err.close();
                                }
                                catch (Throwable v14) {}
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable v15) {}
                            }
                            if (errorStream != null) {
                                try {
                                    errorStream.close();
                                }
                                catch (Throwable v16) {}
                            }
                            if (pr != null && pr.getOutputStream() != null) {
                                try {
                                    pr.getOutputStream().close();
                                }
                                catch (Throwable v17) {}
                            }
                            throw var22_26;
                        }
                        this.m_tempBuffer.clear();
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable v18) {}
                        }
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (Throwable v19) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable v20) {}
                        }
                        if (errorStream != null) {
                            try {
                                errorStream.close();
                            }
                            catch (Throwable v21) {}
                        }
                        if (pr != null && pr.getOutputStream() != null) {
                            try {
                                pr.getOutputStream().close();
                            }
                            catch (Throwable v22) {}
                        }
                    }
                    return var20_17;
                }
                RTLogger.print(5, "Exec failed. ", e);
                ** while (System.currentTimeMillis() < maxWaitTime)
lbl-1000:
                // 1 sources

                {
                    result.resultCode = pr.exitValue();
                    this.readTillEnd(in, err, inputStream, errorStream, result);
                    --seconds;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException v23) {}
                    break;
                    catch (IllegalThreadStateException v24) {
                        this.readDuringRun(in, err, errorStream, inputStream, result);
                        --seconds;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException v25) {}
                        continue;
                    }
                    catch (Throwable v26) {
                        --seconds;
                        {
                            catch (Throwable caw) {
                                --seconds;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException v27) {}
                                throw caw;
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException v28) {}
                        continue;
                    }
                }
lbl219:
                // 3 sources

                if (maxWaitTime != 0L && System.currentTimeMillis() >= maxWaitTime) {
                    result.resultCode = 1;
                    error = "Timeout! Process has been not finished in specified " + sec + " seconds.";
                    result.m_errorMessages.add(error);
                    RTLogger.print(5, error);
                }
                try {
                    caw = this.m_tempBuffer.get(errorStream);
                    if (caw != null && caw.size() > 0) {
                        result.m_errorMessages.add(caw.toString());
                    }
                }
                catch (Throwable v29) {}
                try {
                    try {
                        caw = this.m_tempBuffer.get(inputStream);
                        if (caw != null && caw.size() > 0) {
                            result.m_outMessages.add(caw.toString());
                        }
                    }
                    catch (Throwable v30) {
                        this.m_tempBuffer.clear();
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable v31) {}
                        }
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (Throwable v32) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable v33) {}
                        }
                        if (errorStream != null) {
                            try {
                                errorStream.close();
                            }
                            catch (Throwable v34) {}
                        }
                        if (pr != null && pr.getOutputStream() != null) {
                            try {
                                pr.getOutputStream().close();
                            }
                            catch (Throwable v35) {}
                        }
                        break block291;
                    }
                }
                catch (Throwable var22_27) {
                    this.m_tempBuffer.clear();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable v36) {}
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable v37) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable v38) {}
                    }
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable v39) {}
                    }
                    if (pr != null && pr.getOutputStream() != null) {
                        try {
                            pr.getOutputStream().close();
                        }
                        catch (Throwable v40) {}
                    }
                    throw var22_27;
                }
                this.m_tempBuffer.clear();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable v41) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Throwable v42) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable v43) {}
                }
                if (errorStream != null) {
                    try {
                        errorStream.close();
                    }
                    catch (Throwable v44) {}
                }
                if (pr != null && pr.getOutputStream() != null) {
                    try {
                        pr.getOutputStream().close();
                    }
                    catch (Throwable v45) {}
                }
                break block291;
                catch (Throwable var19_30) {
                    ** while (System.currentTimeMillis() < maxWaitTime)
                }
lbl-1000:
                // 1 sources

                {
                    result.resultCode = pr.exitValue();
                    this.readTillEnd(in, err, inputStream, errorStream, result);
                    --seconds;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException v46) {}
                    break;
                    catch (IllegalThreadStateException v47) {
                        this.readDuringRun(in, err, errorStream, inputStream, result);
                        --seconds;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException v48) {}
                        continue;
                    }
                    catch (Throwable v49) {
                        --seconds;
                        {
                            catch (Throwable caw) {
                                --seconds;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException v50) {}
                                throw caw;
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException v51) {}
                        continue;
                    }
                }
lbl358:
                // 3 sources

                if (maxWaitTime != 0L && System.currentTimeMillis() >= maxWaitTime) {
                    result.resultCode = 1;
                    error = "Timeout! Process has been not finished in specified " + sec + " seconds.";
                    result.m_errorMessages.add(error);
                    RTLogger.print(5, error);
                }
                try {
                    caw = this.m_tempBuffer.get(errorStream);
                    if (caw != null && caw.size() > 0) {
                        result.m_errorMessages.add(caw.toString());
                    }
                }
                catch (Throwable v52) {}
                try {
                    try {
                        caw = this.m_tempBuffer.get(inputStream);
                        if (caw != null && caw.size() > 0) {
                            result.m_outMessages.add(caw.toString());
                        }
                    }
                    catch (Throwable v53) {
                        this.m_tempBuffer.clear();
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable v54) {}
                        }
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (Throwable v55) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable v56) {}
                        }
                        if (errorStream != null) {
                            try {
                                errorStream.close();
                            }
                            catch (Throwable v57) {}
                        }
                        if (pr != null && pr.getOutputStream() != null) {
                            try {
                                pr.getOutputStream().close();
                            }
                            catch (Throwable v58) {}
                        }
                        break block293;
                    }
                }
                catch (Throwable var22_28) {
                    this.m_tempBuffer.clear();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable v59) {}
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable v60) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable v61) {}
                    }
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable v62) {}
                    }
                    if (pr != null && pr.getOutputStream() != null) {
                        try {
                            pr.getOutputStream().close();
                        }
                        catch (Throwable v63) {}
                    }
                    throw var22_28;
                }
                this.m_tempBuffer.clear();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable v64) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Throwable v65) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable v66) {}
                }
                if (errorStream != null) {
                    try {
                        errorStream.close();
                    }
                    catch (Throwable v67) {}
                }
                if (pr != null && pr.getOutputStream() != null) {
                    try {
                        pr.getOutputStream().close();
                    }
                    catch (Throwable v68) {}
                }
            }
            throw var19_30;
            do {
                result.resultCode = pr.exitValue();
                this.readTillEnd(in, err, inputStream, errorStream, result);
                --seconds;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException v69) {}
                break;
                catch (IllegalThreadStateException v70) {
                    this.readDuringRun(in, err, errorStream, inputStream, result);
                    --seconds;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException v71) {}
                    continue;
                }
                catch (Throwable v72) {
                    --seconds;
                    {
                        catch (Throwable caw) {
                            --seconds;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException v73) {}
                            throw caw;
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException v74) {}
                }
lbl497:
                // 5 sources

            } while (System.currentTimeMillis() < maxWaitTime);
            if (maxWaitTime != 0L && System.currentTimeMillis() >= maxWaitTime) {
                result.resultCode = 1;
                error = "Timeout! Process has been not finished in specified " + sec + " seconds.";
                result.m_errorMessages.add(error);
                RTLogger.print(5, error);
            }
            try {
                caw = this.m_tempBuffer.get(errorStream);
                if (caw != null && caw.size() > 0) {
                    result.m_errorMessages.add(caw.toString());
                }
            }
            catch (Throwable v75) {}
            try {
                try {
                    caw = this.m_tempBuffer.get(inputStream);
                    if (caw != null && caw.size() > 0) {
                        result.m_outMessages.add(caw.toString());
                    }
                }
                catch (Throwable v76) {
                    this.m_tempBuffer.clear();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable v77) {}
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable v78) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable v79) {}
                    }
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable v80) {}
                    }
                    if (pr != null && pr.getOutputStream() != null) {
                        try {
                            pr.getOutputStream().close();
                        }
                        catch (Throwable v81) {}
                    }
                    break block291;
                }
            }
            catch (Throwable var22_29) {
                this.m_tempBuffer.clear();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable v82) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Throwable v83) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable v84) {}
                }
                if (errorStream != null) {
                    try {
                        errorStream.close();
                    }
                    catch (Throwable v85) {}
                }
                if (pr != null && pr.getOutputStream() != null) {
                    try {
                        pr.getOutputStream().close();
                    }
                    catch (Throwable v86) {}
                }
                throw var22_29;
            }
            this.m_tempBuffer.clear();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable v87) {}
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (Throwable v88) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable v89) {}
            }
            if (errorStream != null) {
                try {
                    errorStream.close();
                }
                catch (Throwable v90) {}
            }
            if (pr != null && pr.getOutputStream() != null) {
                try {
                    pr.getOutputStream().close();
                }
                catch (Throwable v91) {}
            }
        }
        return result;
    }

    private static String getWindowsConsoleCharset() {
        String charset;
        block50: {
            charset = "Cp850";
            String[] cmdAttrbs = new String[]{"cmd.exe", "/C", "chcp"};
            BufferedReader in = null;
            Process pr = null;
            InputStream inputStream = null;
            try {
                try {
                    Pattern cp = Pattern.compile(".*\\s+(\\d+).*");
                    pr = Runtime.getRuntime().exec(cmdAttrbs);
                    inputStream = pr.getInputStream();
                    in = new BufferedReader(new InputStreamReader(inputStream));
                    String lineR = null;
                    while ((lineR = in.readLine()) != null) {
                        Matcher m = cp.matcher(lineR);
                        if (!m.matches()) continue;
                        String cpage = m.group(1);
                        int c = Integer.parseInt(cpage);
                        String charsetTemp = "Cp" + c;
                        try {
                            m_win_charset = Charset.forName(charsetTemp);
                            charset = charsetTemp;
                            RTLogger.print(3, "console charset: " + charset);
                        }
                        catch (Throwable e) {
                            File cFile = new File("charsets.jar");
                            if (!cFile.exists() && !(cFile = new File("spi/charsets.jar")).exists()) {
                                cFile = new File("spi/jars/charsets.jar");
                            }
                            URLClassLoader urlcl = null;
                            try {
                                try {
                                    URL[] urls = new URL[]{cFile.toURI().toURL()};
                                    urlcl = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
                                    Class<?> epc = urlcl.loadClass("sun.nio.cs.ext.ExtendedCharsets");
                                    CharsetProvider extendedProvider = (CharsetProvider)epc.newInstance();
                                    m_win_charset = extendedProvider.charsetForName(charsetTemp);
                                }
                                catch (Throwable throwable) {
                                    RTLogger.print(2, "Error getting actual console charset decoder: " + charsetTemp);
                                    throw e;
                                }
                            }
                            catch (Throwable throwable) {
                                if (urlcl != null) {
                                    try {
                                        urlcl.close();
                                    }
                                    catch (Throwable throwable2) {}
                                }
                                throw throwable;
                            }
                            if (urlcl == null) break;
                            try {
                                urlcl.close();
                            }
                            catch (Throwable throwable) {}
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    block49: {
                        try {
                            m_win_charset = Charset.forName(charset);
                            RTLogger.print(2, "Error getting actual console charset. Using default: " + charset);
                        }
                        catch (Throwable throwable3) {
                            String javaHome = System.getProperty("java.home");
                            RTLogger.print(1, "JRE has not installed support for additional languages. ");
                            RTLogger.print(1, "Missed " + javaHome + "\\libs\\charsets.jar");
                            m_win_charset = Charset.defaultCharset();
                            if (m_win_charset != null) {
                                RTLogger.print(1, "Using java default codepage for external binaries: " + m_win_charset.name());
                                break block49;
                            }
                            RTLogger.print(1, "Default charset is NULL!!!");
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable4) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable5) {}
                    }
                    if (pr != null && pr.getOutputStream() != null) {
                        try {
                            pr.getOutputStream().close();
                        }
                        catch (Throwable throwable6) {}
                    }
                    break block50;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable7) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable8) {}
                }
                if (pr != null && pr.getOutputStream() != null) {
                    try {
                        pr.getOutputStream().close();
                    }
                    catch (Throwable throwable9) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (pr != null && pr.getOutputStream() != null) {
                try {
                    pr.getOutputStream().close();
                }
                catch (Throwable throwable) {}
            }
        }
        return charset;
    }

    public static Charset getDefaultCharset() {
        return m_win_charset;
    }

    public static Map<String, String> getEnvMap() {
        return envMap;
    }

    public static String[] getEnvp() {
        return envp;
    }
}

