/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.log.RTLogger;
import com.blixx.shared.utils.StrUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HostnameResolver {
    public File m_hosts = null;
    public String m_filepath = "hosts";
    public TreeMap<String, String> m_map = new TreeMap();
    public ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock();
    public boolean m_lowercase = false;

    public HostnameResolver(String filepath, boolean lowercase) {
        this.m_filepath = filepath;
        this.m_hosts = new File(filepath);
        this.m_lowercase = lowercase;
        this.readHosts();
    }

    public void reload() {
        this.m_lock.writeLock().lock();
        try {
            this.m_map.clear();
            this.readHosts();
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public String getNameForAlias(String host, String agentID) {
        if (host == null) {
            return host;
        }
        if (this.m_lowercase) {
            host = host.toLowerCase();
        }
        String res = host;
        this.m_lock.readLock().lock();
        try {
            if (agentID == null) {
                String hostOnlyRes = this.m_map.get(host);
                if (hostOnlyRes != null) {
                    res = hostOnlyRes;
                }
            } else {
                StringBuffer sb = new StringBuffer(agentID);
                sb.append('|').append(host);
                String res2 = this.m_map.get(sb.toString());
                if (res2 != null) {
                    res = res2;
                } else {
                    res2 = this.m_map.get(host);
                    if (res2 != null) {
                        res = res2;
                    }
                }
            }
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return res;
    }

    private void readHosts() {
        block28: {
            if (this.m_hosts.exists()) {
                if (this.m_hosts.canRead()) {
                    FileReader fr = null;
                    BufferedReader br = null;
                    try {
                        try {
                            fr = new FileReader(this.m_hosts);
                            br = new BufferedReader(fr);
                            String line = null;
                            int count = 1;
                            StrUtils strUtils = new StrUtils();
                            while ((line = br.readLine()) != null) {
                                if ((line = line.trim()).length() > 0 && line.charAt(0) == '#') continue;
                                try {
                                    line = line.replace('\t', ' ');
                                    String[] aliases = strUtils.processQuoted(line);
                                    if (aliases.length > 1) {
                                        String majorName = strUtils.removeQuotes(aliases[0]);
                                        if (this.m_lowercase) {
                                            majorName = majorName.toLowerCase();
                                        }
                                        int i = 1;
                                        while (i < aliases.length) {
                                            String hostAlias = strUtils.removeQuotes(aliases[i]);
                                            if (this.m_lowercase) {
                                                hostAlias = hostAlias.toLowerCase();
                                            }
                                            this.m_map.put(hostAlias, majorName);
                                            ++i;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    RTLogger.print(1, String.valueOf(this.m_filepath) + " line# " + count + " failed to process.");
                                }
                                ++count;
                            }
                            RTLogger.print(1, String.valueOf(this.m_filepath) + " processed lines: " + count);
                        }
                        catch (Throwable e) {
                            RTLogger.print(1, "srv/etc/hosts. Reading error", e);
                            try {
                                br.close();
                            }
                            catch (Throwable throwable) {}
                            try {
                                fr.close();
                            }
                            catch (Throwable throwable) {}
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {}
                        try {
                            fr.close();
                        }
                        catch (Throwable throwable3) {}
                        throw throwable;
                    }
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fr.close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    RTLogger.print(1, String.valueOf(this.m_filepath) + " file unreadable. Please check permissions");
                }
            } else {
                RTLogger.print(1, String.valueOf(this.m_filepath) + " file not found");
            }
        }
    }
}

