/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.sa.SchedulerThreadPoolExecutor;
import com.blixx.sa.ThreadGroup;
import com.blixx.shared.BM;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Scheduler
implements Runnable {
    private AtomicBoolean m_isActive = new AtomicBoolean(true);
    private AtomicBoolean m_isRunning = new AtomicBoolean(true);
    private AtomicBoolean m_isStopped = new AtomicBoolean(true);
    private ThreadGroup m_internalGroup = new ThreadGroup("Other");
    private ThreadGroup m_monitorsGroup = new ThreadGroup("ALL");
    private ThreadGroup m_javaMonGroup = new ThreadGroup("JavaMonitors");
    private SortedMap<String, SchedulerTask> m_threadPool = Collections.synchronizedSortedMap(new TreeMap());
    private Map<String, String> m_taskMap = new ConcurrentHashMap<String, String>();
    private long m_maxInterval = Long.MAX_VALUE;
    public static final String INTERNAL = "__@@INTERNAL";
    private Object m_lock = new Object();
    private ThreadPoolExecutor m_executor = new SchedulerThreadPoolExecutor(0, 10000, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    public Long m_systemTimeForTests = null;

    public Scheduler() {
    }

    public Scheduler(int maxAllowed) {
        this();
        this.m_internalGroup.setMaximum(500);
        this.m_javaMonGroup.setMaximum(maxAllowed);
        this.m_monitorsGroup.setMaximum(maxAllowed);
    }

    public void repeatMe(SchedulerTask task) {
        RTLogger.print(1, "WARNING! System runs out of free handles for new Processes.");
        RTLogger.print(1, "Task " + task.getName() + " will be re-scheduled");
        this.removeTask(task.getName());
        this.addTask(task, 0L);
    }

    public List<String> getScheduledTasks() {
        return new LinkedList<String>(this.m_taskMap.keySet());
    }

    public boolean hasTask(String name) {
        String curentKey;
        boolean isExist = false;
        if (this.m_taskMap != null && (curentKey = this.m_taskMap.get(name)) != null) {
            isExist = this.m_threadPool.containsKey(curentKey);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(SchedulerTask task) {
        int type = task.getIntervalObj().m_type.get();
        Calendar cal = Calendar.getInstance();
        TimeZone tz = cal.getTimeZone();
        cal.setTimeInMillis(this.getCurrentMilliseconds());
        boolean isDLT = tz.inDaylightTime(cal.getTime());
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                cal.set(11, 0);
                break;
            }
            case 3: {
                cal.set(11, 0);
                cal.set(7, 2);
                break;
            }
            case 5: {
                cal.set(11, 0);
                cal.set(5, 1);
                break;
            }
        }
        boolean isDLT_2 = tz.inDaylightTime(cal.getTime());
        cal.add(13, task.getIntervalObj().getShiftSeconds());
        if (isDLT != isDLT_2) {
            if (isDLT_2) {
                cal.add(12, 60);
                isDLT_2 = false;
            } else {
                cal.add(12, -60);
                isDLT_2 = true;
            }
        }
        boolean isDLTplanned = tz.inDaylightTime(cal.getTime());
        this.setThreadGroup(task);
        long firstStart = cal.getTimeInMillis();
        while (firstStart < this.getCurrentMilliseconds()) {
            cal.setTimeInMillis(firstStart += task.getInterval());
            isDLTplanned = tz.inDaylightTime(cal.getTime());
        }
        if (type != 1 && isDLT_2 != isDLTplanned) {
            firstStart = !isDLTplanned ? (firstStart += 3600000L) : (firstStart -= 3600000L);
        }
        this.putTask(task, task.getInterval(), firstStart);
        if (RTLogger.getCurrentLevel() >= 3) {
            StringBuilder msg = new StringBuilder();
            msg.append("Added new fixed time task ").append(task.toString()).append(" to the Scheduler, next run: ").append(new Date(firstStart)).append(" type=").append(type);
            RTLogger.print(3, msg.toString());
        }
        Object object = this.m_lock;
        synchronized (object) {
            try {
                this.m_lock.notifyAll();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTask(SchedulerTask task, long vTime) {
        if (task.getIntervalObj().getType() != 0) {
            this.addTask(task);
        } else {
            long interval = task.getInterval();
            if (interval > this.m_maxInterval) {
                interval = this.m_maxInterval;
            }
            String msgT = null;
            if (interval == 0L && vTime == 0L) {
                if (RTLogger.getCurrentLevel() >= 3) {
                    msgT = String.valueOf(task.toString()) + " was not scheduled. Interval=" + interval;
                    RTLogger.print(3, msgT);
                }
                return;
            }
            long nextRun = 0L;
            if (vTime == 0L) {
                nextRun = task.getName().indexOf(INTERNAL) != -1 ? this.getCurrentMilliseconds() + interval + (long)(10 * this.m_taskMap.size()) : this.getCurrentMilliseconds() + interval + (long)(this.m_taskMap.size() / 10 * 200);
                if (RTLogger.getCurrentLevel() >= 3) {
                    Date d = new Date(nextRun);
                    StringBuilder msg = new StringBuilder();
                    msg.append("Add new ").append(task.toString()).append(" to the Scheduler, next run: ").append(BM.m_sdf.format(d)).append("\nCurrent thread poll size:").append(this.m_taskMap.size());
                    RTLogger.print(3, msg.toString());
                }
            } else {
                nextRun = vTime + interval;
                while (nextRun < this.getCurrentMilliseconds()) {
                    nextRun += interval;
                }
            }
            this.setThreadGroup(task);
            this.putTask(task, interval, nextRun);
            Object object = this.m_lock;
            synchronized (object) {
                try {
                    this.m_lock.notifyAll();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void setThreadGroup(SchedulerTask task) {
        if (task.getName().indexOf(INTERNAL) == -1) {
            if (task.getType() > 0) {
                task.setThreadGroup(this.m_javaMonGroup);
            } else {
                task.setThreadGroup(this.m_monitorsGroup);
            }
        } else {
            task.setThreadGroup(this.m_internalGroup);
        }
    }

    public long getNextRunScheduled(String taskName) {
        String key = this.m_taskMap.get(taskName);
        if (key == null) {
            return 0L;
        }
        long res = -1L;
        try {
            res = Long.parseLong(key.substring(0, key.indexOf(95)));
        }
        catch (Throwable throwable) {}
        return res;
    }

    private void putTask(SchedulerTask task, long interval, long nextRun) {
        String checkOldKey;
        if (interval > 0L) {
            task.clearStopFlag();
        }
        if ((checkOldKey = this.m_taskMap.get(task.getName())) != null) {
            this.m_threadPool.remove(checkOldKey);
        }
        String key = String.valueOf(nextRun) + "_" + task.getName();
        this.m_threadPool.put(key, task);
        this.m_taskMap.put(task.getName(), key);
        if (RTLogger.getCurrentLevel() > 6) {
            StringBuilder msg = new StringBuilder();
            msg.append("next turn for ").append(String.valueOf(task.getName()) + " Interval=" + interval).append(" : ").append(new Date(nextRun));
            RTLogger.print(9, msg.toString());
        }
    }

    public boolean removeTask(String ID) {
        String currentKey = this.m_taskMap.remove(ID);
        if (currentKey == null) {
            return true;
        }
        SchedulerTask task = (SchedulerTask)this.m_threadPool.remove(currentKey);
        if (task == null) {
            return true;
        }
        if (task.stopTask()) {
            RTLogger.print(3, "Task " + task.getName() + " was stopped.");
        } else {
            RTLogger.print(2, "Unable to stop task:" + task.getName());
        }
        if (RTLogger.getCurrentLevel() >= 3) {
            StringBuilder msg = new StringBuilder();
            msg.append(task.toString()).append(" was removed from Scheduler.\n").append("Current thread poll size:").append(this.m_taskMap.size());
            RTLogger.print(3, msg.toString());
        }
        return true;
    }

    public SchedulerTask getTask(String ID) {
        String currentKey = this.m_taskMap.get(ID);
        if (currentKey == null) {
            return null;
        }
        SchedulerTask task = (SchedulerTask)this.m_threadPool.get(currentKey);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                this.m_isStopped.compareAndSet(true, false);
                this.m_isRunning.set(true);
                while (this.m_isRunning.get()) {
                    if (this.m_threadPool.size() == 0) {
                        Object object = this.m_lock;
                        synchronized (object) {
                            try {
                                this.m_lock.wait(1000L);
                            }
                            catch (Throwable throwable) {}
                            if (!this.m_isRunning.get()) {
                                break;
                            }
                            continue;
                        }
                    }
                    String key = null;
                    try {
                        key = this.m_threadPool.firstKey();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        continue;
                    }
                    long first = Long.parseLong(key.substring(0, key.indexOf("_")));
                    long deltaCurrent = first - this.getCurrentMilliseconds();
                    if (deltaCurrent > 1L) {
                        Object object = this.m_lock;
                        synchronized (object) {
                            try {
                                this.m_lock.wait(1000L);
                            }
                            catch (Throwable throwable) {}
                            if (!this.m_isRunning.get()) {
                                break;
                            }
                            continue;
                        }
                    }
                    SchedulerTask task = (SchedulerTask)this.m_threadPool.get(key);
                    if (task == null || !this.m_taskMap.containsKey(task.getName())) {
                        this.m_threadPool.remove(key);
                        continue;
                    }
                    if (task.isStopped() || task.getInterval() <= 0L) {
                        if (task.getInterval() == 0L) {
                            try {
                                this.runTask(task);
                            }
                            catch (Throwable throwable) {}
                        }
                        this.removeTask(task.getName());
                        continue;
                    }
                    if (task.isRunning()) {
                        if (!task.iCanRunLongerThanScheduleInterval() && RTLogger.getCurrentLevel() >= 5) {
                            RTLogger.print(5, String.valueOf(task.toString()) + " is busy. This turn skipped.");
                        }
                        this.m_threadPool.remove(key);
                        this.addTask(task, first);
                        continue;
                    }
                    try {
                        this.runTask(task);
                        this.m_threadPool.remove(key);
                        this.addTask(task, first);
                    }
                    catch (OutOfMemoryError e) {
                        RTLogger.print(2, "", e);
                        this.m_threadPool.remove(key);
                        this.addTask(task, first);
                    }
                    catch (NoMoreSlots e) {
                        RTLogger.print(4, e.getMessage());
                        this.m_threadPool.remove(key);
                        this.addTask(task, first + 33L);
                    }
                    catch (Throwable e) {
                        RTLogger.print(5, "", e);
                        this.m_threadPool.remove(key);
                        this.addTask(task, first);
                    }
                }
            }
            catch (Throwable tr) {
                if (this.m_isRunning.get()) {
                    RTLogger.print(1, "Unexpected stop of Scheduler.", tr);
                }
                this.m_isStopped.compareAndSet(false, true);
                RTLogger.print(2, "Scheduler stopped");
            }
        }
        finally {
            this.m_isStopped.compareAndSet(false, true);
            RTLogger.print(2, "Scheduler stopped");
        }
    }

    private long runTask(SchedulerTask task) throws InterruptedException {
        long delay = 0L;
        ThreadGroup ourGroup = null;
        if (task.getName().indexOf(INTERNAL) != -1) {
            ourGroup = this.m_internalGroup;
        } else if (task.getType() > 0) {
            if (!this.m_isActive.get()) {
                return delay;
            }
            ourGroup = this.m_javaMonGroup;
        } else {
            if (!this.m_isActive.get()) {
                return delay;
            }
            ourGroup = this.m_monitorsGroup;
        }
        int tries = 0;
        while (tries < 4 && ourGroup.getActiveCount() > ourGroup.getMaximum()) {
            try {
                delay += 100L;
                Thread.sleep(100L);
            }
            catch (RuntimeException runtimeException) {}
            ++tries;
        }
        if (tries == 4) {
            throw new NoMoreSlots("All slots are busy. Maximum number of running processes: " + ourGroup.getMaximum());
        }
        boolean started = false;
        do {
            try {
                this.m_executor.execute(task);
                started = true;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        } while (!started);
        return delay;
    }

    public void refresh() {
        ArrayList<SchedulerTask> tasks = new ArrayList<SchedulerTask>(this.m_threadPool.values());
        for (SchedulerTask task : tasks) {
            task.refresh();
        }
    }

    public boolean isStopped() {
        return this.m_isStopped.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean stopScheduler() {
        this.m_isRunning.compareAndSet(true, false);
        var1_1 = this.m_lock;
        synchronized (var1_1) {
            try {
                this.m_lock.notifyAll();
            }
            catch (Throwable v0) {}
            if (true) ** GOTO lbl19
        }
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException v2) {}
lbl19:
            // 3 sources

        } while (!this.m_isStopped.get());
        RTLogger.print(2, "Scheduler main thread is stopped. Start stopping tasks...");
        while (!this.m_threadPool.isEmpty()) {
            key = this.m_threadPool.firstKey();
            task = (SchedulerTask)this.m_threadPool.get(key);
            if (task.stopTask()) {
                RTLogger.print(2, "Task {" + task.getName() + "} was stopped by Scheduler.");
            } else {
                RTLogger.print(3, "Task {" + task.getName() + "} wasn't stopped by Scheduler.");
            }
            this.m_threadPool.remove(key);
        }
        RTLogger.print(2, "Scheduler stopped.");
        return true;
    }

    public void clean() {
        this.m_taskMap.clear();
        this.m_threadPool.clear();
    }

    public int getSize() {
        return this.m_taskMap.size();
    }

    public long getCurrentMilliseconds() {
        return this.m_systemTimeForTests == null ? System.currentTimeMillis() : this.m_systemTimeForTests;
    }

    public String toString() {
        return "Scheduler";
    }

    public void deactivate() {
        if (this.m_isActive.compareAndSet(true, false)) {
            RTLogger.print(1, "Scheduler is deactivated");
        }
    }

    public void activate() {
        if (this.m_isActive.compareAndSet(false, true)) {
            RTLogger.print(1, "Scheduler is activated");
        }
    }

    public class NoMoreSlots
    extends RuntimeException {
        public NoMoreSlots() {
        }

        public NoMoreSlots(String message, Throwable cause) {
            super(message, cause);
        }

        public NoMoreSlots(String message) {
            super(message);
        }

        public NoMoreSlots(Throwable cause) {
            super(cause);
        }
    }
}

