/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa.perf;

import com.blixx.log.RTLogger;
import com.blixx.sa.perf.DDFField;
import com.blixx.sa.perf.DDFTable;
import java.io.FileInputStream;
import java.io.IOException;

public class PerfClassParser {
    public static void main(String[] args) {
        PerfClassParser pcp = new PerfClassParser();
        try {
            DDFTable table = pcp.parseFile("perf1.spec");
            System.out.println(table);
        }
        catch (IOException e) {
            RTLogger.print(4, "", e);
        }
    }

    public DDFTable parseFile(String file) throws IOException {
        byte[] h;
        StringBuilder sb = new StringBuilder();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            h = new byte[fis.available()];
            fis.read(h);
        }
        sb.append(new String(h));
        String[] lines = sb.toString().split("\n");
        DDFTable table = null;
        DDFField currField = null;
        int i = 0;
        while (i < lines.length) {
            String currLine = lines[i].replace("\r", "").trim();
            String[] words = currLine.split("\\s+");
            if (words[0].length() == 0) {
                if (currField != null && table != null) {
                    table.addField(currField);
                    currField = null;
                }
            } else if (words[0].equalsIgnoreCase("CLASS") && words.length > 1) {
                table = new DDFTable(words[1]);
            } else if (currLine.indexOf(61) != -1) {
                if (currField == null) {
                    String[] fieldparts = currLine.split("=");
                    currField = new DDFField(fieldparts[0].trim(), Integer.parseInt(words[2]));
                }
            } else if (words.length >= 2) {
                if (words[0].equalsIgnoreCase("BOOM_DATATYPE") || words[0].equalsIgnoreCase("DATATYPE")) {
                    if (currField != null) {
                        currField.setType(words[1]);
                    }
                    if (words[1].equals(DDFField.VARCHAR) && words.length >= 2) {
                        try {
                            if (currField != null) {
                                currField.setSize(Integer.parseInt(words[2]));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (words[0].equalsIgnoreCase("CODA_DATATYPE") || words[1].equalsIgnoreCase("CODA_DATATYPE")) {
                    String type = words[words.length - 1];
                    if (!type.startsWith("UTF") && !type.startsWith("TIME")) {
                        if (currField != null) {
                            currField.setType(DDFField.DOUBLE);
                        }
                    } else if (type.equalsIgnoreCase("TIME") && currField != null) {
                        currField.setType(DDFField.BIGINT);
                    }
                } else if (!words[0].equalsIgnoreCase("CODA_CATEGORYTYPE") && !words[1].equalsIgnoreCase("CODA_CATEGORYTYPE")) {
                    if (words[0].equalsIgnoreCase("TYPE") && words[1].equalsIgnoreCase("TEXT") && words[2].equalsIgnoreCase("LENGTH")) {
                        if (currField != null) {
                            currField.setType(DDFField.VARCHAR);
                        }
                        int size = 255;
                        try {
                            size = Integer.parseInt(words[3].replace(";", ""));
                            if (currField != null) {
                                currField.setSize(size);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (words[0].equalsIgnoreCase("PRECISION") && currField != null) {
                        currField.setType(DDFField.DOUBLE);
                    }
                }
            }
            ++i;
        }
        if (currField != null && table != null) {
            table.addField(currField);
        }
        if (table != null) {
            table.checkTable();
        }
        return table;
    }
}

