/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractConditions;
import com.blixx.shared.DaytimeOfWeekRange;
import com.blixx.shared.IEnv;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.PatternMatcherThread;
import com.blixx.shared.exceptions.ConfigException;
import com.blixx.shared.utils.PolicyCRC;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractPolicy {
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String POLICY_VERSION = "POLICY_VERSION";
    public static final String POLICY_ENABLED = "POLICY_ENABLED";
    public static final String POLICY_ENABLED_IF = "POLICY_ENABLED_IF";
    public static final String MSGGRP = "MSGGRP";
    public static final String APPLICATION = "APPLICATION";
    public static final String MSD_MAX_PER_MINUTE = "MSD_MAX_PER_MINUTE";
    public static final String MSD_BLOCK_MINUTES = "MSD_BLOCK_MINUTES";
    public static final String MSD_QUARANTINE_MINUTES = "MSD_QUARANTINE_MINUTES";
    public static final String SUPP_TIME = "SUPP_TIME";
    public static final String SUPP_COUNT = "SUPP_COUNT";
    public static final String PLOG_ENABLED = "PLOG_ENABLED";
    public static final String PLOG_LOGCOUNT = "PLOG_LOGCOUNT";
    public static final String PLOG_LOGSIZE = "PLOG_LOGSIZE";
    public static final String POLICY_DISABLE_SCHEDULE = "POLICY_DISABLE_SCHEDULE";
    public static final String MSGKEY = "MSGKEY";
    public static final String CLOSEMASK = "CLOSEMASK";
    protected boolean m_enabled = true;
    protected String m_enabledIfCond = null;
    protected String m_enabledIfVariable = null;
    protected PatternB m_enabledIfPattern = null;
    protected List<DaytimeOfWeekRange> m_deactivation = null;
    protected String m_deactivationConfig = null;
    protected String policy_version = "1.0";
    protected String spiNAME = "CUSTOM".intern();
    protected String separator = "\u25ba";
    protected String msggrp = "".intern();
    protected String application = "".intern();
    protected String description = "".intern();
    protected String syntax = "1".intern();
    protected String policyName = null;
    protected String callType = "".intern();
    protected String monprog = "".intern();
    protected String msgkey = "".intern();
    protected String closekey = "".intern();
    protected int m_msd_mpm = 0;
    protected int m_msd_bm = 0;
    protected int m_msd_qm = 0;
    protected String intervalStr = "5m".intern();

    protected AbstractPolicy() {
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isEnabledCheckRuntime(IEnv vars) {
        if (this.m_enabledIfVariable != null && this.m_enabledIfPattern != null) {
            return this.isEnabled() && this.check(vars);
        }
        return this.isEnabled();
    }

    public boolean check(IEnv vars) {
        boolean isGlobalVariableMatches = false;
        String value = vars.getVariable(this.m_enabledIfVariable);
        if (value != null) {
            PatternMatchResult matchesR = PatternMatcherThread.match(this.m_enabledIfPattern, value);
            isGlobalVariableMatches = matchesR != null && matchesR.isMatch();
        }
        return isGlobalVariableMatches;
    }

    public String getEnabledIfCond() {
        return this.m_enabledIfCond;
    }

    public String getEnabledIfVariable() {
        return this.m_enabledIfVariable;
    }

    public PatternB getEnabledIfPattern() {
        return this.m_enabledIfPattern;
    }

    public boolean isDeactivationTime(long ms) {
        if (this.m_deactivation == null || this.m_deactivation.size() == 0) {
            return false;
        }
        for (DaytimeOfWeekRange dr : this.m_deactivation) {
            if (!dr.matched(ms)) continue;
            return true;
        }
        return false;
    }

    public void parseDeactivationTimes(String config) {
        if (config == null || config.length() < 3) {
            return;
        }
        this.m_deactivationConfig = config;
        String[] lines = config.split("\r*\n");
        int i = 0;
        while (i < lines.length) {
            try {
                DaytimeOfWeekRange dr = new DaytimeOfWeekRange(lines[i]);
                if (this.m_deactivation == null) {
                    this.m_deactivation = new ArrayList<DaytimeOfWeekRange>();
                }
                this.m_deactivation.add(dr);
            }
            catch (Throwable e) {
                RTLogger.print(3, "DaytimeOfWeekRange failed. ", e);
            }
            ++i;
        }
    }

    public String getDeactivationTimes() {
        return this.m_deactivationConfig;
    }

    public void setDeactivationTimes(String config) {
        this.m_deactivationConfig = config;
    }

    public void setEnabledIF(String enabledIfCond) {
        String string = this.m_enabledIfCond = "".equals(enabledIfCond) ? null : enabledIfCond;
        if (this.m_enabledIfCond != null) {
            try {
                int ch = this.m_enabledIfCond.indexOf(61);
                String var = this.m_enabledIfCond.substring(0, ch);
                if (var.length() != 0) {
                    String pattern = this.m_enabledIfCond.substring(ch + 1);
                    PatternB test = PatternB.getPattern(pattern);
                    this.m_enabledIfVariable = var.intern();
                    this.m_enabledIfPattern = test;
                }
            }
            catch (Throwable throwable) {}
        } else {
            this.m_enabledIfVariable = null;
            this.m_enabledIfPattern = null;
        }
    }

    public abstract AbstractConditions<?> getConditions();

    public static String doChecksum(File file) {
        return PolicyCRC.doChecksum(file);
    }

    public static AbstractPolicy fillValues(AbstractPolicy pol, Properties prop, String separator) {
        pol.policyName = prop.getProperty(NAME);
        if (pol.policyName == null) {
            throw new ConfigException("Msg policy has no name.");
        }
        pol.policyName = pol.policyName.intern();
        pol.syntax = prop.getProperty("VERSION");
        if (pol.syntax != null) {
            pol.syntax = pol.syntax.intern();
        }
        pol.intervalStr = prop.getProperty("INTERVAL", "").intern();
        pol.callType = prop.getProperty("CALLTYPE", "").intern();
        pol.description = prop.getProperty(DESCRIPTION, "");
        pol.policy_version = prop.getProperty(POLICY_VERSION, "1.0").intern();
        pol.spiNAME = prop.getProperty("SPI", "").intern();
        pol.separator = separator == null ? null : separator.intern();
        pol.msggrp = prop.getProperty(MSGGRP, "").intern();
        pol.application = prop.getProperty(APPLICATION, "").intern();
        pol.msgkey = prop.getProperty(MSGKEY, "").intern();
        pol.closekey = prop.getProperty(CLOSEMASK, "").intern();
        String enabled = prop.getProperty(POLICY_ENABLED);
        if (enabled != null && enabled.equalsIgnoreCase("false")) {
            pol.setEnabled(false);
        }
        pol.setEnabledIF(prop.getProperty(POLICY_ENABLED_IF));
        pol.parseDeactivationTimes(prop.getProperty(POLICY_DISABLE_SCHEDULE));
        String intVal = prop.getProperty(MSD_MAX_PER_MINUTE);
        try {
            pol.m_msd_mpm = Integer.parseInt(intVal);
        }
        catch (Throwable throwable) {}
        intVal = prop.getProperty(MSD_BLOCK_MINUTES);
        try {
            pol.m_msd_bm = Integer.parseInt(intVal);
        }
        catch (Throwable throwable) {}
        intVal = prop.getProperty(MSD_QUARANTINE_MINUTES);
        try {
            pol.m_msd_qm = Integer.parseInt(intVal);
        }
        catch (Throwable throwable) {}
        return pol;
    }

    public Properties getMainProperties() {
        Properties p = new Properties();
        p.setProperty(NAME, this.policyName);
        p.setProperty(DESCRIPTION, this.description);
        p.setProperty(POLICY_VERSION, this.policy_version);
        p.setProperty("SPI", this.spiNAME);
        p.setProperty("VERSION", this.syntax);
        p.setProperty(MSGGRP, this.msggrp);
        p.setProperty(APPLICATION, this.application);
        p.setProperty(MSGKEY, this.msgkey == null ? "" : this.msgkey);
        p.setProperty(CLOSEMASK, this.closekey == null ? "" : this.closekey);
        p.setProperty(POLICY_ENABLED, "" + this.isEnabled());
        if (this.getEnabledIfCond() != null) {
            p.setProperty(POLICY_ENABLED_IF, this.getEnabledIfCond());
        }
        if (this.m_deactivationConfig != null) {
            p.setProperty(POLICY_DISABLE_SCHEDULE, this.getDeactivationTimes());
        }
        return p;
    }

    public void setEnabled(boolean enable) {
        this.m_enabled = enable;
    }

    public String getVersion() {
        return this.policy_version;
    }

    public void setVersion(String policyVersion) {
        this.policy_version = policyVersion;
    }

    public String getSpiName() {
        return this.spiNAME;
    }

    public void setSpiName(String spiNAME) {
        this.spiNAME = spiNAME;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSetGroup() {
        return this.msggrp;
    }

    public void setSetGroup(String msggrp) {
        this.msggrp = msggrp;
    }

    public String getSetApplication() {
        return this.application;
    }

    public void setSetApplication(String application) {
        this.application = application;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public String getName() {
        return this.policyName;
    }

    public void setName(String policyName) {
        this.policyName = policyName;
    }

    public String getCallType() {
        return this.callType;
    }

    public void setCallType(String callType) {
        this.callType = callType;
    }

    public String getMonprog() {
        return this.monprog;
    }

    public void setMonprog(String monprog) {
        this.monprog = monprog;
    }

    public String getKey() {
        return this.msgkey;
    }

    public void setKey(String msgkey) {
        this.msgkey = msgkey;
    }

    public String getCloseMask() {
        return this.closekey;
    }

    public void setCloseMask(String closekey) {
        this.closekey = closekey;
    }

    public int getMsd_mpm() {
        return this.m_msd_mpm;
    }

    public void setMsd_mpm(int msdMpm) {
        this.m_msd_mpm = msdMpm;
    }

    public int getMsd_bm() {
        return this.m_msd_bm;
    }

    public void setMsd_bm(int msdBm) {
        this.m_msd_bm = msdBm;
    }

    public int getMsd_qm() {
        return this.m_msd_qm;
    }

    public void setMsd_qm(int msdQm) {
        this.m_msd_qm = msdQm;
    }

    public String getIntervalStr() {
        return this.intervalStr;
    }

    public void setIntervalStr(String intervalStr) {
        this.intervalStr = intervalStr;
    }

    public abstract String getPolicyType();
}

