/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import com.blixx.shared.IODataStream;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;

public class Action
implements IODataStream,
Cloneable {
    private static final String EXEC = "EXEC";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    public static final String ID = "ID";
    public static final String LABEL = "LABEL";
    public static final String CALLTYPE = "CALLTYPE";
    public static final String CALL = "CALL";
    public static final String TIMEOUT = "TIMEOUT";
    public static final String ICON = "ICON";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String OPTIONAL_PARAMETERS = "OPTIONAL_PARAMETERS";
    public static final String OPTIONAL_P = "OPTIONAL_P";
    public static final String SERVER_ACTION = "SERVER_ACTION";
    public static final String HELPTEXT = "HELPTEXT";
    public static final String HELPTEXT_ID = "HELPTEXT_ID";
    public String m_ID = null;
    public String m_label = null;
    public String m_calltype = null;
    public String m_call = null;
    public int m_timeoutSeconds = 120;
    public String m_icon = null;
    public String m_description = null;
    public String m_optional_parameters = null;
    public boolean m_optional = false;
    public boolean m_serverAction = false;
    public String m_help = null;
    public String m_helpID = null;

    private Action() {
    }

    public Action(Properties props) {
        String serverActionStr;
        this.m_ID = props.getProperty(ID);
        if (this.m_ID == null || this.m_ID.length() == 0) {
            this.m_ID = UUID.randomUUID().toString();
        }
        this.m_label = props.getProperty(LABEL, "No Label");
        this.m_calltype = props.getProperty(CALLTYPE, EXEC);
        this.m_call = props.getProperty(CALL);
        String aaTimeout = props.getProperty(TIMEOUT);
        if (aaTimeout != null) {
            try {
                this.m_timeoutSeconds = Integer.parseInt(aaTimeout);
            }
            catch (NumberFormatException numberFormatException) {
                RTLogger.print(5, "Action timeout is not integer. Action: " + this.m_label);
            }
        }
        this.m_icon = props.getProperty(ICON, "default");
        this.m_description = props.getProperty(DESCRIPTION, "");
        this.m_optional_parameters = props.getProperty(OPTIONAL_PARAMETERS);
        String optional = props.getProperty(OPTIONAL_P, FALSE);
        if (optional != null && optional.equalsIgnoreCase(TRUE)) {
            this.m_optional = true;
        }
        if ((serverActionStr = props.getProperty(SERVER_ACTION)) != null && serverActionStr.equalsIgnoreCase(TRUE)) {
            this.m_serverAction = true;
        }
        this.m_help = props.getProperty(HELPTEXT, "");
        this.m_helpID = props.getProperty(HELPTEXT_ID);
        if (this.m_helpID == null || this.m_helpID.length() == 0) {
            this.m_helpID = UUID.randomUUID().toString();
        }
    }

    public static Action getNew() {
        Action a = new Action();
        a.m_ID = UUID.randomUUID().toString();
        a.m_helpID = UUID.randomUUID().toString();
        a.m_label = "NewAction_" + System.currentTimeMillis();
        a.m_optional = false;
        a.m_call = "";
        a.m_calltype = EXEC;
        a.m_timeoutSeconds = 120;
        a.m_description = "";
        a.m_help = "";
        a.m_icon = "";
        a.m_optional_parameters = "";
        a.m_serverAction = false;
        return a;
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        this.m_call = dis.readUTF();
        this.m_calltype = dis.readUTF();
        this.m_timeoutSeconds = dis.readInt();
        this.m_description = dis.readUTF();
        this.m_help = dis.readUTF();
        this.m_helpID = dis.readUTF();
        this.m_icon = dis.readUTF();
        this.m_ID = dis.readUTF();
        this.m_label = dis.readUTF();
        this.m_optional = dis.readBoolean();
        this.m_optional_parameters = dis.readUTF();
        this.m_serverAction = dis.readBoolean();
        return null;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        dos.writeUTF(this.m_call);
        dos.writeUTF(this.m_calltype);
        dos.writeInt(this.m_timeoutSeconds);
        dos.writeUTF(this.m_description);
        dos.writeUTF(this.m_help);
        dos.writeUTF(this.m_helpID);
        dos.writeUTF(this.m_icon);
        dos.writeUTF(this.m_ID);
        dos.writeUTF(this.m_label);
        dos.writeBoolean(this.m_optional);
        dos.writeUTF(this.m_optional_parameters);
        dos.writeBoolean(this.m_serverAction);
    }

    public Properties getProperties() {
        Properties prop = new Properties();
        prop.put(CALL, this.m_call);
        prop.put(CALLTYPE, this.m_calltype);
        prop.put(TIMEOUT, "" + this.m_timeoutSeconds);
        prop.put(DESCRIPTION, this.m_description);
        prop.put(HELPTEXT, this.m_help);
        prop.put(HELPTEXT_ID, this.m_helpID);
        prop.put(ICON, this.m_icon);
        prop.put(ID, this.m_ID);
        prop.put(LABEL, this.m_label);
        if (this.m_optional) {
            prop.put(OPTIONAL_P, TRUE);
        } else {
            prop.put(OPTIONAL_P, FALSE);
        }
        prop.put(OPTIONAL_PARAMETERS, this.m_optional_parameters);
        if (this.m_serverAction) {
            prop.put(SERVER_ACTION, TRUE);
        } else {
            prop.put(SERVER_ACTION, FALSE);
        }
        return prop;
    }

    public Action clone() {
        Properties p = this.getProperties();
        Properties nP = new Properties(p);
        nP.setProperty(ID, UUID.randomUUID().toString());
        nP.setProperty(HELPTEXT_ID, UUID.randomUUID().toString());
        nP.setProperty(LABEL, String.valueOf(this.m_label) + "_COPY_" + System.currentTimeMillis());
        nP.setProperty(CALL, this.m_call);
        nP.setProperty(CALLTYPE, this.m_calltype);
        nP.setProperty(TIMEOUT, "" + this.m_timeoutSeconds);
        nP.setProperty(DESCRIPTION, this.m_description);
        nP.setProperty(HELPTEXT, this.m_help);
        nP.setProperty(ICON, this.m_icon);
        if (this.m_optional) {
            nP.setProperty(OPTIONAL_P, TRUE);
        } else {
            nP.setProperty(OPTIONAL_P, FALSE);
        }
        nP.setProperty(OPTIONAL_PARAMETERS, this.m_optional_parameters);
        if (this.m_serverAction) {
            nP.setProperty(SERVER_ACTION, TRUE);
        } else {
            nP.setProperty(SERVER_ACTION, FALSE);
        }
        Action newAction = new Action(nP);
        return newAction;
    }
}

