/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.Interval;
import java.util.regex.Pattern;

public class CFI {
    public String m_class = null;
    public String m_filed = null;
    public String m_intervalOrigStr = null;
    private Pattern classNamePattern = Pattern.compile("\\w+");

    public CFI(String cfi) {
        String[] arr = cfi.split("\\.");
        this.m_class = arr[0].toUpperCase();
        this.m_filed = arr[1].toUpperCase();
        this.m_intervalOrigStr = arr.length == 3 ? arr[2] : "";
    }

    public boolean isValidInterval() {
        try {
            Interval seconds = Interval.parseInterval(this.m_intervalOrigStr, -1);
            return seconds.getIntervalSeconds() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isValidClassName() {
        return this.m_class != null && this.m_class.length() > 0 && this.m_class.length() < 128 && this.classNamePattern.matcher(this.m_class).matches();
    }

    public boolean isValidColumn() {
        return this.m_filed != null && this.m_filed.length() > 0 && this.m_filed.length() < 128 && this.classNamePattern.matcher(this.m_filed).matches();
    }

    public String toString() {
        return String.valueOf(this.m_class) + "." + this.m_filed + "." + this.m_intervalOrigStr;
    }
}

