/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import com.blixx.shared.SHA256Digest;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;

public class HashHelper {
    private static final String DELETE_ERROR = "Can not delete the file.";
    File srcFile;
    File destFile;
    File destTmpFile;
    File destHashFile;
    SHA256Digest sha256;
    Gson gson;

    public HashHelper(String srcFilePath, String destFolderPath) {
        this.srcFile = new File(srcFilePath);
        if (!this.srcFile.exists()) {
            throw new IllegalArgumentException("Source file can not be found.");
        }
        File destFolder = new File(destFolderPath);
        if (!destFolder.isDirectory()) {
            throw new IllegalArgumentException("Please define a valid destination folder.");
        }
        if (!destFolder.exists()) {
            destFolder.mkdir();
        }
        this.destFile = new File(destFolder, this.srcFile.getName());
        this.destTmpFile = new File(destFolder, String.valueOf(this.srcFile.getName()) + ".tmp");
        this.destHashFile = new File(destFolder, String.valueOf(this.srcFile.getName()) + ".json");
        this.gson = new Gson();
    }

    public boolean runSha256(int chunkSize, byte[] fileHash) throws Exception {
        long totalSize = this.srcFile.length();
        RTLogger.print(5, "Source file size : " + totalSize);
        this.sha256 = new SHA256Digest();
        int startIterationPosition = 0;
        long existFileSize = this.destTmpFile.length();
        boolean overwrite = this.checkIfHashExists(chunkSize, totalSize);
        if (!overwrite) {
            startIterationPosition = (int)(existFileSize / (long)chunkSize);
            RTLogger.print(5, "Existing file size : " + existFileSize);
        }
        long currentPosition = existFileSize;
        long iterationCount = totalSize / (long)chunkSize;
        RTLogger.print(5, "Iteration count : " + iterationCount);
        int i = startIterationPosition;
        while ((long)i < iterationCount + 1L) {
            RTLogger.print(5, "Running Iteration : " + i);
            int readSize = chunkSize;
            if (currentPosition + (long)chunkSize > totalSize) {
                readSize = (int)(totalSize - currentPosition);
            }
            RTLogger.print(5, "Current pos:" + currentPosition);
            try {
                byte[] chunkData = this.readChunks(this.srcFile, currentPosition, readSize);
                this.writeChunks(chunkData, this.destTmpFile, i != 0);
                currentPosition += (long)readSize;
                this.sha256.update(chunkData);
                String serializedState = this.gson.toJson((Object)this.sha256, (Type)((Object)SHA256Digest.class));
                this.writeToFile(serializedState, this.destHashFile.getAbsolutePath());
                RTLogger.print(5, "wrote hash for iteration: " + i);
            }
            catch (Exception e) {
                RTLogger.print(1, "Error while processing file.", e);
                throw e;
            }
            ++i;
        }
        byte[] chunksHash = this.sha256.digest();
        if (!Arrays.equals(fileHash, chunksHash)) {
            RTLogger.print(3, "File hashes do not match.");
            return false;
        }
        this.markComplete(false);
        RTLogger.print(3, "File hashes are identical.");
        return true;
    }

    public boolean checkIfHashExists(int chunkSize, long totalSize) {
        boolean overwrite = false;
        if (this.destTmpFile.exists()) {
            long existFileSize = this.destTmpFile.length();
            if (existFileSize == totalSize) {
                RTLogger.print(3, "Overwrite required: Deleting previously created file.");
                this.deleteFiles(this.destFile, this.destTmpFile, this.destHashFile);
                overwrite = true;
            } else if (existFileSize % (long)chunkSize != 0L) {
                RTLogger.print(3, "Transfered file chunks are inconsistent state: Deleting previously created file.");
                overwrite = true;
                this.deleteFiles(this.destFile, this.destTmpFile, this.destHashFile);
            } else {
                String loadedHash = this.readHashFormFile(this.destHashFile);
                if (!loadedHash.isEmpty()) {
                    this.sha256 = new SHA256Digest(this.gson.fromJson(loadedHash, SHA256Digest.class));
                } else {
                    RTLogger.print(3, "Hash file does not exist: Deleting previously created file.");
                    overwrite = true;
                    this.deleteFiles(this.destFile, this.destTmpFile, this.destHashFile);
                }
            }
        }
        return overwrite;
    }

    private boolean markComplete(boolean removeHashInfo) {
        try {
            Files.move(Paths.get(this.destTmpFile.getPath(), new String[0]), Paths.get(this.destFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            if (removeHashInfo) {
                Files.deleteIfExists(this.destHashFile.toPath());
            }
        }
        catch (IOException e) {
            RTLogger.print(1, "Error while moving file.", e);
        }
        return true;
    }

    private String readHashFormFile(File hashFile) {
        String loadedHash;
        block15: {
            loadedHash = "";
            if (hashFile.exists()) {
                FileInputStream fileStream = null;
                try {
                    try {
                        fileStream = new FileInputStream(hashFile);
                        byte[] data = new byte[(int)hashFile.length()];
                        int read = fileStream.read(data);
                        RTLogger.print(5, "Read hash file total size of : " + read);
                        loadedHash = new String(data, StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        RTLogger.print(1, "Cannot load hash file.", e);
                        if (fileStream != null) {
                            try {
                                fileStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return loadedHash;
    }

    private void writeToFile(String stringToWrite, String fileName) throws IOException {
        FileWriter writer = new FileWriter(fileName);
        try {
            try {
                writer.append(stringToWrite);
                writer.flush();
            }
            catch (IOException e) {
                RTLogger.print(1, "Can not write to file.", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private void deleteFiles(File destFile, File destTempFile, File hashFile) {
        try {
            Files.deleteIfExists(destFile.toPath());
        }
        catch (IOException e) {
            RTLogger.print(1, DELETE_ERROR, e);
        }
        try {
            Files.deleteIfExists(destTempFile.toPath());
        }
        catch (IOException e) {
            RTLogger.print(1, DELETE_ERROR, e);
        }
        try {
            Files.deleteIfExists(hashFile.toPath());
        }
        catch (IOException e) {
            RTLogger.print(1, DELETE_ERROR, e);
        }
    }

    private void writeChunks(byte[] data, File destFile, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(destFile, append);
                out.write(data);
            }
            catch (IOException e) {
                RTLogger.print(1, "Can not write chunks.", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private byte[] readChunks(File file, long position, int chunkSize) throws IOException {
        byte[] data = new byte[chunkSize];
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                fis.skip(position);
                fis.read(data, 0, chunkSize);
            }
            catch (IOException e) {
                RTLogger.print(1, "Can not read chunks.", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        return data;
    }
}

