/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.exceptions.ConfigException;
import com.blixx.shared.exceptions.PolicyException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternB {
    private static final String DUMMY1_VARIABLE = "dummy1";
    public static final String VAR = "var";
    private String m_pattern_str;
    private Pattern m_pattern;
    private Pattern m_patternNOT;
    private ArrayList<String> m_variables = new ArrayList(1);
    private List<String> m_values = null;
    private Map<String, String> m_map = null;
    private String m_TOP_VARIABLE = null;
    private boolean m_OMU = true;
    public static final char PATTERN_SPLIT_CHAR = '\u2663';
    public static Pattern NUMOP1 = Pattern.compile(".*(<(<\\d*#\\.*\\S*>)\\s+(-\\w\\w)\\s+(-*[\\d\\,\\.]+)\\s*>).*");
    public static Pattern NUMOP2 = Pattern.compile(".*(<(-*[\\d\\,\\.]+)\\s+(-\\w\\w)\\s+\\[?([^\\]]*)\\]?\\s+(-\\w\\w)\\s+(-*[\\d\\,\\.]+)>).*");
    private static final String ALL_1_STR = "(?:.*?)";
    private static final Pattern ALL_1 = Pattern.compile("(?:.*?)", 32);
    private static final String ALL_2_STR = "(.*?)";
    private static final Pattern ALL_2 = Pattern.compile("(.*?)", 32);
    private boolean isMatchAll = false;
    private static Pattern JAVA_INJECTED = Pattern.compile("\\Q<^\\E(.*)\\^\\.?(.*)>");
    public static Pattern JAVA_CAPTURING_GROUP = Pattern.compile(".*(.?)(?<!\\\\)\\([^?]*(.?)(?<!\\\\)\\).*");
    public static Pattern JAVA_FLAGS = Pattern.compile("\\(\\?-?[idmsux]\\)");

    public PatternB(String ovpattern) {
        this.m_pattern_str = ovpattern = ovpattern.trim();
        if (ovpattern.toLowerCase().startsWith("java=")) {
            try {
                String javaPattern = ovpattern.substring("java=".length());
                this.checkIfMatchesAll(javaPattern);
                this.m_pattern = Pattern.compile(javaPattern, 32);
                this.m_OMU = false;
                return;
            }
            catch (RuntimeException e) {
                throw new ConfigException("invalid JAVA pattern", e);
            }
        }
        String BEGIN = "";
        String END = "";
        if (ovpattern.startsWith("^")) {
            ovpattern = ovpattern.substring(1);
            BEGIN = "^";
        }
        if (ovpattern.endsWith("$")) {
            ovpattern = ovpattern.substring(0, ovpattern.length() - 1);
            END = "$";
        }
        ovpattern = PatternB.replaceMatchNUMOP1(ovpattern);
        ovpattern = PatternB.replaceMatchNUMOP2(ovpattern);
        List<Object> al = PatternB.split2OvPattern(ovpattern);
        List<Object> alNot = this.reformat(al);
        al.add(0, BEGIN);
        if (alNot != null) {
            alNot.add(0, BEGIN);
        }
        al.add(END);
        if (alNot != null) {
            alNot.add(END);
        }
        StringBuilder resultPattern = new StringBuilder();
        int i = 0;
        while (i < al.size()) {
            Object o = al.get(i);
            if (o instanceof PatternB) {
                PatternB psub = (PatternB)o;
                resultPattern.append("(").append(psub.getJavaPattern()).append(")");
                if (!psub.hasOvVariables()) {
                    String cfr_ignored_0 = psub.m_TOP_VARIABLE;
                }
            } else {
                String sp = (String)al.get(i);
                sp = this.lastFixes(sp);
                resultPattern.append(sp);
            }
            ++i;
        }
        StringBuilder resultPatternNot = new StringBuilder();
        int i2 = 0;
        while (alNot != null && i2 < alNot.size()) {
            Object o = alNot.get(i2);
            if (o instanceof PatternB) {
                PatternB psub = (PatternB)o;
                resultPatternNot.append("(").append(psub.getJavaNotPattern()).append(")");
            } else {
                String sp = (String)alNot.get(i2);
                sp = this.lastFixes(sp);
                resultPatternNot.append(sp);
            }
            ++i2;
        }
        try {
            String rPatternNot;
            String rPattern = resultPattern.toString().replace("\\Q\\E", "");
            if (rPattern.endsWith("(.*?)(?:.*?)") || rPattern.endsWith("(?:(.*?))(?:.*?)")) {
                rPattern = rPattern.substring(0, rPattern.length() - 7);
            }
            if (alNot != null && !rPattern.equals(rPatternNot = resultPatternNot.toString().replace("\\Q\\E", ""))) {
                if (rPatternNot.endsWith("(.*?)(?:.*?)") || rPatternNot.endsWith("(?:(.*?))(?:.*?)")) {
                    rPatternNot = rPatternNot.substring(0, rPatternNot.length() - 7);
                }
                this.m_patternNOT = Pattern.compile(rPatternNot, 32);
            }
            this.m_pattern = ALL_1_STR.equals(rPattern) ? ALL_1 : (ALL_2_STR.equals(rPattern) ? ALL_2 : Pattern.compile(rPattern, 32));
            this.checkIfMatchesAll(rPattern);
        }
        catch (RuntimeException e) {
            throw new ConfigException("invalid pattern", e);
        }
    }

    private void checkIfMatchesAll(String rPattern) {
        if (rPattern.equals(".*") || rPattern.equals(ALL_1_STR) || rPattern.equals("(?:.*)") || rPattern.equals("(.*)") || rPattern.equals(ALL_2_STR)) {
            this.isMatchAll = true;
            this.m_pattern_str = this.m_pattern_str.intern();
        }
    }

    public boolean isMatchAll() {
        return this.isMatchAll;
    }

    private String lastFixes(String sp) {
        if ("(?:.*)".equals(sp)) {
            sp = ALL_1_STR;
        } else if ("(.*)".equals(sp)) {
            sp = ALL_2_STR;
        } else if (sp.startsWith("\\Q|\\E)")) {
            sp = sp.replace("\\Q|\\E)", "|)");
        }
        return sp;
    }

    @Deprecated
    public String getValue(String variableName) {
        Map<String, String> m = this.getVariableMap();
        return m.get(variableName);
    }

    public Pattern getPattern() {
        return this.m_pattern;
    }

    public String getJavaPattern() {
        return this.m_pattern.pattern();
    }

    public String getJavaNotPattern() {
        if (this.m_patternNOT == null) {
            return "";
        }
        return this.m_patternNOT.pattern();
    }

    public String getOvPattern() {
        return this.m_pattern_str;
    }

    private boolean hasOvVariables() {
        return this.m_variables.size() > 0;
    }

    public ArrayList<String> getOvVariables() {
        return this.m_variables;
    }

    @Deprecated
    public Map<String, String> getVariableMap() {
        if (this.m_map == null) {
            this.m_map = new LinkedHashMap<String, String>(this.m_variables.size() + 1, 0.99f);
            this.fillMap(this.m_map, this.m_values);
        }
        return this.m_map;
    }

    private void fillMap(Map<String, String> m_map, List<String> m_values) {
        if (this.m_pattern_str.toLowerCase().startsWith("java=")) {
            int i = 0;
            while (i < m_values.size()) {
                m_map.put(VAR + (i + 1), m_values.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_variables.size()) {
                String value = null;
                try {
                    value = m_values.get(i);
                }
                catch (Throwable throwable) {}
                m_map.put(this.m_variables.get(i), value);
                ++i;
            }
        }
    }

    @Deprecated
    public boolean matches(String input) {
        return this.matchesR((String)input).m_match;
    }

    public PatternMatchResult matchesR(String inputStr) {
        InterruptibleCharSequence input = new InterruptibleCharSequence(inputStr);
        PatternMatchResult result = new PatternMatchResult(false, null);
        ArrayList<String> values = new ArrayList<String>(1);
        Matcher mm = this.m_pattern.matcher(input);
        if (this.m_OMU) {
            result.m_match = mm.matches();
            if (result.m_match && this.m_patternNOT != null) {
                result.m_match = !this.m_patternNOT.matcher(input).find();
            }
        } else {
            result.m_match = mm.matches();
        }
        if (result.m_match) {
            result.m_vars = new LinkedHashMap<String, String>();
            if (this.hasOvVariables()) {
                int i = 1;
                while (i <= mm.groupCount()) {
                    int varNum = i - 1;
                    String value = mm.group(i);
                    values.add(varNum, value);
                    try {
                        String var = this.m_variables.get(varNum);
                        if (var.indexOf("$$") != -1) {
                            double val = Double.parseDouble(value.replace(',', '.'));
                            String calc = var.replace("$$", "" + val);
                            String[] arr = calc.split("\\s+");
                            int j = 0;
                            while (j + 2 < arr.length) {
                                double dbl1 = Double.parseDouble(arr[j].replace(',', '.'));
                                String oper = arr[j + 1];
                                double dbl2 = Double.parseDouble(arr[j + 2].replace(',', '.'));
                                if (oper.equalsIgnoreCase("-le")) {
                                    if (!(dbl1 <= dbl2)) {
                                        result.m_match = false;
                                        return PatternMatchResult.FALSE;
                                    }
                                } else if (oper.equalsIgnoreCase("-lt")) {
                                    if (!(dbl1 < dbl2)) {
                                        result.m_match = false;
                                        return PatternMatchResult.FALSE;
                                    }
                                } else if (oper.equalsIgnoreCase("-ge")) {
                                    if (!(dbl1 >= dbl2)) {
                                        result.m_match = false;
                                        return PatternMatchResult.FALSE;
                                    }
                                } else if (oper.equalsIgnoreCase("-gt")) {
                                    if (!(dbl1 > dbl2)) {
                                        result.m_match = false;
                                        return PatternMatchResult.FALSE;
                                    }
                                } else if (oper.equalsIgnoreCase("-eq")) {
                                    if (Double.compare(dbl1, dbl2) != 0) {
                                        result.m_match = false;
                                        return PatternMatchResult.FALSE;
                                    }
                                } else if (oper.equalsIgnoreCase("-ne") && Double.compare(dbl1, dbl2) == 0) {
                                    result.m_match = false;
                                    return PatternMatchResult.FALSE;
                                }
                                j += 2;
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                    ++i;
                }
                this.fillMap(result.m_vars, values);
            } else if (mm.groupCount() > 0) {
                int i = 1;
                while (i <= mm.groupCount()) {
                    values.add(i - 1, mm.group(i));
                    ++i;
                }
                this.fillMap(result.m_vars, values);
            }
        }
        this.m_map = null;
        this.m_values = values;
        return result;
    }

    public List<Object> reformat(List<Object> al) {
        ArrayList<Object> alNOT = new ArrayList<Object>(al);
        this.m_variables = new ArrayList();
        this.m_values = new ArrayList<String>();
        boolean notHere = false;
        int i = 0;
        while (i < al.size()) {
            Object obj = al.get(i);
            if (obj instanceof PatternB) {
                PatternB psub = (PatternB)obj;
                if (psub.getJavaNotPattern().length() > 0) {
                    notHere = true;
                }
                if (psub.hasOvVariables() || psub.m_TOP_VARIABLE != null) {
                    if (psub.m_TOP_VARIABLE == null) {
                        this.m_variables.add(DUMMY1_VARIABLE.intern());
                    } else {
                        this.m_variables.add(psub.m_TOP_VARIABLE.intern());
                    }
                    this.m_variables.addAll(psub.m_variables);
                }
            } else {
                String go = (String)obj;
                if (go.startsWith("<")) {
                    Matcher m = JAVA_INJECTED.matcher(go);
                    if (m.matches()) {
                        String javaP = m.group(1);
                        Matcher flags = JAVA_FLAGS.matcher(javaP);
                        if (flags.matches()) {
                            go = javaP;
                        } else {
                            Matcher grps = JAVA_CAPTURING_GROUP.matcher(javaP);
                            if (grps.matches()) {
                                throw new ConfigException("injected java pattern contains capturing group.");
                            }
                            Pattern.compile(javaP);
                            String varName = m.group(2);
                            if (varName != null && varName.length() > 0) {
                                go = String.valueOf('(') + javaP + ')';
                                this.m_variables.add(varName.intern());
                            } else {
                                go = "(?:" + javaP + ')';
                            }
                        }
                        al.set(i, go);
                        alNOT.set(i, go);
                    } else {
                        boolean isVar = false;
                        String varName = null;
                        int lastDot = go.lastIndexOf(46);
                        if (lastDot != -1 && go.charAt(lastDot - 1) != '\\' && go.charAt(lastDot + 1) != ']') {
                            varName = go.substring(lastDot + 1, go.length() - 1);
                            this.m_variables.add(varName.intern());
                            String content = go.substring(1, lastDot);
                            content = content.replace("[", "(?:");
                            content = content.replace("]", ")");
                            go = "(" + content + ")";
                            al.set(i, go);
                            alNOT.set(i, go);
                            isVar = true;
                        }
                        if (go.length() > 1 && go.charAt(1) == '!') {
                            notHere = true;
                            if (isVar) {
                                al.set(i, ALL_2_STR);
                            } else {
                                al.set(i, ALL_1_STR);
                            }
                            String noGo = go.replace(String.valueOf(go.charAt(0)) + "!", "(");
                            noGo = noGo.replace("[", "(?:");
                            noGo = noGo.replace("]", ")");
                            noGo = noGo.replace(">", ")");
                            alNOT.set(i, noGo);
                        } else {
                            go = PatternB.replaceOVO(go, isVar);
                            al.set(i, go);
                            alNOT.set(i, go);
                        }
                    }
                } else if (!"|".equals(go)) {
                    String quotedGo = PatternB.qouteAll(go);
                    al.set(i, quotedGo);
                    alNOT.set(i, quotedGo);
                } else {
                    al.set(i, go);
                    alNOT.set(i, go);
                }
            }
            ++i;
        }
        if (!notHere) {
            alNOT = null;
        }
        return alNOT;
    }

    public static PatternB getPattern(String filterAsInPolicy) throws PolicyException {
        PatternB pattern;
        try {
            pattern = new PatternB(filterAsInPolicy);
        }
        catch (RuntimeException e) {
            throw new PolicyException("Policy contains incorrect patern: " + filterAsInPolicy, e);
        }
        return pattern;
    }

    public static String replaceOVO(String in, boolean isVar) {
        if (in.length() == 3) {
            in = in.replace("*", ".*");
            in = in.replace("@", "\\S+");
            in = in.replace("_", "\\s+");
            in = in.replace("#", "\\d+");
            if ((in = in.replace("/", "[\r\n]+")).length() == 3) {
                in = "\\Q" + PatternB.removeBSlashes(in) + "\\E";
            } else {
                in = in.replace("<", "(?:");
                in = in.replace('>', ')');
            }
        } else {
            Pattern p2;
            Matcher m2;
            Pattern p = Pattern.compile("[<\\(](\\d+)(.+)[>\\)]");
            Matcher m = p.matcher(in);
            if (m.matches()) {
                String ch;
                String digits = m.group(1);
                String bkpCh = ch = m.group(2);
                ch = ch.replace("*", ".");
                ch = ch.replace("@", "\\S");
                ch = ch.replace("_", "\\s");
                ch = ch.replace("#", "\\d");
                in = in.replace("/", "[\r\n]");
                if (bkpCh.equals(ch)) {
                    ch = String.valueOf('\\') + ch;
                }
                in = isVar ? "(" + ch + "{" + digits + "})" : "(?:" + ch + "{" + digits + "})";
            }
            if ((m2 = (p2 = Pattern.compile("\\Q<[\\E(.*)\\Q]>\\E")).matcher(in)).matches()) {
                in = "(?:" + m2.group(1) + ")";
            }
        }
        if (in.startsWith("<")) {
            in = "\\Q" + PatternB.removeBSlashes(in) + "\\E";
        }
        return in;
    }

    public static String qouteAll(String in) {
        if ("\\E".equals(in)) {
            return "\\Q\\\\E\\QE\\E";
        }
        String bropen = "<>";
        String brclosed = "><";
        String pipe = ">>";
        in = in.replace("\\[", bropen);
        in = in.replace("\\]", brclosed);
        in = in.replace("\\|", pipe);
        int ob = in.indexOf(91);
        int cb = in.indexOf(93);
        if (ob == 0 || ob > 0 && in.charAt(ob - 1) != '\\') {
            if (cb >= 0) {
                if (in.indexOf(124, ob) != -1) {
                    in = in.replace("[", "\\E(?:\\Q");
                    in = in.replace("|", "\\E|\\Q");
                    in = in.replace("]", "\\E)\\Q");
                } else if (in.indexOf(124, cb) != -1) {
                    in = in.replace("[", "\\E(?:\\Q");
                    in = in.replace("|", "\\E|\\Q");
                    in = in.replace("]", "\\E)\\Q");
                } else {
                    in = in.replace("[", "\\E(?:\\Q");
                    in = in.replace("]", "\\E)\\Q");
                }
            } else {
                in = in.replace("[", "\\E(?:\\Q");
            }
        } else if (ob <= 0 || in.charAt(ob - 1) != '\\') {
            int cbmain = in.indexOf(93);
            if (cbmain == 0 || cbmain > 0 && in.charAt(cbmain - 1) != '\\') {
                in = in.replace("]", "\\E)\\Q");
            } else if (cbmain > 0 && in.charAt(cbmain - 1) == '\\') {
                in = in.replace("\\]", "]");
            }
        }
        in = in.replace(bropen, "[");
        in = in.replace(brclosed, "]");
        in = in.replace(pipe, "|");
        boolean containsBckslE = in.contains("\\E");
        if (!in.contains("\\Q") || !containsBckslE) {
            in = PatternB.removeBSlashes(in);
        } else {
            in = in.replace("\\E", bropen);
            in = in.replace("\\Q", brclosed);
            in = PatternB.removeBSlashes(in);
            in = in.replace(bropen, "\\E");
            in = in.replace(brclosed, "\\Q");
        }
        in = in.replace("\\\\", "\\");
        in = "\\Q" + in + "\\E";
        return in;
    }

    public static String removeBSlashes(String in) {
        String[] arr = in.split("\\\\{2}");
        Pattern pp = Pattern.compile(".*(\\\\[^\\\\]).*");
        int i = 0;
        while (i < arr.length) {
            String s0 = arr[i];
            String s1 = arr[i];
            Matcher m = pp.matcher(s1);
            while (m.matches()) {
                s1 = s1.replace(m.group(1), m.group(1).substring(1));
                m = pp.matcher(s1);
            }
            in = in.replace(s0, s1);
            ++i;
        }
        return in;
    }

    @Deprecated
    public static List<String> splitOvPattern(String akey) {
        ArrayList<String> al = new ArrayList<String>();
        String[] arr = akey.split("<");
        int i = 0;
        while (i < arr.length) {
            if (arr[i].indexOf(62) == -1) {
                al.add(arr[i]);
            } else {
                String[] arr2 = arr[i].split(">");
                al.add("<" + arr2[0] + ">");
                if (arr2.length > 1) {
                    al.add(arr2[1]);
                }
            }
            ++i;
        }
        return al;
    }

    public boolean equals(PatternB obj) {
        return this.m_pattern_str == null ? obj.m_pattern_str == null : this.m_pattern_str.equals(obj.m_pattern_str);
    }

    public int hashCode() {
        return this.m_pattern_str == null ? 0 : this.m_pattern_str.hashCode();
    }

    public String toString() {
        return this.m_pattern_str;
    }

    public static List<Object> split2OvPattern(String akey) {
        ArrayList<Object> al = new ArrayList<Object>();
        String cs = akey;
        String tmp = "";
        int countStarts = 0;
        boolean forceRecursive = false;
        boolean javaInjection = false;
        boolean bckSlash = false;
        int i = 0;
        while (i < akey.length()) {
            block32: {
                char ch;
                block34: {
                    block33: {
                        ch = cs.charAt(i);
                        if (ch != '\\') break block33;
                        if (i >= akey.length() - 1) break block34;
                        switch (cs.charAt(i + 1)) {
                            case '\\': {
                                int thirdChpos = i + 2;
                                if (thirdChpos < akey.length() && cs.charAt(thirdChpos) == 'E') {
                                    if (tmp.length() > 0) {
                                        al.add(tmp);
                                    }
                                    al.add("\\E");
                                    tmp = "";
                                    i = thirdChpos;
                                } else {
                                    tmp = String.valueOf(tmp) + ch;
                                    ++i;
                                    tmp = String.valueOf(tmp) + ch;
                                }
                                break block32;
                            }
                            case '<': 
                            case '>': {
                                bckSlash = true;
                                tmp = String.valueOf(tmp) + ch;
                                ch = cs.charAt(++i);
                                break;
                            }
                            default: {
                                bckSlash = true;
                                tmp = String.valueOf(tmp) + ch;
                                ch = cs.charAt(++i);
                                break;
                            }
                        }
                        break block34;
                    }
                    bckSlash = false;
                }
                if (ch == '<' || ch == '>') {
                    if (i > 0 && (bckSlash || javaInjection)) {
                        tmp = String.valueOf(tmp) + ch;
                    } else if (ch == '<') {
                        if (countStarts == 0) {
                            if (tmp.length() > 0) {
                                al.add(tmp);
                            }
                            tmp = "";
                            ++countStarts;
                            tmp = String.valueOf(tmp) + ch;
                        } else {
                            ++countStarts;
                            tmp = String.valueOf(tmp) + ch;
                            forceRecursive = true;
                        }
                    } else if (countStarts == 1) {
                        tmp = String.valueOf(tmp) + ch;
                        --countStarts;
                        if (forceRecursive) {
                            String res = tmp.substring(tmp.indexOf(91) + 1, tmp.lastIndexOf(93));
                            String nres = tmp.replace(res, "");
                            PatternB ppp = new PatternB(res);
                            if (nres.indexOf(46) != -1) {
                                ppp.m_TOP_VARIABLE = nres.substring(nres.indexOf(46) + 1, nres.lastIndexOf(62));
                            }
                            al.add(ppp);
                            tmp = "";
                            forceRecursive = false;
                        } else {
                            al.add(tmp);
                            tmp = "";
                            try {
                                if (cs.charAt(i + 1) == '|') {
                                    al.add("|");
                                    ++i;
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                    } else {
                        --countStarts;
                        tmp = String.valueOf(tmp) + ch;
                    }
                } else if (ch == '^') {
                    if (tmp.endsWith("<")) {
                        javaInjection = true;
                    } else if (!bckSlash) {
                        javaInjection = false;
                    }
                    tmp = String.valueOf(tmp) + ch;
                } else {
                    tmp = String.valueOf(tmp) + ch;
                }
            }
            ++i;
        }
        if (tmp.length() > 0) {
            al.add(tmp);
        }
        if (countStarts > 0) {
            throw new RuntimeException("Not closed group found");
        }
        return al;
    }

    private static String replaceMatchNUMOP1(String pattern) {
        Matcher m;
        while ((m = NUMOP1.matcher(pattern)).matches()) {
            StringBuffer var = new StringBuffer();
            var.append("<[").append(m.group(2)).append("].$$ ").append(m.group(3)).append(" ").append(m.group(4)).append(">");
            pattern = pattern.replace(m.group(1), var.toString());
        }
        return pattern;
    }

    private static String replaceMatchNUMOP2(String pattern) {
        Matcher m;
        while ((m = NUMOP2.matcher(pattern)).matches()) {
            StringBuffer var = new StringBuffer();
            var.append("<[").append(m.group(4)).append("].").append(m.group(2)).append(" ").append(m.group(3)).append(" $$ ").append(m.group(5)).append(" ").append(m.group(6)).append(">");
            pattern = pattern.replace(m.group(1), var.toString());
        }
        return pattern;
    }

    public boolean isJavaPattern() {
        return !this.m_OMU;
    }

    public class InterruptibleCharSequence
    implements CharSequence {
        CharSequence inner;

        public InterruptibleCharSequence(CharSequence inner) {
            this.inner = inner;
        }

        @Override
        public char charAt(int index) {
            if (Thread.interrupted()) {
                throw new RuntimeException(new InterruptedException());
            }
            return this.inner.charAt(index);
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new InterruptibleCharSequence(this.inner.subSequence(start, end));
        }

        @Override
        public String toString() {
            return this.inner.toString();
        }
    }
}

