/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Condition;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyParsingException;
import com.blixx.shared.SecureDocumentBuilderFactory;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.exceptions.ConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PolicyFactory {
    public static final String FORWARD_FILTERS = "FORWARD_FILTERS";
    public static final String FILTER = "FILTER";
    public static final String TARGET = "TARGET";
    public static final String TARGETS = "TARGETS";
    public static final String FORWARD_MESSAGE = "FORWARD_MESSAGE";
    public static final String POLICY = "POLICY";
    public static final String SEPARATOR = "SEPARATOR";
    public static final String MONITOR = "MONITOR";
    public static final String MESSAGE = "MESSAGE";
    public static final String CONDITIONS = "CONDITIONS";
    public static final String CONDITION = "CONDITION";
    public static final String SPI = "SPI";
    public static final char SEPARATOR_DEFAULT = '\u25ba';

    public Policy initPolicy(File file) throws PolicyParsingException {
        Policy pol = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                if (file.exists() && file.canRead()) {
                    fileInputStream = new FileInputStream(file);
                    pol = this.initPolicy(fileInputStream);
                }
            }
            catch (Throwable e) {
                pol = null;
                RTLogger.print(1, "Failed processing file: " + file.getName() + " " + e.getMessage());
                RTLogger.print(2, "", e);
                throw new PolicyParsingException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return pol;
    }

    private Policy initPolicy(InputStream io) throws SAXException, ParserConfigurationException, IOException {
        Policy pol = null;
        Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(io);
        String separator = XMLFactory.getSeparator(doc);
        int version = XMLFactory.getVersion(doc);
        String spiNAME = this.getSPIName(doc);
        NodeList nlist = doc.getElementsByTagName(MONITOR);
        if (nlist.getLength() != 1) {
            throw new ConfigException("Invalid MONITOR policy");
        }
        Node item = nlist.item(0);
        Node cdata = XMLFactory.searchCDATA(item);
        if (cdata == null) {
            throw new ConfigException("Error: NO CDATA section found for:" + item.getNodeName());
        }
        String data = cdata.getNodeValue().trim();
        Properties mainProperties = XMLFactory.extractProperties(separator, data);
        mainProperties.setProperty("VERSION", "" + version);
        mainProperties.setProperty(SPI, spiNAME);
        Document docMonitor = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Node newMon = docMonitor.importNode(item, true);
        docMonitor.appendChild(newMon);
        Properties conditionsProps = this.getConditionsProps(newMon, separator, docMonitor, CONDITIONS);
        ArrayList<Properties> listOfCondition = new ArrayList<Properties>();
        NodeList condList = docMonitor.getElementsByTagName(CONDITION);
        int k = 0;
        while (k < condList.getLength()) {
            Node cdataCond = XMLFactory.searchCDATA(condList.item(k));
            String ddata = cdataCond.getNodeValue().trim();
            Properties cprops = XMLFactory.extractProperties(separator, ddata);
            listOfCondition.add(cprops);
            ++k;
        }
        pol = Policy.createPolicy(separator, mainProperties, conditionsProps, listOfCondition);
        return pol;
    }

    public MsgPolicy initMsgPolicy(File file) throws PolicyParsingException {
        MsgPolicy pol = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                if (file.exists() && file.canRead()) {
                    fileInputStream = new FileInputStream(file);
                    pol = this.initMsgPolicy(fileInputStream);
                }
            }
            catch (Throwable e) {
                RTLogger.print(1, "Failed processing file: " + file.getName() + " " + e.getMessage());
                RTLogger.print(2, "", e);
                throw new PolicyParsingException(e);
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return pol;
    }

    private MsgPolicy initMsgPolicy(InputStream io) throws SAXException, ParserConfigurationException, IOException {
        MsgPolicy pol = null;
        Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(io);
        String separator = XMLFactory.getSeparator(doc);
        int version = XMLFactory.getVersion(doc);
        String spiNAME = this.getSPIName(doc);
        NodeList nlist = doc.getElementsByTagName(MESSAGE);
        if (nlist.getLength() != 1) {
            throw new ConfigException("Invalid MESSAGE policy");
        }
        Node item = nlist.item(0);
        Node cdata = XMLFactory.searchCDATA(item);
        if (cdata == null) {
            throw new ConfigException("Error: NO CDATA section found for:" + item.getNodeName());
        }
        String data = cdata.getNodeValue().trim();
        Properties mainProperties = XMLFactory.extractProperties(separator, data);
        mainProperties.setProperty("VERSION", "" + version);
        mainProperties.setProperty(SPI, spiNAME);
        Document docMonitor = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Node newMon = docMonitor.importNode(item, true);
        docMonitor.appendChild(newMon);
        Properties conditionsProps = this.getConditionsProps(newMon, separator, docMonitor, CONDITIONS);
        ArrayList<Properties> listOfCondition = new ArrayList<Properties>();
        NodeList condList = docMonitor.getElementsByTagName(CONDITION);
        int k = 0;
        while (k < condList.getLength()) {
            Node cdataCond = XMLFactory.searchCDATA(condList.item(k));
            String ddata = cdataCond.getNodeValue();
            Properties cprops = XMLFactory.extractProperties(separator, ddata);
            listOfCondition.add(cprops);
            ++k;
        }
        pol = MsgPolicy.create(separator, mainProperties, conditionsProps, listOfCondition);
        return pol;
    }

    public Properties getConditionsProps(Node node, String separator, Document docMonitor, String tagName) {
        Node cdataConditions;
        Properties conditionsProps = null;
        NodeList list2 = docMonitor.getElementsByTagName(tagName);
        if (list2.getLength() == 1) {
            cdataConditions = XMLFactory.searchCDATA(list2.item(0));
            if (cdataConditions == null) {
                throw new ConfigException("Error: NO ID section found for:" + list2.item(0).getNodeName());
            }
        } else {
            throw new ConfigException("Multiple " + tagName + " block found");
        }
        conditionsProps = XMLFactory.extractProperties(separator, cdataConditions.getNodeValue().trim());
        return conditionsProps;
    }

    public String getSPIName(Document doc) {
        String ver = "CUSTOM";
        NodeList olist = doc.getElementsByTagName(SPI);
        if (olist != null && olist.getLength() > 0) {
            Node n = olist.item(0);
            ver = n.getTextContent().trim();
        }
        return ver;
    }

    public static Document createXMLver1(Policy pol) {
        Document doc = null;
        try {
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement(POLICY);
            Element separator = doc.createElement(SEPARATOR);
            separator.setTextContent(pol.separator);
            root.appendChild(separator);
            Element version = doc.createElement("VERSION");
            version.setTextContent(pol.syntax);
            root.appendChild(version);
            Element spi = doc.createElement(SPI);
            spi.setTextContent(pol.spiNAME);
            root.appendChild(spi);
            Element mon = XMLFactory.getCDATA(doc, MONITOR, pol.getMainProperties(), pol.separator);
            Element cnds = XMLFactory.getCDATA(doc, CONDITIONS, pol.getConditions().getProperties(), pol.separator);
            List arr = pol.getConditions().getConditionList();
            int i = 0;
            while (i < arr.size()) {
                Condition c = (Condition)arr.get(i);
                Element cel = XMLFactory.getCDATA(doc, CONDITION, c.getProperties(), pol.separator);
                cnds.appendChild(cel);
                ++i;
            }
            mon.appendChild(cnds);
            root.appendChild(mon);
            doc.appendChild(root);
        }
        catch (Throwable e) {
            RTLogger.print(2, "", e);
        }
        return doc;
    }

    public String storePolicy(String directory, AbstractPolicy p) {
        String filename = null;
        if (p instanceof MsgPolicy) {
            filename = this.getPolicyFilename(directory, p);
            this.storePolicy((MsgPolicy)p, filename);
        } else if (p instanceof Policy) {
            filename = this.getPolicyFilename(directory, p);
            this.storePolicy((Policy)p, filename);
        }
        return filename;
    }

    public String getPolicyFilename(String directory, AbstractPolicy p) {
        String type = "";
        if (p instanceof Policy) {
            type = "mon";
        } else if (p instanceof MsgPolicy) {
            type = "msg";
        }
        return this.getPolicyFilename(directory, p.policyName, type);
    }

    public String getPolicyFilename(String directory, String polName, String type) {
        StringBuilder filename = new StringBuilder();
        filename.append(directory);
        if (!directory.endsWith("/") && !directory.endsWith("\\")) {
            filename.append(File.separatorChar);
        }
        String extFile = "";
        if ("mon".equals(type)) {
            extFile = ".mon.xml";
        } else if ("msg".equals(type)) {
            extFile = ".msg.xml";
        }
        filename.append(polName).append(extFile);
        return filename.toString();
    }

    public File getPolicyFile(String directory, AbstractPolicy p) {
        return new File(this.getPolicyFilename(directory, p));
    }

    public File getPolicyFile(String directory, String polName, String type) {
        return new File(this.getPolicyFilename(directory, polName, type));
    }

    public void storePolicy(Policy p, String file) {
        Document doc = PolicyFactory.createXMLver1(p);
        PolicyFactory.writeXml(doc, file);
    }

    public void storePolicy(Policy p, File file) {
        Document doc = PolicyFactory.createXMLver1(p);
        PolicyFactory.writeXml(doc, file);
    }

    public void storePolicy(MsgPolicy p, String file) {
        Document doc = PolicyFactory.createXMLver1(p);
        PolicyFactory.writeXml(doc, file);
    }

    public void storePolicy(MsgPolicy p, File file) {
        Document doc = PolicyFactory.createXMLver1(p);
        PolicyFactory.writeXml(doc, file);
    }

    public static Document createXMLver1(MsgPolicy pol) {
        Document doc = null;
        try {
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement(POLICY);
            Element separator = doc.createElement(SEPARATOR);
            separator.setTextContent(pol.separator);
            root.appendChild(separator);
            Element version = doc.createElement("VERSION");
            version.setTextContent(pol.syntax);
            root.appendChild(version);
            Element spi = doc.createElement(SPI);
            spi.setTextContent(pol.spiNAME);
            root.appendChild(spi);
            Element mon = XMLFactory.getCDATA(doc, MESSAGE, pol.getMainProperties(), pol.separator);
            Element cnds = XMLFactory.getCDATA(doc, CONDITIONS, pol.getConditions().getProperties(), pol.separator);
            List arr = pol.getConditions().getConditionList();
            int i = 0;
            while (i < arr.size()) {
                MsgCondition c = (MsgCondition)arr.get(i);
                Element cel = XMLFactory.getCDATA(doc, CONDITION, c.getProperties(), pol.separator);
                cnds.appendChild(cel);
                ++i;
            }
            mon.appendChild(cnds);
            root.appendChild(mon);
            doc.appendChild(root);
        }
        catch (Throwable e) {
            RTLogger.print(2, "", e);
        }
        return doc;
    }

    protected static boolean writeXml(Document doc, String filename) {
        File file = new File(filename);
        return PolicyFactory.writeXml(doc, file);
    }

    protected static boolean writeXml(Document doc, File file) {
        return XMLFactory.writeXml(doc, file);
    }

    public static int getVersionAsInt(String version) {
        int pos = version.indexOf(46);
        int ver = 1;
        if (pos != -1) {
            String major = version.substring(0, pos);
            String minor = version.substring(pos + 1);
            ver = Integer.parseInt(major) * 100 + Integer.parseInt(minor);
        }
        return ver;
    }

    public static String getNextVersion(String version) {
        int old = PolicyFactory.getVersionAsInt(version);
        int major = ++old / 100;
        int minor = old - major * 100;
        return major + "." + minor;
    }
}

