/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.IODataStream;
import com.blixx.shared.UserRight;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class UserRole
implements IODataStream {
    private String m_UUID = null;
    private String m_name = null;
    private String m_description = null;
    private Map<Integer, UserRight> m_rights = new ConcurrentHashMap<Integer, UserRight>(20);
    public static final String ID = "ID";
    public static final String NAME = "ROLENAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public String m_name_in_brackets = null;

    private UserRole() {
    }

    public static UserRole createRole(Map userData) {
        UserRole role = new UserRole();
        role.m_UUID = (String)userData.get(ID);
        role.m_name = (String)userData.get(NAME);
        role.m_description = (String)userData.get(DESCRIPTION);
        if (role.m_description == null) {
            role.m_description = "";
        }
        return role;
    }

    public static UserRole createNewRole() {
        UserRole role = new UserRole();
        role.m_UUID = UUID.randomUUID().toString();
        role.m_name = "";
        role.m_description = "";
        return role;
    }

    public void addRights(List<UserRight> rights) {
        for (UserRight r : rights) {
            this.m_rights.put(r.getItemID(), r);
        }
    }

    public void addRight(UserRight right) {
        this.m_rights.put(right.getItemID(), right);
    }

    public List<UserRight> getRights() {
        return new ArrayList<UserRight>(this.m_rights.values());
    }

    public String getID() {
        return this.m_UUID;
    }

    public String getName() {
        return this.m_name;
    }

    public int getRightLevel(int userRightID) {
        UserRight r = this.m_rights.get(userRightID);
        if (r == null) {
            return 0;
        }
        return r.getLevel();
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        this.m_description = dis.readUTF();
        this.m_name = dis.readUTF();
        this.m_UUID = dis.readUTF();
        int size = dis.readInt();
        int i = 0;
        while (i < size) {
            UserRight ur = new UserRight();
            ur.read(dis);
            this.m_rights.put(ur.getItemID(), ur);
            ++i;
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        dos.writeUTF(this.m_description);
        dos.writeUTF(this.m_name);
        dos.writeUTF(this.m_UUID);
        List<UserRight> rights = this.getRights();
        int size = rights.size();
        dos.writeInt(size);
        int i = 0;
        while (i < size) {
            UserRight ur = rights.get(i);
            ur.send(dos);
            ++i;
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNameInBrackets() {
        if (this.m_name_in_brackets != null) return this.m_name_in_brackets;
        Class<UserRole> clazz = UserRole.class;
        synchronized (UserRole.class) {
            if (this.m_name_in_brackets != null) return this.m_name_in_brackets;
            this.m_name_in_brackets = String.valueOf('[') + this.m_name + ']';
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_name_in_brackets;
        }
    }
}

