/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.IServiceStatus;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class EventsAndStatus
implements IServiceStatus {
    private static final long serialVersionUID = -6216572062607195731L;
    protected AtomicInteger m_crit = new AtomicInteger(0);
    protected AtomicInteger m_maj = new AtomicInteger(0);
    protected AtomicInteger m_min = new AtomicInteger(0);
    protected AtomicInteger m_warn = new AtomicInteger(0);
    protected AtomicInteger m_normal = new AtomicInteger(0);
    protected AtomicInteger m_unknown = new AtomicInteger(0);
    protected AtomicInteger m_AVnormal = new AtomicInteger(0);
    protected AtomicInteger m_AVwarn = new AtomicInteger(0);
    protected AtomicInteger m_AVmin = new AtomicInteger(0);
    protected AtomicInteger m_AVmaj = new AtomicInteger(0);
    protected AtomicInteger m_AVcrit = new AtomicInteger(0);
    protected AtomicInteger m_AVunknown = new AtomicInteger(0);
    protected AtomicInteger m_KPInormal = new AtomicInteger(0);
    protected AtomicInteger m_KPIwarn = new AtomicInteger(0);
    protected AtomicInteger m_KPImin = new AtomicInteger(0);
    protected AtomicInteger m_KPImaj = new AtomicInteger(0);
    protected AtomicInteger m_KPIcrit = new AtomicInteger(0);
    protected AtomicInteger m_KPIunknown = new AtomicInteger(0);
    protected AtomicInteger m_crit_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_maj_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_min_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_warn_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_normal_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_unknown_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_AVnormal_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_AVwarn_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_AVmin_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_AVmaj_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_AVcrit_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_AVunknown_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_KPInormal_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_KPIwarn_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_KPImin_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_KPImaj_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_KPIcrit_FINISHED = new AtomicInteger(0);
    protected AtomicInteger m_KPIunknown_FINISHED = new AtomicInteger(0);
    protected Map<SEventFwd, SEventFwd> m_values = new ConcurrentHashMap<SEventFwd, SEventFwd>();

    public boolean contains(SEventFwd o) {
        return this.m_values.keySet().contains(o);
    }

    public boolean containsAll(Collection<SEventFwd> c) {
        return this.m_values.keySet().containsAll(c);
    }

    public boolean isEmpty() {
        return this.m_values.isEmpty();
    }

    public Iterator<SEventFwd> iterator() {
        return this.m_values.keySet().iterator();
    }

    public boolean removeAll(Collection<SEventFwd> c) {
        for (SEventFwd o : c) {
            this.remove(o);
        }
        return this.m_values.keySet().removeAll(c);
    }

    public boolean retainAll(Collection<SEventFwd> c) {
        boolean modified = false;
        Iterator<SEventFwd> e = this.iterator();
        while (e.hasNext()) {
            SEventFwd obj = e.next();
            if (c.contains(obj)) continue;
            this.remove(obj);
            modified = true;
        }
        return modified;
    }

    public int size() {
        return this.m_values.size();
    }

    public SEventFwd[] toArray() {
        return this.m_values.keySet().toArray(new SEventFwd[0]);
    }

    protected void applyCounter(SEventFwd event, int inc) {
        if (event == null) {
            return;
        }
        if (event.getTypeA() > 0) {
            switch (event.getSeverityInt()) {
                case 5: {
                    this.m_AVcrit.addAndGet(inc);
                    break;
                }
                case 4: {
                    this.m_AVmaj.addAndGet(inc);
                    break;
                }
                case 3: {
                    this.m_AVmin.addAndGet(inc);
                    break;
                }
                case 2: {
                    this.m_AVwarn.addAndGet(inc);
                    break;
                }
                case 1: {
                    this.m_AVnormal.addAndGet(inc);
                    break;
                }
                case 0: {
                    this.m_AVunknown.addAndGet(inc);
                    break;
                }
                case -1: {
                    this.m_AVcrit_FINISHED.addAndGet(inc);
                    break;
                }
                case -2: {
                    this.m_AVmaj_FINISHED.addAndGet(inc);
                    break;
                }
                case -3: {
                    this.m_AVmin_FINISHED.addAndGet(inc);
                    break;
                }
                case -4: {
                    this.m_AVwarn_FINISHED.addAndGet(inc);
                    break;
                }
                case -5: {
                    this.m_AVnormal_FINISHED.addAndGet(inc);
                    break;
                }
                case -6: {
                    this.m_AVunknown_FINISHED.addAndGet(inc);
                    break;
                }
            }
        } else if (event.getTypeK() > 0) {
            switch (event.getSeverityInt()) {
                case 5: {
                    this.m_KPIcrit.addAndGet(inc);
                    break;
                }
                case 4: {
                    this.m_KPImaj.addAndGet(inc);
                    break;
                }
                case 3: {
                    this.m_KPImin.addAndGet(inc);
                    break;
                }
                case 2: {
                    this.m_KPIwarn.addAndGet(inc);
                    break;
                }
                case 1: {
                    this.m_KPInormal.addAndGet(inc);
                    break;
                }
                case 0: {
                    this.m_KPIunknown.addAndGet(inc);
                    break;
                }
                case -1: {
                    this.m_KPIcrit_FINISHED.addAndGet(inc);
                    break;
                }
                case -2: {
                    this.m_KPImaj_FINISHED.addAndGet(inc);
                    break;
                }
                case -3: {
                    this.m_KPImin_FINISHED.addAndGet(inc);
                    break;
                }
                case -4: {
                    this.m_KPIwarn_FINISHED.addAndGet(inc);
                    break;
                }
                case -5: {
                    this.m_KPInormal_FINISHED.addAndGet(inc);
                    break;
                }
                case -6: {
                    this.m_KPIunknown_FINISHED.addAndGet(inc);
                    break;
                }
            }
        } else {
            switch (event.getSeverityInt()) {
                case 5: {
                    this.m_crit.addAndGet(inc);
                    break;
                }
                case 4: {
                    this.m_maj.addAndGet(inc);
                    break;
                }
                case 3: {
                    this.m_min.addAndGet(inc);
                    break;
                }
                case 2: {
                    this.m_warn.addAndGet(inc);
                    break;
                }
                case 1: {
                    this.m_normal.addAndGet(inc);
                    break;
                }
                case 0: {
                    this.m_unknown.addAndGet(inc);
                    break;
                }
                case -1: {
                    this.m_crit_FINISHED.addAndGet(inc);
                    break;
                }
                case -2: {
                    this.m_maj_FINISHED.addAndGet(inc);
                    break;
                }
                case -3: {
                    this.m_min_FINISHED.addAndGet(inc);
                    break;
                }
                case -4: {
                    this.m_warn_FINISHED.addAndGet(inc);
                    break;
                }
                case -5: {
                    this.m_normal_FINISHED.addAndGet(inc);
                    break;
                }
                case -6: {
                    this.m_unknown_FINISHED.addAndGet(inc);
                    break;
                }
            }
        }
    }

    public boolean add(SEventFwd o) {
        boolean res;
        boolean bl = res = this.m_values.put(o, o) == null;
        if (res) {
            this.applyCounter(o, 1);
        }
        return res;
    }

    public boolean add(SEventFwd o, ForwardFilter filter) {
        boolean res = false;
        if (filter == null || filter.checkEvent(o)) {
            res = this.add(o);
        }
        return res;
    }

    public boolean add(EventsAndStatus eas, ForwardFilter filter) {
        boolean res = false;
        for (SEventFwd se : eas.m_values.keySet()) {
            if (filter != null && !filter.checkEvent(se)) continue;
            boolean bl = res = this.add(se) || res;
        }
        return res;
    }

    public boolean addAll(Collection<SEventFwd> c) {
        boolean res = false;
        Iterator<SEventFwd> it = c.iterator();
        while (it.hasNext()) {
            boolean bl = res = this.add(it.next()) || res;
        }
        return res;
    }

    public void clear() {
        this.m_values.clear();
        this.m_crit.set(0);
        this.m_maj.set(0);
        this.m_min.set(0);
        this.m_warn.set(0);
        this.m_normal.set(0);
        this.m_unknown.set(0);
        this.m_crit_FINISHED.set(0);
        this.m_maj_FINISHED.set(0);
        this.m_min_FINISHED.set(0);
        this.m_warn_FINISHED.set(0);
        this.m_normal_FINISHED.set(0);
        this.m_unknown_FINISHED.set(0);
        this.m_AVcrit.set(0);
        this.m_AVmaj.set(0);
        this.m_AVmin.set(0);
        this.m_AVwarn.set(0);
        this.m_AVnormal.set(0);
        this.m_AVunknown.set(0);
        this.m_AVcrit_FINISHED.set(0);
        this.m_AVmaj_FINISHED.set(0);
        this.m_AVmin_FINISHED.set(0);
        this.m_AVwarn_FINISHED.set(0);
        this.m_AVnormal_FINISHED.set(0);
        this.m_AVunknown_FINISHED.set(0);
        this.m_KPIcrit.set(0);
        this.m_KPImaj.set(0);
        this.m_KPImin.set(0);
        this.m_KPIwarn.set(0);
        this.m_KPInormal.set(0);
        this.m_KPIunknown.set(0);
        this.m_KPIcrit_FINISHED.set(0);
        this.m_KPImaj_FINISHED.set(0);
        this.m_KPImin_FINISHED.set(0);
        this.m_KPIwarn_FINISHED.set(0);
        this.m_KPInormal_FINISHED.set(0);
        this.m_KPIunknown_FINISHED.set(0);
    }

    public boolean remove(SEventFwd o) {
        boolean ok = this.m_values.keySet().remove(o);
        if (ok) {
            try {
                this.applyCounter(o, -1);
            }
            catch (Throwable throwable) {}
        }
        return ok;
    }

    public int getCount(int sev, boolean av, boolean kpi, boolean other) {
        switch (sev) {
            case 5: {
                return (other ? this.m_crit.get() : 0) + (av ? this.m_AVcrit.get() : 0) + (kpi ? this.m_KPIcrit.get() : 0);
            }
            case 4: {
                return (other ? this.m_maj.get() : 0) + (av ? this.m_AVmaj.get() : 0) + (kpi ? this.m_KPImaj.get() : 0);
            }
            case 3: {
                return (other ? this.m_min.get() : 0) + (av ? this.m_AVmin.get() : 0) + (kpi ? this.m_KPImin.get() : 0);
            }
            case 2: {
                return (other ? this.m_warn.get() : 0) + (av ? this.m_AVwarn.get() : 0) + (kpi ? this.m_KPIwarn.get() : 0);
            }
            case 1: {
                return (other ? this.m_normal.get() : 0) + (av ? this.m_AVnormal.get() : 0) + (kpi ? this.m_KPInormal.get() : 0);
            }
            case 0: {
                return (other ? this.m_unknown.get() : 0) + (av ? this.m_AVunknown.get() : 0) + (kpi ? this.m_KPIunknown.get() : 0);
            }
            case -1: {
                return (other ? this.m_crit_FINISHED.get() : 0) + (av ? this.m_AVcrit_FINISHED.get() : 0) + (kpi ? this.m_KPIcrit_FINISHED.get() : 0);
            }
            case -2: {
                return (other ? this.m_maj_FINISHED.get() : 0) + (av ? this.m_AVmaj_FINISHED.get() : 0) + (kpi ? this.m_KPImaj_FINISHED.get() : 0);
            }
            case -3: {
                return (other ? this.m_min_FINISHED.get() : 0) + (av ? this.m_AVmin_FINISHED.get() : 0) + (kpi ? this.m_KPImin_FINISHED.get() : 0);
            }
            case -4: {
                return (other ? this.m_warn_FINISHED.get() : 0) + (av ? this.m_AVwarn_FINISHED.get() : 0) + (kpi ? this.m_KPIwarn_FINISHED.get() : 0);
            }
            case -5: {
                return (other ? this.m_normal_FINISHED.get() : 0) + (av ? this.m_AVnormal_FINISHED.get() : 0) + (kpi ? this.m_KPInormal_FINISHED.get() : 0);
            }
            case -6: {
                return (other ? this.m_unknown_FINISHED.get() : 0) + (av ? this.m_AVunknown_FINISHED.get() : 0) + (kpi ? this.m_KPIunknown_FINISHED.get() : 0);
            }
        }
        return 0;
    }

    public int getMaxAV() {
        int res = 1;
        if (this.m_AVcrit.get() > 0) {
            return 5;
        }
        if (this.m_AVmaj.get() > 0) {
            return 4;
        }
        if (this.m_AVmin.get() > 0) {
            return 3;
        }
        if (this.m_AVwarn.get() > 0) {
            return 2;
        }
        if (this.m_AVnormal.get() > 0) {
            return 1;
        }
        return res;
    }

    public int getMaxKPI() {
        int res = 1;
        if (this.m_KPIcrit.get() > 0) {
            return 5;
        }
        if (this.m_KPImaj.get() > 0) {
            return 4;
        }
        if (this.m_KPImin.get() > 0) {
            return 3;
        }
        if (this.m_KPIwarn.get() > 0) {
            return 2;
        }
        if (this.m_KPInormal.get() > 0) {
            return 1;
        }
        return res;
    }

    public int getMaxOther() {
        int res = 1;
        if (this.m_crit.get() > 0) {
            return 5;
        }
        if (this.m_maj.get() > 0) {
            return 4;
        }
        if (this.m_min.get() > 0) {
            return 3;
        }
        if (this.m_warn.get() > 0) {
            return 2;
        }
        if (this.m_normal.get() > 0) {
            return 1;
        }
        return res;
    }

    public int getMinAV() {
        int res = 1;
        if (this.m_AVnormal.get() > 0) {
            return 1;
        }
        if (this.m_AVwarn.get() > 0) {
            return 2;
        }
        if (this.m_AVmin.get() > 0) {
            return 3;
        }
        if (this.m_AVmaj.get() > 0) {
            return 4;
        }
        if (this.m_AVcrit.get() > 0) {
            return 5;
        }
        return res;
    }

    public int getMinKPI() {
        int res = 1;
        if (this.m_KPInormal.get() > 0) {
            return 1;
        }
        if (this.m_KPIwarn.get() > 0) {
            return 2;
        }
        if (this.m_KPImin.get() > 0) {
            return 3;
        }
        if (this.m_KPImaj.get() > 0) {
            return 4;
        }
        if (this.m_KPIcrit.get() > 0) {
            return 5;
        }
        return res;
    }

    public int getMinOther() {
        int res = 1;
        if (this.m_normal.get() > 0) {
            return 1;
        }
        if (this.m_warn.get() > 0) {
            return 2;
        }
        if (this.m_min.get() > 0) {
            return 3;
        }
        if (this.m_maj.get() > 0) {
            return 4;
        }
        if (this.m_crit.get() > 0) {
            return 5;
        }
        return res;
    }

    public int getCountKPI(boolean withUnknown, boolean withFinishedAlerts) {
        int count = this.m_KPIcrit.get() + this.m_KPImaj.get() + this.m_KPImin.get() + this.m_KPIwarn.get() + this.m_KPInormal.get();
        if (withUnknown) {
            count += this.m_KPIunknown.get();
        }
        if (withFinishedAlerts) {
            count += this.m_KPIcrit_FINISHED.get() + this.m_KPImaj_FINISHED.get() + this.m_KPImin_FINISHED.get() + this.m_KPIwarn_FINISHED.get() + this.m_KPInormal_FINISHED.get();
            if (withUnknown) {
                count += this.m_KPIunknown_FINISHED.get();
            }
        }
        return count;
    }

    public int getCountAV(boolean withUnknown, boolean withFinishedAlerts) {
        int count = this.m_AVcrit.get() + this.m_AVmaj.get() + this.m_AVmin.get() + this.m_AVwarn.get() + this.m_AVnormal.get();
        if (withUnknown) {
            count += this.m_AVunknown.get();
        }
        if (withFinishedAlerts) {
            count += this.m_AVcrit_FINISHED.get() + this.m_AVmaj_FINISHED.get() + this.m_AVmin_FINISHED.get() + this.m_AVwarn_FINISHED.get() + this.m_AVnormal_FINISHED.get();
            if (withUnknown) {
                count += this.m_AVunknown_FINISHED.get();
            }
        }
        return count;
    }

    public int getCountOther(boolean withUnknown, boolean withFinishedAlerts) {
        int count = this.m_crit.get() + this.m_maj.get() + this.m_min.get() + this.m_warn.get() + this.m_normal.get();
        if (withUnknown) {
            count += this.m_unknown.get();
        }
        if (withFinishedAlerts) {
            count += this.m_crit_FINISHED.get() + this.m_maj_FINISHED.get() + this.m_min_FINISHED.get() + this.m_warn_FINISHED.get() + this.m_normal_FINISHED.get();
            if (withUnknown) {
                count += this.m_unknown_FINISHED.get();
            }
        }
        return count;
    }

    public int getCountAll(boolean withUnknown, boolean withFinishedAlerts) {
        return this.getCountAV(withUnknown, withFinishedAlerts) + this.getCountKPI(withUnknown, withFinishedAlerts) + this.getCountOther(withUnknown, withFinishedAlerts);
    }

    public double getWAverageKPI() {
        int sum = this.getCountKPI(false, false);
        if (sum == 0) {
            return 0.0;
        }
        double val = (double)this.m_KPInormal.get() / (double)sum * Math.exp(1.0) + (double)this.m_KPIwarn.get() / (double)sum * Math.exp(2.0) + (double)this.m_KPImin.get() / (double)sum * Math.exp(3.0) + (double)this.m_KPImaj.get() / (double)sum * Math.exp(4.0) + (double)this.m_KPIcrit.get() / (double)sum * Math.exp(5.0);
        val = Math.log(val) / Math.log(Math.exp(5.0)) - 0.1;
        return val;
    }

    public double getWAverageAV() {
        int sum = this.getCountAV(false, false);
        if (sum == 0) {
            return 0.0;
        }
        double val = (double)this.m_AVnormal.get() / (double)sum * Math.exp(1.0) + (double)this.m_AVwarn.get() / (double)sum * Math.exp(2.0) + (double)this.m_AVmin.get() / (double)sum * Math.exp(3.0) + (double)this.m_AVmaj.get() / (double)sum * Math.exp(4.0) + (double)this.m_AVcrit.get() / (double)sum * Math.exp(5.0);
        val = Math.log(val) / Math.log(Math.exp(5.0)) - 0.1;
        return val;
    }

    public double getWAverageOther() {
        int sum = this.getCountOther(false, false);
        if (sum == 0) {
            return 0.0;
        }
        double val = (double)this.m_normal.get() / (double)sum * Math.exp(1.0) + (double)this.m_warn.get() / (double)sum * Math.exp(2.0) + (double)this.m_min.get() / (double)sum * Math.exp(3.0) + (double)this.m_maj.get() / (double)sum * Math.exp(4.0) + (double)this.m_crit.get() / (double)sum * Math.exp(5.0);
        val = Math.log(val) / Math.log(Math.exp(5.0)) - 0.1;
        return val;
    }

    public Collection<SEventFwd> getEventsAV(int severity) {
        LinkedList<SEventFwd> res = new LinkedList<SEventFwd>();
        for (SEventFwd se : this.m_values.keySet()) {
            if (se.getTypeA() <= 0 || se.getSeverityInt() != severity) continue;
            res.add(se);
        }
        return res;
    }

    public Collection<SEventFwd> getEventsKPI(int severity) {
        LinkedList<SEventFwd> res = new LinkedList<SEventFwd>();
        for (SEventFwd se : this.m_values.keySet()) {
            if (se.getTypeK() <= 0 || se.getSeverityInt() != severity) continue;
            res.add(se);
        }
        return res;
    }

    public Collection<SEventFwd> getEventsOther(int severity) {
        LinkedList<SEventFwd> res = new LinkedList<SEventFwd>();
        for (SEventFwd se : this.m_values.keySet()) {
            if (se.getTypeK() != 0 || se.getTypeA() != 0 || se.getSeverityInt() != severity) continue;
            res.add(se);
        }
        return res;
    }

    public boolean containsOneOf(Collection<SEventFwd> col) {
        Iterator<SEventFwd> it = col.iterator();
        while (it.hasNext()) {
            if (!this.m_values.keySet().contains(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public EventsAndStatus getEvents() {
        return this;
    }

    public Map<SEventFwd, SEventFwd> getEventMap() {
        return this.m_values;
    }

    @Override
    public int getStatusAV() {
        int res = 1;
        if (this.m_AVcrit.get() > 0 || this.m_AVcrit_FINISHED.get() > 0) {
            return 5;
        }
        if (this.m_AVmaj.get() > 0 || this.m_AVmaj_FINISHED.get() > 0) {
            return 4;
        }
        if (this.m_AVmin.get() > 0 || this.m_AVmin_FINISHED.get() > 0) {
            return 3;
        }
        if (this.m_AVwarn.get() > 0 || this.m_AVwarn_FINISHED.get() > 0) {
            return 2;
        }
        if (this.m_AVnormal.get() > 0 || this.m_AVnormal_FINISHED.get() > 0) {
            return 1;
        }
        return res;
    }

    @Override
    public int getStatusKPI() {
        int res = 1;
        if (this.m_KPIcrit.get() > 0 || this.m_KPIcrit_FINISHED.get() > 0) {
            return 5;
        }
        if (this.m_KPImaj.get() > 0 || this.m_KPImaj_FINISHED.get() > 0) {
            return 4;
        }
        if (this.m_KPImin.get() > 0 || this.m_KPImin_FINISHED.get() > 0) {
            return 3;
        }
        if (this.m_KPIwarn.get() > 0 || this.m_KPIwarn_FINISHED.get() > 0) {
            return 2;
        }
        if (this.m_KPInormal.get() > 0 || this.m_KPInormal_FINISHED.get() > 0) {
            return 1;
        }
        return res;
    }

    @Override
    public int getStatusOther() {
        int res = 1;
        if (this.m_crit.get() > 0 || this.m_crit_FINISHED.get() > 0) {
            return 5;
        }
        if (this.m_maj.get() > 0 || this.m_maj_FINISHED.get() > 0) {
            return 4;
        }
        if (this.m_min.get() > 0 || this.m_min_FINISHED.get() > 0) {
            return 3;
        }
        if (this.m_warn.get() > 0 || this.m_warn_FINISHED.get() > 0) {
            return 2;
        }
        if (this.m_normal.get() > 0 || this.m_normal_FINISHED.get() > 0) {
            return 1;
        }
        return res;
    }

    @Override
    public void invalidateStatus() {
    }
}

