/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.Interval;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ModifyServerPolicy;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.DiffComparable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ExtendedServerPolicy
extends ModifyServerPolicy {
    protected boolean m_insertAsClosed = false;
    protected Map<String, String> m_CAs = null;
    protected boolean m_await = false;
    protected boolean m_awaitDropOriginal = false;
    protected boolean m_awaitAcknowledge = false;
    protected boolean m_awaitInsertAsClosed = false;
    protected String m_awaitInterval = "";
    protected String m_awaitSetText = "";
    protected String m_setKey = "";
    protected String m_setCloseMask = "";
    protected String m_setAutoAction = "";
    protected String m_setAutoActionNode = "";
    protected int m_setAutoActionTimeoutSec = 120;
    protected boolean m_overwriteAV_KPI = false;
    protected boolean m_AV = false;
    protected boolean m_KPI = false;
    protected boolean m_overwriteDeDuplication = false;
    protected boolean m_deduplicate = true;
    protected boolean m_deduplicateKeyOnly = false;
    protected List<ForwardFilter> m_nodeGroupFilters = new ArrayList<ForwardFilter>(0);
    protected transient long m_runtimeAwaitInterval_ms = 0L;
    protected transient Map<String, Long> m_runtimeAgent2Time = null;

    public ExtendedServerPolicy(ModifyServerPolicy mp) {
        super(mp);
        this.m_awaitInterval = null;
        this.m_awaitSetText = "";
        this.m_CAs = null;
        this.m_await = false;
        this.m_awaitDropOriginal = false;
        this.m_awaitAcknowledge = false;
        this.m_awaitInsertAsClosed = false;
        this.m_insertAsClosed = false;
        this.m_runtimeAwaitInterval_ms = 0L;
    }

    public ExtendedServerPolicy(String uuid, String name) {
        super(uuid, name);
    }

    @Override
    public Object read(SDataInputStream is) throws IOException {
        super.read(is);
        this.m_insertAsClosed = is.readBoolean();
        this.m_await = is.readBoolean();
        this.m_awaitDropOriginal = is.readBoolean();
        this.m_awaitAcknowledge = is.readBoolean();
        this.m_awaitInterval = is.readUTF();
        this.m_awaitSetText = is.readUTF();
        this.m_awaitInsertAsClosed = is.readBoolean();
        this.m_setKey = is.readUTF();
        this.m_setCloseMask = is.readUTF();
        this.m_setAutoAction = is.readUTF();
        this.m_setAutoActionNode = is.readUTF();
        this.m_deduplicate = is.readBoolean();
        this.m_deduplicateKeyOnly = is.readBoolean();
        this.m_setAutoActionTimeoutSec = is.readInt();
        this.m_overwriteAV_KPI = is.readBoolean();
        this.m_overwriteDeDuplication = is.readBoolean();
        this.m_AV = is.readBoolean();
        this.m_KPI = is.readBoolean();
        while (is.readBoolean()) {
            int countProps = is.readInt();
            Properties prop = new Properties();
            int i = 0;
            while (i < countProps) {
                String key = is.readUTF();
                String value = is.readUTF();
                prop.setProperty(key, value);
                ++i;
            }
            try {
                ForwardFilter ff = ForwardFilter.getInstance(prop);
                this.m_nodeGroupFilters.add(ff);
            }
            catch (Throwable e) {
                RTLogger.print(2, "Invalid NGFilter: " + prop, e);
            }
        }
        while (is.readBoolean()) {
            if (this.m_CAs == null) {
                this.m_CAs = new HashMap<String, String>(2);
            }
            String caName = is.readUTF();
            String value = is.readUTF();
            this.m_CAs.put(caName, value);
        }
        while (is.readBoolean()) {
            is.readUTF();
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream os) throws IOException {
        super.send(os);
        os.writeBoolean(this.m_insertAsClosed);
        os.writeBoolean(this.m_await);
        os.writeBoolean(this.m_awaitDropOriginal);
        os.writeBoolean(this.m_awaitAcknowledge);
        os.writeUTF(this.m_awaitInterval);
        os.writeUTF(this.m_awaitSetText);
        os.writeBoolean(this.m_awaitInsertAsClosed);
        os.writeUTF(this.m_setKey);
        os.writeUTF(this.m_setCloseMask);
        os.writeUTF(this.m_setAutoAction);
        os.writeUTF(this.m_setAutoActionNode);
        os.writeBoolean(this.m_deduplicate);
        os.writeBoolean(this.m_deduplicateKeyOnly);
        os.writeInt(this.m_setAutoActionTimeoutSec);
        os.writeBoolean(this.m_overwriteAV_KPI);
        os.writeBoolean(this.m_overwriteDeDuplication);
        os.writeBoolean(this.m_AV);
        os.writeBoolean(this.m_KPI);
        Iterator<ForwardFilter> it = this.getNodeGroupFilters().iterator();
        os.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            ForwardFilter forwardFilter = it.next();
            Properties p = forwardFilter.getProperties();
            os.writeInt(p.size());
            for (Map.Entry<Object, Object> en : p.entrySet()) {
                String key = (String)en.getKey();
                String value = (String)en.getValue();
                if (value == null) {
                    value = "";
                }
                os.writeUTF(key);
                os.writeUTF(value);
            }
            os.writeBoolean(it.hasNext());
        }
        if (this.m_CAs != null && this.m_CAs.size() > 0) {
            for (Map.Entry<String, String> en : this.m_CAs.entrySet()) {
                os.writeBoolean(true);
                os.writeUTF(en.getKey());
                os.writeUTF(en.getValue());
            }
            os.writeBoolean(false);
        } else {
            os.writeBoolean(false);
        }
        os.writeBoolean(false);
    }

    public boolean isInsertAsClosed() {
        return this.m_insertAsClosed;
    }

    public void setInsertAsClosed(boolean insertAsClosed) {
        this.m_insertAsClosed = insertAsClosed;
    }

    public Map<String, String> getCAs() {
        return this.m_CAs;
    }

    public void addCAs(String caName, String value) {
        if (this.m_CAs == null) {
            this.m_CAs = new HashMap<String, String>(2);
        }
        this.m_CAs.put(caName, value);
    }

    public String getCA(String caName) {
        return this.m_CAs == null ? null : this.m_CAs.get(caName);
    }

    public boolean isAwait() {
        return this.m_await;
    }

    public void setAwait(boolean createNewIndi) {
        this.m_await = createNewIndi;
    }

    public boolean isAwaitAcknowlede() {
        return this.m_awaitAcknowledge;
    }

    public void setAwaitAcknowledge(boolean doAcknowlede) {
        this.m_awaitAcknowledge = doAcknowlede;
    }

    public String getAwaitInterval() {
        return this.m_awaitInterval;
    }

    public void setAwaitInterval(String awaitInterval) {
        this.m_awaitInterval = awaitInterval;
    }

    public long getRuntimeAwaitInterval_ms() {
        if (this.m_await && this.m_runtimeAwaitInterval_ms == 0L) {
            this.m_runtimeAwaitInterval_ms = Interval.parseInterval(this.m_awaitInterval, -1).getIntervalMilliseconds();
            if (this.m_runtimeAwaitInterval_ms < 1000L) {
                this.setDisabled("Server detects invalid interval");
            }
        }
        return this.m_runtimeAwaitInterval_ms;
    }

    public String getAwaitSetText() {
        return this.m_awaitSetText;
    }

    public void setAwaitSetText(String awaitSetText) {
        this.m_awaitSetText = awaitSetText;
    }

    public boolean isAwaitInsertAsClosed() {
        return this.m_awaitInsertAsClosed;
    }

    public void setAwaitInsertAsClosed(boolean awaitInsertAsClosed) {
        this.m_awaitInsertAsClosed = awaitInsertAsClosed;
    }

    public boolean isAwaitDropOriginal() {
        return this.m_awaitDropOriginal;
    }

    public void setAwaitDropOriginal(boolean dropOriginal) {
        this.m_awaitDropOriginal = dropOriginal;
    }

    @Override
    public void updateFrom(OutagePolicy sp) {
        super.updateFrom(sp);
        if (sp instanceof ExtendedServerPolicy) {
            ExtendedServerPolicy ep = (ExtendedServerPolicy)sp;
            this.m_insertAsClosed = ep.m_insertAsClosed;
            this.m_await = ep.m_await;
            this.m_awaitDropOriginal = ep.m_awaitDropOriginal;
            this.m_awaitAcknowledge = ep.m_awaitAcknowledge;
            this.m_awaitInterval = ep.m_awaitInterval;
            this.m_awaitSetText = ep.m_awaitSetText;
            this.m_awaitInsertAsClosed = ep.m_awaitInsertAsClosed;
            this.m_setKey = ep.m_setKey;
            this.m_setCloseMask = ep.m_setCloseMask;
            this.m_setAutoAction = ep.m_setAutoAction;
            this.m_setAutoActionNode = ep.m_setAutoActionNode;
            this.m_deduplicate = ep.m_deduplicate;
            this.m_deduplicateKeyOnly = ep.m_deduplicateKeyOnly;
            this.m_setAutoActionTimeoutSec = ep.m_setAutoActionTimeoutSec;
            this.m_overwriteAV_KPI = ep.m_overwriteAV_KPI;
            this.m_overwriteDeDuplication = ep.m_overwriteDeDuplication;
            this.m_AV = ep.m_AV;
            this.m_KPI = ep.m_KPI;
            this.m_nodeGroupFilters = ep.getNodeGroupFilters();
            this.m_CAs = ep.getCAs();
            this.rebuildAgent2TimeRtMap();
        }
    }

    @Override
    public int hashCode() {
        return this.m_name == null ? 0 : this.m_name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        boolean eq = false;
        if (obj instanceof ExtendedServerPolicy && (eq = super.equals(obj))) {
            ExtendedServerPolicy other = (ExtendedServerPolicy)obj;
            boolean bl = (this.m_awaitInterval == null ? other.m_awaitInterval == null : this.m_awaitInterval.equals(this.m_awaitInterval)) && (this.m_awaitSetText == null ? other.m_awaitSetText == null : this.m_awaitSetText.equals(this.m_awaitSetText)) && this.m_await == other.m_await && this.m_awaitDropOriginal == other.m_awaitDropOriginal && this.m_awaitAcknowledge == other.m_awaitAcknowledge && this.m_insertAsClosed == other.m_insertAsClosed && this.m_runtimeAwaitInterval_ms == other.m_runtimeAwaitInterval_ms && (this.m_setKey == null ? other.m_setKey == null : this.m_setKey.equals(this.m_setKey)) && (this.m_setCloseMask == null ? other.m_setCloseMask == null : this.m_setCloseMask.equals(this.m_setCloseMask)) && (this.m_setAutoAction == null ? other.m_setAutoAction == null : this.m_setAutoAction.equals(this.m_setAutoAction)) && (this.m_setAutoActionNode == null ? other.m_setAutoActionNode == null : this.m_setAutoActionNode.equals(this.m_setAutoActionNode)) && this.m_deduplicate == other.m_deduplicate && this.m_deduplicateKeyOnly == other.m_deduplicateKeyOnly && this.m_setAutoActionTimeoutSec == other.m_setAutoActionTimeoutSec && this.m_overwriteAV_KPI == other.m_overwriteAV_KPI && this.m_overwriteDeDuplication == other.m_overwriteDeDuplication && this.m_AV == other.m_AV && this.m_KPI == other.m_KPI ? true : (eq = false);
            if (eq) {
                int size = this.m_CAs == null ? 0 : this.m_CAs.size();
                int otherSize = other.m_CAs == null ? 0 : other.m_CAs.size();
                boolean bl2 = eq = size == otherSize;
                if (eq && size > 0 && this.m_CAs != null) {
                    for (Map.Entry<String, String> en : this.m_CAs.entrySet()) {
                        String otherValue = other.m_CAs.get(en.getKey());
                        boolean bl3 = en.getValue() == null ? otherValue == null : (eq = en.getValue().equals(otherValue));
                        if (!eq) break;
                    }
                }
                if (eq && this.m_nodeGroupFilters.size() == other.m_nodeGroupFilters.size()) {
                    int i = 0;
                    while (i < this.m_nodeGroupFilters.size()) {
                        ForwardFilter f1 = this.m_nodeGroupFilters.get(i);
                        ForwardFilter f2 = other.m_nodeGroupFilters.get(i);
                        if (f1 != null || f2 != null) {
                            try {
                                if (f1 == null || f2 == null || f1.m_attribute != f2.m_attribute || !f1.m_pattern.equals(f2.m_pattern)) {
                                    return false;
                                }
                            }
                            catch (Throwable throwable) {
                                return false;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        return eq;
    }

    public String getSetKey() {
        return this.m_setKey;
    }

    public void setSetKey(String setKey) {
        this.m_setKey = setKey;
    }

    public String getSetCloseMask() {
        return this.m_setCloseMask;
    }

    public void setSetCloseMask(String setCloseMask) {
        this.m_setCloseMask = setCloseMask;
    }

    public void addNodeGroupFilter(NodeGroupForwardFilter f) {
        this.m_nodeGroupFilters.add(f);
    }

    public List<ForwardFilter> getNodeGroupFilters() {
        return this.m_nodeGroupFilters;
    }

    public void setNodeGroupFilters(List<ForwardFilter> nodeGroupFilters) {
        this.m_nodeGroupFilters = nodeGroupFilters;
    }

    public String getSetAutoAction() {
        return this.m_setAutoAction;
    }

    public void setSetAutoAction(String setAutoAction) {
        this.m_setAutoAction = setAutoAction;
    }

    public String getSetAutoActionNode() {
        return this.m_setAutoActionNode;
    }

    public void setSetAutoActionNode(String setAutoActionNode) {
        this.m_setAutoActionNode = setAutoActionNode;
    }

    public boolean isDeduplicate() {
        return this.m_deduplicate;
    }

    public void setDeduplicate(boolean deduplicate) {
        this.m_deduplicate = deduplicate;
    }

    public boolean isDeduplicateKeyOnly() {
        return this.m_deduplicateKeyOnly;
    }

    public void setDeduplicateKeyOnly(boolean deduplicateKeyOnly) {
        this.m_deduplicateKeyOnly = deduplicateKeyOnly;
    }

    public int getSetAutoActionTimeoutSec() {
        return this.m_setAutoActionTimeoutSec;
    }

    public void setSetAutoActionTimeoutSec(int setAutoActionTimeoutSec) {
        this.m_setAutoActionTimeoutSec = setAutoActionTimeoutSec;
    }

    public boolean isAV() {
        return this.m_AV;
    }

    public void setAV(boolean aV) {
        this.m_AV = aV;
    }

    public boolean isKPI() {
        return this.m_KPI;
    }

    public void setKPI(boolean kPI) {
        this.m_KPI = kPI;
    }

    public boolean isOverwriteAV_KPI() {
        return this.m_overwriteAV_KPI;
    }

    public void setOverwriteAV_KPI(boolean overwriteAVKPI) {
        this.m_overwriteAV_KPI = overwriteAVKPI;
    }

    public boolean isOverwriteDeDuplication() {
        return this.m_overwriteDeDuplication;
    }

    public void setOverwriteDeDuplication(boolean overwriteDeDuplication) {
        this.m_overwriteDeDuplication = overwriteDeDuplication;
    }

    public void rebuildAgent2TimeRtMap() {
        if (this.m_runtimeAgent2Time == null) {
            this.getAgent2TimeRtMap();
        } else {
            HashMap<String, Long> mapNow = new HashMap<String, Long>();
            for (ForwardFilter ff : this.m_nodeGroupFilters) {
                if (!(ff instanceof NodeGroupForwardFilter)) continue;
                NodeGroupForwardFilter ngff = (NodeGroupForwardFilter)ff;
                for (String agentID : ngff.getAllAgentIDs().keySet()) {
                    mapNow.put(agentID, System.currentTimeMillis());
                }
            }
            DiffComparable<String> idDiff = new DiffComparable<String>(mapNow.keySet(), this.m_runtimeAgent2Time.keySet());
            this.m_runtimeAgent2Time.keySet().removeAll(idDiff.deletedObjects.keySet());
            for (String id : idDiff.newObjects.keySet()) {
                this.m_runtimeAgent2Time.put(id, System.currentTimeMillis());
            }
        }
    }

    public Map<String, Long> getAgent2TimeRtMap() {
        if (this.m_runtimeAgent2Time == null) {
            this.m_runtimeAgent2Time = new ConcurrentHashMap<String, Long>();
            for (ForwardFilter ff : this.m_nodeGroupFilters) {
                if (!(ff instanceof NodeGroupForwardFilter)) continue;
                NodeGroupForwardFilter ngff = (NodeGroupForwardFilter)ff;
                for (String agentID : ngff.getAllAgentIDs().keySet()) {
                    this.m_runtimeAgent2Time.put(agentID, System.currentTimeMillis());
                }
            }
        }
        return this.m_runtimeAgent2Time;
    }

    public List<String> checkNodeGroupsAndApplyTime(SEventFwd sef) {
        ArrayList<String> matchedAgentIDs = new ArrayList<String>(2);
        Map<String, Long> agent2TimeRtMap = this.getAgent2TimeRtMap();
        if (agent2TimeRtMap.containsKey(sef.getT1())) {
            agent2TimeRtMap.put(sef.getT1(), System.currentTimeMillis());
            matchedAgentIDs.add(sef.getT1());
        }
        for (ForwardFilter ff : this.m_nodeGroupFilters) {
            if (!(ff instanceof NodeGroupForwardFilter)) continue;
            NodeGroupForwardFilter ngff = (NodeGroupForwardFilter)ff;
            List<? extends AbstractAgentCard> externalHosts = ngff.getExternalHosts(sef.getNode());
            for (AbstractAgentCard abstractAgentCard : externalHosts) {
                if (!agent2TimeRtMap.containsKey(abstractAgentCard.getAgentID())) continue;
                agent2TimeRtMap.put(abstractAgentCard.getAgentID(), System.currentTimeMillis());
                matchedAgentIDs.add(abstractAgentCard.getAgentID());
            }
        }
        return matchedAgentIDs;
    }
}

