/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.exceptions.ConfigException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class ForwardCondition {
    private static final ArrayList<String> EMPTY_ARRAY_LIST = new ArrayList(0);
    public static String TO = "TO";
    public static String TYPE = "TYPE";
    public static String ACTIVATION_TIME = "ACTIVATE";
    public static String DEACTIVATION_TIME = "DEACTIVATE";
    public static final String MASK_ALL = "<*>";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "C_DESCRIPTION";
    public static final String TARGET_ID = "TARGET_ID";
    public static final String SEVERITY = "SEVERITY";
    public static final String APPLICATION = "APPLICATION";
    public static final String OBJECT = "OBJECT";
    public static final String MSGGRP = "MSGGRP";
    public static final String NODE = "NODE";
    public static final String TYPE_A = "TYPE_A";
    public static final String TYPE_K = "TYPE_K";
    public static final String AGENT = "BOOM_AGENT";
    public static final String XSEND = "XSEND";
    public static String TYPE_EXEC = "EXEC";
    public static String TYPE_EXEC_IS = "EXEC_IS";
    public static String TYPE_JAVA = "JAVA";
    public static String TYPE_HTTP = "HTTP";
    public static String TYPE_NOTIFICATION = "NOTIFICATION";
    public static String TYPE_USERS = "USERS";
    public static String SMSG_TEXT = "<$SMSG_TEXT>";
    public String name = null;
    public String description = null;
    public String target_id = null;
    public String severity = "<*>";
    public int type_a = 0;
    public int type_k = 0;
    public String type = TYPE_EXEC;
    public String to = "";
    public String activation_time = null;
    public String deactivation_time = null;
    public String xsend = SMSG_TEXT;
    public int startTime = 0;
    public int endTime = 0;
    public List<String> m_users = new ArrayList<String>(1);
    public boolean forwardALL = false;
    private Calendar calendar = Calendar.getInstance();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ForwardCondition getInstance(Properties prop) {
        ForwardCondition c = new ForwardCondition();
        c.name = (String)prop.get(NAME);
        c.description = (String)prop.get(DESCRIPTION);
        c.target_id = (String)prop.get(TARGET_ID);
        if (c.target_id == null) {
            c.target_id = UUID.randomUUID().toString();
        }
        c.severity = (String)prop.get(SEVERITY);
        if (c.severity == null || c.severity.isEmpty()) {
            c.severity = "0,1,2,3,4,5";
        } else if (c.severity.equals(MASK_ALL)) {
            c.severity = "0,1,2,3,4,5";
        } else {
            c.severity = c.severity.toLowerCase();
            c.severity = c.severity.replace("unknown", "0");
            c.severity = c.severity.replace("normal", "1");
            c.severity = c.severity.replace("warning", "2");
            c.severity = c.severity.replace("minor", "3");
            c.severity = c.severity.replace("major", "4");
            c.severity = c.severity.replace("critical", "5");
        }
        c.type_a = ForwardCondition.getInteger(prop, TYPE_A);
        c.type_k = ForwardCondition.getInteger(prop, TYPE_K);
        c.xsend = (String)prop.get(XSEND);
        if (c.xsend == null || c.xsend.isEmpty()) {
            c.xsend = SMSG_TEXT;
        }
        if (c.severity.equals(MASK_ALL) && c.type_a == 0 && c.type_k == 0 && c.endTime == 0 && c.startTime == 0) {
            c.forwardALL = true;
        }
        c.type = prop.getProperty(TYPE);
        if (c.type == null) throw new ConfigException(String.valueOf(TYPE) + " attribute missed. Must be EXEC | EXEC_IS | JAVA | HTTP | SMTP | USERS");
        c.type = c.type.trim();
        if (!c.type.equalsIgnoreCase(TYPE_EXEC) && !c.type.equalsIgnoreCase(TYPE_EXEC_IS) && !c.type.equalsIgnoreCase(TYPE_JAVA) && !c.type.equalsIgnoreCase(TYPE_HTTP) && !c.type.equalsIgnoreCase(TYPE_NOTIFICATION) && !c.type.equalsIgnoreCase(TYPE_USERS)) throw new ConfigException("Unknown " + TYPE + ". Must be EXEC | EXEC_IS | JAVA | HTTP | SMTP | USERS");
        c.to = prop.getProperty(TO);
        if (c.to == null || c.to.length() <= 0) {
            throw new ConfigException(String.valueOf(TO) + " attribute is empty.");
        }
        ForwardCondition.getUserRoleList(c);
        c.activation_time = prop.getProperty(ACTIVATION_TIME);
        c.deactivation_time = prop.getProperty(DEACTIVATION_TIME);
        if (c.activation_time == null || c.deactivation_time == null || c.activation_time.indexOf(58) == -1 || c.deactivation_time.indexOf(58) == -1) return c;
        c.startTime = Integer.parseInt(c.activation_time.replace(":", ""));
        c.endTime = Integer.parseInt(c.deactivation_time.replace(":", ""));
        return c;
    }

    public static List<String> getUserRoleList(ForwardCondition c) {
        if (c.to != null) {
            c.m_users.clear();
            if (c.to.length() > 0) {
                c.to = c.to.trim();
                if (c.isUsersType()) {
                    String[] arr = c.to.split(",");
                    int i = 0;
                    while (i < arr.length) {
                        String u = arr[i].trim();
                        if (!c.m_users.contains(u)) {
                            c.m_users.add(u);
                        }
                        ++i;
                    }
                }
                Collections.sort(c.m_users);
            }
            return c.m_users;
        }
        return EMPTY_ARRAY_LIST;
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.setProperty(NAME, this.name);
        p.setProperty(DESCRIPTION, this.description);
        p.setProperty(TARGET_ID, this.target_id);
        p.setProperty(SEVERITY, this.severity);
        p.setProperty(XSEND, this.xsend);
        p.setProperty(TYPE_A, "" + this.type_a);
        p.setProperty(TYPE_K, "" + this.type_k);
        p.setProperty(TYPE, this.type);
        p.setProperty(TO, this.to);
        p.setProperty(ACTIVATION_TIME, this.activation_time);
        p.setProperty(DEACTIVATION_TIME, this.deactivation_time);
        return p;
    }

    public static int getInteger(Properties prop, String name) {
        int ret = 0;
        String suppressCount = (String)prop.get(name);
        if (suppressCount != null) {
            try {
                int res = Integer.parseInt(suppressCount);
                if (res >= 0) {
                    ret = res;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return ret;
    }

    public static ForwardCondition getNew(int number) {
        ForwardCondition cn = new ForwardCondition();
        cn.target_id = UUID.randomUUID().toString();
        cn.name = "Condition Name " + number;
        cn.description = "Description for Condition " + number;
        cn.severity = MASK_ALL;
        cn.xsend = SMSG_TEXT;
        cn.type_a = 0;
        cn.type_k = 0;
        cn.activation_time = "";
        cn.deactivation_time = "";
        cn.type = TYPE_USERS;
        cn.to = "";
        return cn;
    }

    public boolean checkTimeRange(long time) {
        if (this.endTime == 0 && this.startTime == 0) {
            return true;
        }
        this.calendar.setTimeInMillis(time);
        int h = this.calendar.get(11);
        int m = this.calendar.get(12);
        int res = h * 100 + m;
        if (this.endTime < this.startTime) {
            return res >= this.startTime && res <= 2400 || res < this.endTime;
        }
        return res >= this.startTime && res < this.endTime;
    }

    public boolean checkSeverity(String sev) {
        return this.severity.indexOf(sev) != -1;
    }

    public boolean checkTypeAandK(int typeA, int typeK) {
        if (this.type_a == 0 && this.type_k == 0) {
            return true;
        }
        if (this.type_a >= 1 && this.type_k >= 1) {
            return typeA >= this.type_a || typeK >= this.type_k;
        }
        if (typeA > 0) {
            return typeA >= this.type_a;
        }
        return typeK >= this.type_k;
    }

    @Deprecated
    public boolean checkTypeA(int typeA) {
        return typeA >= this.type_a;
    }

    @Deprecated
    public boolean checkTypeK(int typeK) {
        return typeK >= this.type_k;
    }

    public boolean isUsersType() {
        return this.type.equals(TYPE_USERS);
    }

    public List<String> getUsersAssociated() {
        return ForwardCondition.getUserRoleList(this);
    }
}

