/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.IID;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.PatternMatcherThread;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.exceptions.PolicyException;
import com.blixx.shared.ext.AgentIDForwardFilter;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

public class ForwardFilter
implements IID {
    public static final int TYPE_APP = 1;
    public static final int TYPE_GRP = 2;
    public static final int TYPE_OBJ = 3;
    public static final int TYPE_HOST = 4;
    public static final int TYPE_SERVICE = 5;
    public static final int TYPE_CA1 = 6;
    public static final int TYPE_CA2 = 7;
    public static final int TYPE_CA3 = 8;
    public static final int TYPE_CA4 = 9;
    public static final int TYPE_CA5 = 10;
    public static final int TYPE_CA6 = 11;
    public static final int TYPE_CA7 = 12;
    public static final int TYPE_CA8 = 13;
    public static final int TYPE_CA9 = 14;
    public static final int TYPE_CA10 = 15;
    public static final int TYPE_CA11 = 16;
    public static final int TYPE_CA12 = 17;
    public static final int TYPE_CA13 = 18;
    public static final int TYPE_CA14 = 19;
    public static final int TYPE_CA15 = 20;
    public static final int TYPE_NODEGROUP = 21;
    public static final int TYPE_SOURCE = 22;
    public static final int TYPE_TEXT = 23;
    public static final int TYPE_SEVERITY = 24;
    public static final int TYPE_KEY = 25;
    public static final int TYPE_AGENTID = 26;
    public static final int TYPE_AGENTHOST = 27;
    public static final int TYPE_CA = 28;
    public static final int TYPE_SLAVE = 34;
    public static final String APPLICATION = "APPLICATION";
    public static final String MSGGRP = "GROUP";
    public static final String OBJECT = "OBJECT";
    public static final String NODE = "HOST";
    public static final String NODE_ALIAS = "NODE";
    public static final String SERVICE = "SERVICE";
    public static final String CA = "CA";
    public static final String NODEGROUP = "NODEGROUP";
    public static final String SOURCE = "SOURCE";
    public static final String TEXT = "TEXT";
    public static final String SEVERITY = "SEVERITY";
    public static final String KEY = "KEY";
    public static final String AGENTID = "AGENTID";
    public static final String AGENTHOST = "AGENTHOST";
    public static final String SLAVE_SERVER = "SLAVE_SERVER";
    public static final String NAME = "NAME";
    public static final String DESCR = "DESCRIPTION";
    public static final String FILTER_NUMBER = "FILTER_NUMBER";
    public static final String ATTRIBUTE = "ATTRIBUTE";
    public static final String PATTERN = "PATTERN";
    public static String[] TYPES = new String[]{"APPLICATION", "GROUP", "OBJECT", "HOST", "SERVICE", "CA1", "CA2", "CA3", "CA4", "CA5", "CA6", "CA7", "CA8", "CA9", "CA10", "CA11", "CA12", "CA13", "CA14", "CA15", "NODEGROUP", "SOURCE", "TEXT", "SEVERITY", "KEY", "AGENTID", "AGENTHOST", "SLAVE_SERVER", "CA"};
    protected String m_description = null;
    protected String m_name = null;
    protected Integer m_number = 0;
    protected PatternB m_pattern = null;
    protected int m_attribute = 0;

    static {
        Arrays.sort(TYPES);
    }

    protected ForwardFilter() {
    }

    public static ForwardFilter getFakeFilter(int number) {
        ForwardFilter ff = new ForwardFilter();
        ff.m_name = "Missing filter #" + number;
        ff.m_number = number;
        ff.m_attribute = 24;
        ff.m_description = "Error lookup filter by associated number. Please re-create or select another filter. Current filter will never match.";
        try {
            ff.m_pattern = PatternB.getPattern("notdefined");
        }
        catch (PolicyException policyException) {}
        return ff;
    }

    public static ForwardFilter getInstance(Properties prop) {
        ForwardFilter ff = new ForwardFilter();
        ff.m_name = prop.getProperty(NAME, "not specified");
        ff.m_description = prop.getProperty(DESCR, "");
        String attribute = prop.getProperty(ATTRIBUTE);
        if (attribute == null) {
            throw new RuntimeException("Required attribute ATTRIBUTE not found");
        }
        ff.m_attribute = ForwardFilter.getAttributeNumber(attribute);
        if (ff.m_attribute == 0) {
            throw new RuntimeException("Value of ATTRIBUTE not supported. Value=" + attribute);
        }
        if (ff.m_attribute == 21) {
            return NodeGroupForwardFilter.getInstance(prop);
        }
        if (ff.m_attribute == 26) {
            return AgentIDForwardFilter.getInstance(prop);
        }
        try {
            String pattern = prop.getProperty(PATTERN);
            ff.m_pattern = PatternB.getPattern(pattern);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("PATTERN is invalid for the ForwardFilter " + ff.m_name);
        }
        try {
            ff.m_number = Integer.valueOf(prop.getProperty(FILTER_NUMBER));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("FILTER_NUMBER is invalid for the ForwardFilter " + ff.m_name);
        }
        return ff;
    }

    public Integer getNumber() {
        return this.m_number;
    }

    public String getName() {
        return this.m_name;
    }

    public int getType() {
        return this.m_attribute;
    }

    public PatternMatchResult check(String text) {
        if (text == null) {
            return PatternMatchResult.FALSE;
        }
        PatternMatchResult matchesR = PatternMatcherThread.match(this.m_pattern, text);
        return matchesR == null ? PatternMatchResult.FALSE : matchesR;
    }

    public PatternMatchResult check(Map<String, String> customAttributes) {
        if (customAttributes == null) {
            return PatternMatchResult.FALSE;
        }
        for (Map.Entry<String, String> en : customAttributes.entrySet()) {
            PatternMatchResult matchesR = PatternMatcherThread.match(this.m_pattern, en.getValue());
            if (!en.getKey().startsWith(CA) || matchesR == null) continue;
            return matchesR;
        }
        return PatternMatchResult.FALSE;
    }

    public static int getAttributeNumber(String attrName) {
        if (attrName.equalsIgnoreCase(APPLICATION)) {
            return 1;
        }
        if (attrName.equalsIgnoreCase(MSGGRP)) {
            return 2;
        }
        if (attrName.equalsIgnoreCase(OBJECT)) {
            return 3;
        }
        if (attrName.equalsIgnoreCase(NODE)) {
            return 4;
        }
        if (attrName.equalsIgnoreCase(NODE_ALIAS)) {
            return 4;
        }
        if (attrName.equalsIgnoreCase(SERVICE)) {
            return 5;
        }
        if (attrName.equalsIgnoreCase(CA)) {
            return 28;
        }
        if (attrName.startsWith(CA)) {
            try {
                int pos = Integer.parseInt(attrName.substring(2));
                return pos += 5;
            }
            catch (Throwable throwable) {}
        }
        if (attrName.equalsIgnoreCase(NODEGROUP)) {
            return 21;
        }
        if (attrName.equalsIgnoreCase(SOURCE)) {
            return 22;
        }
        if (attrName.equalsIgnoreCase(TEXT)) {
            return 23;
        }
        if (attrName.equalsIgnoreCase(SEVERITY)) {
            return 24;
        }
        if (attrName.equalsIgnoreCase(KEY)) {
            return 25;
        }
        if (attrName.equalsIgnoreCase(AGENTID)) {
            return 26;
        }
        if (attrName.equalsIgnoreCase(AGENTHOST)) {
            return 27;
        }
        if (attrName.equalsIgnoreCase(SLAVE_SERVER)) {
            return 34;
        }
        return 0;
    }

    public static String getAttributeName(int number) {
        switch (number) {
            case 1: {
                return APPLICATION;
            }
            case 2: {
                return MSGGRP;
            }
            case 3: {
                return OBJECT;
            }
            case 4: {
                return NODE;
            }
            case 5: {
                return SERVICE;
            }
            case 6: {
                return "CA1";
            }
            case 7: {
                return "CA2";
            }
            case 8: {
                return "CA3";
            }
            case 9: {
                return "CA4";
            }
            case 10: {
                return "CA5";
            }
            case 11: {
                return "CA6";
            }
            case 12: {
                return "CA7";
            }
            case 13: {
                return "CA8";
            }
            case 14: {
                return "CA9";
            }
            case 15: {
                return "CA10";
            }
            case 16: {
                return "CA11";
            }
            case 17: {
                return "CA12";
            }
            case 18: {
                return "CA13";
            }
            case 19: {
                return "CA14";
            }
            case 20: {
                return "CA15";
            }
            case 21: {
                return NODEGROUP;
            }
            case 22: {
                return SOURCE;
            }
            case 23: {
                return TEXT;
            }
            case 24: {
                return SEVERITY;
            }
            case 25: {
                return KEY;
            }
            case 26: {
                return AGENTID;
            }
            case 27: {
                return AGENTHOST;
            }
            case 28: {
                return CA;
            }
            case 34: {
                return SLAVE_SERVER;
            }
        }
        return null;
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.setProperty(FILTER_NUMBER, "" + this.m_number);
        p.setProperty(NAME, this.m_name);
        p.setProperty(DESCR, this.m_description);
        p.setProperty(ATTRIBUTE, ForwardFilter.getAttributeName(this.m_attribute));
        p.setProperty(PATTERN, this.m_pattern.getOvPattern());
        return p;
    }

    public void putProperties(Properties p) {
        this.m_name = p.getProperty(NAME);
        this.m_description = p.getProperty(DESCR);
        String attribute = p.getProperty(ATTRIBUTE);
        if (attribute == null) {
            throw new RuntimeException("Required attribute ATTRIBUTE not found");
        }
        this.m_attribute = ForwardFilter.getAttributeNumber(attribute);
        if (this.m_attribute == 0) {
            throw new RuntimeException("Value of ATTRIBUTE not supported. Value=" + attribute);
        }
        try {
            String pattern = p.getProperty(PATTERN);
            this.m_pattern = PatternB.getPattern(pattern);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("PATTERN is invalid for the ForwardFilter " + this.m_name);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ForwardFilter)) {
            return false;
        }
        return this.m_number.intValue() == ((ForwardFilter)obj).m_number.intValue();
    }

    public int hashCode() {
        return this.m_number;
    }

    public boolean checkEvent(SEvent se) {
        return this.checkEventR(se).isMatch();
    }

    public PatternMatchResult checkEventR(SEvent se) {
        PatternMatchResult isMatched = PatternMatchResult.FALSE;
        block0 : switch (this.m_attribute) {
            case 1: {
                isMatched = this.check(se.getApplication());
                break;
            }
            case 2: {
                isMatched = this.check(se.getGroup());
                break;
            }
            case 3: {
                isMatched = this.check(se.getObject());
                break;
            }
            case 4: {
                isMatched = this.check(se.getNode());
                break;
            }
            case 5: {
                isMatched = this.check(se.getService());
                break;
            }
            case 22: {
                isMatched = this.check(se.getSource());
                break;
            }
            case 23: {
                isMatched = this.check(se.getText());
                break;
            }
            case 24: {
                isMatched = this.check(se.getSeverity());
                break;
            }
            case 25: {
                isMatched = this.check(se.getKeyConfigured());
                break;
            }
            case 27: {
                isMatched = this.check(se.getAgentNode());
                break;
            }
            default: {
                if (!(se instanceof SEventFwd)) break;
                SEventFwd sef = (SEventFwd)se;
                switch (this.m_attribute) {
                    case 6: {
                        isMatched = this.check(sef.getCA1());
                        break block0;
                    }
                    case 7: {
                        isMatched = this.check(sef.getCA2());
                        break block0;
                    }
                    case 8: {
                        isMatched = this.check(sef.getCA3());
                        break block0;
                    }
                    case 9: {
                        isMatched = this.check(sef.getCA4());
                        break block0;
                    }
                    case 10: {
                        isMatched = this.check(sef.getCA5());
                        break block0;
                    }
                    case 11: {
                        isMatched = this.check(sef.getCA6());
                        break block0;
                    }
                    case 12: {
                        isMatched = this.check(sef.getCA7());
                        break block0;
                    }
                    case 13: {
                        isMatched = this.check(sef.getCA8());
                        break block0;
                    }
                    case 14: {
                        isMatched = this.check(sef.getCA9());
                        break block0;
                    }
                    case 15: {
                        isMatched = this.check(sef.getCA10());
                        break block0;
                    }
                    case 16: {
                        isMatched = this.check(sef.getCA11());
                        break block0;
                    }
                    case 17: {
                        isMatched = this.check(sef.getCA12());
                        break block0;
                    }
                    case 18: {
                        isMatched = this.check(sef.getCA13());
                        break block0;
                    }
                    case 19: {
                        isMatched = this.check(sef.getCA14());
                        break block0;
                    }
                    case 20: {
                        isMatched = this.check(sef.getCA15());
                        break block0;
                    }
                    case 21: {
                        isMatched = this.check(sef.getT1());
                        break block0;
                    }
                    case 26: {
                        isMatched = this.check(sef.getT1());
                        break block0;
                    }
                    case 28: {
                        isMatched = this.check(sef.m_CustomAttributes);
                        break block0;
                    }
                    case 34: {
                        isMatched = this.check(sef.getSrv());
                    }
                }
            }
        }
        return isMatched;
    }

    public String toString() {
        return this.m_name;
    }

    public String getPatternB() {
        return this.m_pattern.getOvPattern();
    }

    @Override
    public String getID() {
        return this.m_number == null ? null : this.m_number.toString();
    }
}

