/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.exceptions.PolicyException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeMask {
    public long m_time = System.currentTimeMillis();
    List<Integer> filterYear = null;
    List<Integer> filterMonth = null;
    List<Integer> filterDay = null;
    List<Integer> filterHour = null;
    List<Integer> filterMin = null;
    List<Integer> filterSec = null;
    List<Integer> filterDOW = null;
    List<Integer> filterDOWMOD = null;
    private Pattern m_splitArray = Pattern.compile("\\s*([,-]?)\\s*(\\d+)([Ll]?)\\s*");
    private Pattern m_checkDigitsAndPunkt = Pattern.compile("[\\d\\,\\-\\ \\*L]+");
    protected String m_mask = null;
    protected long m_nextTime = -1L;

    public TimeMask(String mask, long time) throws Exception {
        this.setTime(time);
        this.setMask(mask);
    }

    public TimeMask(String mask) throws Exception {
        this(mask, System.currentTimeMillis());
    }

    public void setTime(long time) {
        this.m_time = time;
        this.m_nextTime = -1L;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public String getTimeString(long time) {
        Calendar cal = Calendar.getInstance(this.getTimeZone(), Locale.ENGLISH);
        cal.setTimeInMillis(time);
        StringBuffer sb = new StringBuffer();
        String year = new SimpleDateFormat("yyyy").format(cal.getTime());
        String day = new SimpleDateFormat("dd").format(cal.getTime());
        String mon = this.getMonth(cal.get(2) + 1);
        int dow = cal.get(7);
        dow = this.getOurDayOfWeek(dow);
        String dayOfWeek = this.getDayOfWeek(dow);
        SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss");
        String timeStr = sdf2.format(cal.getTime());
        int days2mothEnd = this.getDayNumberFromEnd(cal);
        int countofDayOfWeekWithinMonth = this.getDOWnumber(cal);
        int countofDayOfWeekWithinMonthNegative = this.getDOWnumberFromEnd(cal);
        sb.append(year).append('/').append(mon).append('/').append(day);
        sb.append(' ').append(dayOfWeek).append('(').append(countofDayOfWeekWithinMonth).append(") ");
        sb.append(timeStr);
        sb.append(" ").append(cal.getTimeZone().getID()).append(" ");
        sb.append(" D2ME:").append(days2mothEnd);
        sb.append(" WDME:").append(countofDayOfWeekWithinMonthNegative);
        return sb.toString();
    }

    public int getDayNumberFromEnd(Calendar cal) {
        int days2mothEnd = cal.get(5) - cal.getActualMaximum(5) - 1;
        return days2mothEnd;
    }

    public int getDOWnumberFromEnd(Calendar current) {
        int countofDayOfWeekWithinMonthNegative = 0;
        Calendar cal = (Calendar)current.clone();
        int month2 = cal.get(2);
        while (month2 == cal.get(2)) {
            cal.add(6, 7);
            ++countofDayOfWeekWithinMonthNegative;
        }
        return countofDayOfWeekWithinMonthNegative * -1;
    }

    public int getDOWnumber(Calendar current) {
        int countofDayOfWeekWithinMonth = 0;
        Calendar cal = (Calendar)current.clone();
        int month = cal.get(2);
        while (month == cal.get(2)) {
            cal.add(6, -7);
            ++countofDayOfWeekWithinMonth;
        }
        return countofDayOfWeekWithinMonth;
    }

    public int getOurDayOfWeek(int calendarDoW) {
        calendarDoW = calendarDoW == 1 ? 7 : --calendarDoW;
        return calendarDoW;
    }

    public int getCalendarDayOfWeek(int dow) {
        dow = dow == 7 ? 1 : ++dow;
        return dow;
    }

    public void setMask(String mask) throws Exception {
        this.m_mask = mask;
        this.init(mask);
    }

    public String getMask() {
        return this.m_mask;
    }

    public long getNextTime() throws Exception {
        if (this.m_nextTime < this.m_time) {
            long nextTime = -1L;
            if (this.filterDay == null) {
                throw new Exception("Please set mask first");
            }
            Calendar cal = Calendar.getInstance(this.getTimeZone(), Locale.ENGLISH);
            cal.setTimeInMillis(this.m_time);
            cal.set(14, 0);
            cal.set(13, 0);
            this.rollUp(cal, 13, 60, this.filterSec);
            this.rollUp(cal, 12, 60, this.filterMin);
            this.rollUp(cal, 11, 24, this.filterHour);
            this.rollUpYear(this.filterYear, cal);
            this.rollUpMonth(this.filterMonth, cal);
            this.rollUpDays(this.filterDay, this.filterDOW, this.filterDOWMOD, cal);
            if (!this.filterMonth.isEmpty() && !this.filterMonth.contains(cal.get(2) + 1)) {
                throw new Exception("expired Interval");
            }
            this.m_nextTime = nextTime = cal.getTimeInMillis();
        }
        return this.m_nextTime;
    }

    public long getNextTimeFromNow() throws Exception {
        this.setTime(System.currentTimeMillis());
        return this.getNextTime();
    }

    private void init(String pattern) throws PolicyException, Exception {
        this.m_nextTime = -1L;
        PatternB p = PatternB.getPattern("<^[\\d\\,\\-\\*\\ ]+^.y>/<^[\\w\\d\\,\\-\\*\\ L]+^.m>/<^[\\d\\,\\-\\*\\ L]+^.d><_><^[\\w\\d\\,\\-\\*\\ L]+^.dow>(<^[\\d\\,\\-\\*\\ L]+^.dowMod>)<_><^[\\d\\,\\-\\*\\ L]+^.hh>:<^[\\d\\,\\-\\*\\ L]+^.mm>:<^[\\d\\,\\-\\*\\ L]+^.ss>");
        PatternMatchResult matchesR = p.matchesR(pattern);
        if (matchesR.isMatch()) {
            this.filterYear = this.getArray(matchesR.getValue("y"), 1);
            String monthes = this.replaceMonths(matchesR.getValue("m"));
            if (!this.m_checkDigitsAndPunkt.matcher(monthes).matches()) {
                throw new Exception("Invalid month pattern: " + monthes);
            }
            this.filterMonth = this.getArray(monthes, 2);
            this.filterDay = this.getArray(matchesR.getValue("d"), 5);
            this.filterHour = this.getArray(matchesR.getValue("hh"), 11);
            this.filterMin = this.getArray(matchesR.getValue("mm"), 12);
            this.filterSec = this.getArray(matchesR.getValue("ss"), 13);
            String days = this.replaceDaysOfWeek(matchesR.getValue("dow"));
            if (!this.m_checkDigitsAndPunkt.matcher(days).matches()) {
                throw new Exception("Invalid month pattern");
            }
            this.filterDOW = this.getArray(days, 7);
            this.filterDOWMOD = this.getArray(matchesR.getValue("dowMod"), 8);
            if (this.filterYear.size() == 0 && this.filterMonth.size() == 0 && this.filterDay.size() == 0 && this.filterHour.size() == 0 && this.filterMin.size() == 0 && this.filterDOW.size() == 0 && this.filterDOWMOD.size() == 0) {
                throw new Exception("Incorrect configuration: " + pattern);
            }
        } else {
            throw new Exception("Incorrect configuration: " + pattern);
        }
    }

    public void rollUpYear(List<Integer> filterYear, Calendar cal) throws Exception {
        if (filterYear.size() != 0) {
            boolean foundNext = false;
            int currentValue = cal.get(1);
            for (int y : filterYear) {
                if (y < currentValue) continue;
                cal.set(1, y);
                foundNext = true;
                break;
            }
            if (!foundNext) {
                throw new Exception("expired Interval: year");
            }
        }
    }

    public void rollUpMonth(List<Integer> filterMonth, Calendar cal) throws Exception {
        if (filterMonth.size() != 0) {
            boolean foundNext = false;
            int currentValue = cal.get(2) + 1;
            for (int m : filterMonth) {
                if (m < currentValue) continue;
                cal.set(2, m - 1);
                foundNext = true;
                break;
            }
            if (!foundNext) {
                if (Calendar.getInstance(this.getTimeZone(), Locale.ENGLISH).get(1) + 5 > cal.get(1)) {
                    cal.add(1, 1);
                    cal.set(2, 0);
                    this.rollUpMonth(filterMonth, cal);
                } else {
                    throw new Exception("Scheduling interval is too far ahead!");
                }
            }
        }
    }

    public void rollUpDays(List<Integer> filterDay, List<Integer> filterDOW, List<Integer> filterDOWMOD, Calendar cal) throws Exception {
        if (filterDay.size() == 0) {
            Calendar cal2 = (Calendar)cal.clone();
            int maxIteration = 366;
            boolean resetHMS = false;
            while (maxIteration > 0) {
                int dowNumberFromEnd;
                int dowNumber;
                int ourDOW = this.getOurDayOfWeek(cal2.get(7));
                if (this.checkDayOfWeek(ourDOW, dowNumber = this.getDOWnumber(cal2), dowNumberFromEnd = this.getDOWnumberFromEnd(cal2), filterDOW, filterDOWMOD)) {
                    cal.setTimeInMillis(cal2.getTimeInMillis());
                    break;
                }
                cal2.add(6, 1);
                if (!resetHMS) {
                    resetHMS = true;
                }
                --maxIteration;
            }
            if (maxIteration == 0) {
                throw new Exception("incorrect mask");
            }
        } else {
            int maxIteration = 366;
            while (maxIteration > 0) {
                int dayNumber = cal.get(5);
                int dayNumberFromEnd = this.getDayNumberFromEnd(cal);
                if (filterDay.contains(dayNumber) || filterDay.contains(dayNumberFromEnd)) break;
                cal.add(6, 1);
                --maxIteration;
            }
            if (maxIteration == 0) {
                throw new Exception("incorrect mask");
            }
        }
    }

    public void rollUp(Calendar cal, int field, int maxItr, List<Integer> filter) throws Exception {
        if (filter.size() != 0) {
            int maxIteration = maxItr;
            boolean zeroLower = false;
            while (maxIteration > 0) {
                if (filter.contains(cal.get(field))) break;
                cal.add(field, 1);
                if (!zeroLower) {
                    int i = field + 1;
                    while (i <= 14) {
                        ++i;
                    }
                    zeroLower = true;
                }
                --maxIteration;
            }
            if (maxIteration == 0) {
                throw new Exception("incorrect mask");
            }
        }
    }

    public boolean checkDayOfWeek(int dow, int dowNumber, int dowNumberFromEnd, List<Integer> dows, List<Integer> dowMods) {
        return !(dows.size() != 0 && !dows.contains(dow) || dowMods.size() != 0 && !dowMods.contains(dowNumber) && !dowMods.contains(dowNumberFromEnd));
    }

    public int getMaxDOWNumberInMonth(int ourDOW, Calendar current) {
        int max = 0;
        Calendar cl = (Calendar)current.clone();
        cl.set(5, 1);
        while (cl.get(7) != this.getCalendarDayOfWeek(ourDOW)) {
            cl.add(6, 1);
        }
        while (cl.get(2) == current.get(2)) {
            cl.add(6, 7);
            ++max;
        }
        return max;
    }

    public List<Integer> getArray(String text, int type) throws Exception {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (text == null || text.length() == 0) {
            return list;
        }
        Matcher m = this.m_splitArray.matcher(text);
        while (m.find()) {
            String nchar;
            int digit = Integer.parseInt(m.group(2));
            switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    if (digit >= 1 && digit <= 12) break;
                    throw new Exception("Invalid Month: " + digit);
                }
                case 5: {
                    if (digit >= 1 && digit <= 31) break;
                    throw new Exception("Invalid Day: " + digit);
                }
                case 10: {
                    if (digit >= 0 && digit <= 23) break;
                    throw new Exception("Invalid Hour: " + digit);
                }
                case 12: 
                case 13: {
                    if (digit >= 0 && digit <= 59) break;
                    throw new Exception("Invalid Minute: " + digit);
                }
                case 7: {
                    if (digit >= 1 && digit <= 7) break;
                    throw new Exception("Invalid Day of Week: " + digit);
                }
                case 8: {
                    if (digit >= 1 && digit <= 5) break;
                    throw new Exception("Invalid Reverse modificator: " + digit);
                }
            }
            boolean isReverse = false;
            if ("L".equalsIgnoreCase(m.group(3))) {
                switch (type) {
                    case 1: 
                    case 2: 
                    case 7: 
                    case 10: 
                    case 12: 
                    case 13: {
                        throw new Exception("Invalid pattern");
                    }
                }
                digit *= -1;
                isReverse = true;
            }
            if ((nchar = m.group(1)) == null || "".equals(nchar)) {
                list.add(digit);
                continue;
            }
            if ("-".equals(nchar)) {
                if (isReverse) {
                    throw new Exception("Invalid syntax near: " + m.group(0));
                }
                int lastD = (Integer)list.get(list.size() - 1);
                int i = lastD + 1;
                while (i <= digit) {
                    list.add(i);
                    ++i;
                }
                continue;
            }
            if (!",".equals(nchar)) continue;
            list.add(digit);
        }
        return list;
    }

    public String replaceMonths(String text) {
        text = text.replaceAll("(?i)jan", "1");
        text = text.replaceAll("(?i)feb", "2");
        text = text.replaceAll("(?i)mar", "3");
        text = text.replaceAll("(?i)apr", "4");
        text = text.replaceAll("(?i)may", "5");
        text = text.replaceAll("(?i)jun", "6");
        text = text.replaceAll("(?i)jul", "7");
        text = text.replaceAll("(?i)aug", "8");
        text = text.replaceAll("(?i)sep", "9");
        text = text.replaceAll("(?i)oct", "10");
        text = text.replaceAll("(?i)nov", "11");
        text = text.replaceAll("(?i)dec", "12");
        return text;
    }

    public String getMonth(int number) {
        switch (number) {
            case 1: {
                return "JAN";
            }
            case 2: {
                return "FEB";
            }
            case 3: {
                return "MAR";
            }
            case 4: {
                return "APR";
            }
            case 5: {
                return "MAY";
            }
            case 6: {
                return "JUN";
            }
            case 7: {
                return "JUL";
            }
            case 8: {
                return "AUG";
            }
            case 9: {
                return "SEP";
            }
            case 10: {
                return "OCT";
            }
            case 11: {
                return "NOV";
            }
            case 12: {
                return "DEC";
            }
        }
        return "*";
    }

    public String replaceDaysOfWeek(String text) {
        text = text.replaceAll("(?i)mon", "1");
        text = text.replaceAll("(?i)tue", "2");
        text = text.replaceAll("(?i)wed", "3");
        text = text.replaceAll("(?i)thu", "4");
        text = text.replaceAll("(?i)fri", "5");
        text = text.replaceAll("(?i)sat", "6");
        text = text.replaceAll("(?i)sun", "7");
        return text;
    }

    public String getDayOfWeek(int number) {
        switch (number) {
            case 1: {
                return "MON";
            }
            case 2: {
                return "TUE";
            }
            case 3: {
                return "WED";
            }
            case 4: {
                return "THU";
            }
            case 5: {
                return "FRI";
            }
            case 6: {
                return "SAT";
            }
            case 7: {
                return "SUN";
            }
        }
        return "*";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeMask)) {
            return false;
        }
        TimeMask t2 = (TimeMask)obj;
        return this.m_mask == t2.m_mask || this.m_mask != null && this.m_mask.equals(t2.m_mask);
    }

    public int hashCode() {
        return this.m_mask == null ? 0 : this.m_mask.hashCode();
    }
}

