/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.io;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUConcurrentCache<K, V> {
    private final Map<K, V> cache;

    public LRUConcurrentCache(final int maxEntries) {
        this.cache = new LinkedHashMap<K, V>(maxEntries, 0.75f, true){
            private static final long serialVersionUID = -1236481390177598762L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxEntries;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        Map<K, V> map = this.cache;
        synchronized (map) {
            this.cache.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Map<K, V> map = this.cache;
        synchronized (map) {
            return this.cache.get(key);
        }
    }

    public int size() {
        return this.cache.size();
    }
}

