/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.jobs;

import com.blixx.shared.jobs.UnsupportedTypeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractAttribute {
    public static final String ATTRIBUTE = "attribute";
    protected String m_name;
    protected String m_type;
    protected String m_label;
    protected String m_description;
    protected boolean m_editable = true;
    protected boolean m_enabled = true;
    protected int m_width = -1;
    protected int m_height = -1;
    protected Object m_value = null;
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_PASSWORD = "password";
    public static final String TYPE_LIST = "list";
    public static final String TYPE_SELECT = "select";
    public static final String TYPE_CHECK = "check";
    public static final String TYPE_MAP = "map";
    public static final String ENABLED = "enabled";
    public static final String DESCRIPTION = "description";
    public static final String EDITABLE = "editable";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String LABEL = "label";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";

    protected AbstractAttribute(String name, String type, Object value) {
        this.m_name = name;
        this.m_type = type;
        this.m_value = value;
        this.m_label = this.m_name;
    }

    protected AbstractAttribute(String name, String type, Object value, String label) {
        this(name, type, value);
        this.m_label = label;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public abstract void addValueToXML(Node var1);

    public abstract Object getValue();

    public abstract void setValue(Object var1) throws UnsupportedTypeException;

    public void parse(Element parent) {
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Element) {
                if (NAME.equalsIgnoreCase(n.getNodeName())) {
                    this.m_name = n.getTextContent();
                } else if (LABEL.equalsIgnoreCase(n.getNodeName())) {
                    this.m_label = n.getTextContent();
                } else if (DESCRIPTION.equalsIgnoreCase(n.getNodeName())) {
                    this.m_description = n.getTextContent();
                } else if (EDITABLE.equalsIgnoreCase(n.getNodeName())) {
                    try {
                        this.m_editable = Boolean.parseBoolean(n.getTextContent());
                    }
                    catch (Throwable throwable) {}
                } else if (ENABLED.equalsIgnoreCase(n.getNodeName())) {
                    try {
                        this.m_enabled = Boolean.parseBoolean(n.getTextContent());
                    }
                    catch (Throwable throwable) {}
                } else if (WIDTH.equalsIgnoreCase(n.getNodeName())) {
                    try {
                        this.m_width = Integer.parseInt(n.getTextContent());
                    }
                    catch (Throwable throwable) {}
                } else if (HEIGHT.equalsIgnoreCase(n.getNodeName())) {
                    try {
                        this.m_height = Integer.parseInt(n.getTextContent());
                    }
                    catch (Throwable throwable) {}
                }
            }
            ++i;
        }
    }

    public void addToXML(Node parent) {
        Node node = AbstractAttribute.creatAttributeNode(parent, ATTRIBUTE);
        AbstractAttribute.setAttr(node, NAME, this.getName());
        AbstractAttribute.setAttr(node, TYPE, this.getType());
        AbstractAttribute.setAttr(node, LABEL, this.getLabel());
        AbstractAttribute.setAttr(node, DESCRIPTION, this.getDescription());
        AbstractAttribute.setAttr(node, ENABLED, "" + this.isEnabled());
        AbstractAttribute.setAttr(node, EDITABLE, "" + this.isEditable());
        if (this.m_width > 0) {
            AbstractAttribute.setAttr(node, WIDTH, "" + this.getWidth());
        }
        if (this.m_height > 0) {
            AbstractAttribute.setAttr(node, HEIGHT, "" + this.getHeight());
        }
        this.addValueToXML(node);
    }

    public static Node creatAttributeNode(Node parent, String param) {
        Element el = parent.getOwnerDocument().createElement(param);
        parent.appendChild(el);
        return el;
    }

    public static Element setAttr(Node parameter, String elAttribute, String value) {
        Element pel = parameter.getOwnerDocument().createElement(elAttribute);
        String normalizedValue = value == null ? null : value.replaceAll("[^\t\r\n -\ud7ff\ue000-\ufffd\u10000-\u10ffFF]", "");
        pel.setTextContent(normalizedValue);
        parameter.appendChild(pel);
        return pel;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }
}

