/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.jobs;

import com.blixx.shared.XMLFactory;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.CheckAttribute;
import com.blixx.shared.jobs.ListAttribute;
import com.blixx.shared.jobs.MapAttribute;
import com.blixx.shared.jobs.PasswordAttribute;
import com.blixx.shared.jobs.SelectAttribute;
import com.blixx.shared.jobs.TextAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Group {
    public String m_name = null;
    public Map<String, Group> m_mapGroups = new LinkedHashMap<String, Group>();
    public Map<String, AbstractAttribute> m_mapAttributes = new LinkedHashMap<String, AbstractAttribute>();

    public Group() {
    }

    public Group(String name) {
        this.m_name = name;
        if (this.m_name != null) {
            this.m_name = this.m_name.toUpperCase();
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void addAttribute(AbstractAttribute att) {
        this.m_mapAttributes.put(att.getName(), att);
    }

    public AbstractAttribute removeAttribute(String name) {
        return this.m_mapAttributes.remove(name);
    }

    public Group removeGroup(String name) {
        return this.m_mapGroups.remove(name);
    }

    public Group addGroup(Group group) {
        this.m_mapGroups.put(group.getName(), group);
        return group;
    }

    public Map<String, AbstractAttribute> getAttributes() {
        return this.m_mapAttributes;
    }

    public Map<String, Group> getGroups() {
        return this.m_mapGroups;
    }

    public Group getGroup(String name) {
        if (name != null) {
            name = name.toUpperCase();
        }
        return this.m_mapGroups.get(name);
    }

    public AbstractAttribute getAttribute(String name) {
        return this.m_mapAttributes.get(name);
    }

    public AbstractAttribute getAttributeByPath(String[] path) {
        List<String> lpath = Arrays.asList(path);
        return this.getAttributeByPath(lpath);
    }

    public AbstractAttribute getAttributeByPath(List<String> path) {
        AbstractAttribute res = null;
        res = path.size() == 1 ? this.getAttribute(path.get(0)) : this.getGroup(path.get(0)).getAttributeByPath(path.subList(1, path.size()));
        return res;
    }

    public void addToXML(Node parent) {
        Node thisNode = Group.createGroup(parent, this.getName());
        for (Map.Entry<String, AbstractAttribute> entry : this.m_mapAttributes.entrySet()) {
            entry.getValue().addToXML(thisNode);
        }
        for (Map.Entry<String, Group> entry : this.m_mapGroups.entrySet()) {
            entry.getValue().addToXML(thisNode);
        }
    }

    public void parse(Element xmlNode) {
        this.m_name = xmlNode.getNodeName();
        if (this.m_name != null) {
            this.m_name = this.m_name.toUpperCase();
        }
        NodeList nl = xmlNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Element) {
                if (!"attribute".equals(n.getNodeName())) {
                    Group tmp = new Group();
                    tmp.parse((Element)n);
                    this.addGroup(tmp);
                } else {
                    this.parseAttribute((Element)n);
                }
            }
            ++i;
        }
    }

    private void parseAttribute(Element xmlNode) {
        Element el = xmlNode;
        NodeList nl = el.getElementsByTagName("type");
        if (nl.getLength() == 1) {
            Node type = nl.item(0);
            String typeStr = XMLFactory.unescape(type.getTextContent().trim());
            if ("text".equalsIgnoreCase(typeStr)) {
                TextAttribute ta = new TextAttribute(null, null, null);
                ta.parse(el);
                this.addAttribute(ta);
            } else if ("list".equalsIgnoreCase(typeStr)) {
                ListAttribute la = new ListAttribute(null, null, null);
                la.parse(el);
                this.addAttribute(la);
            } else if ("map".equalsIgnoreCase(typeStr)) {
                MapAttribute ma = new MapAttribute(null, null, null);
                ma.parse(el);
                this.addAttribute(ma);
            } else if ("check".equalsIgnoreCase(typeStr)) {
                CheckAttribute ma = new CheckAttribute(null, null, null);
                ma.parse(el);
                this.addAttribute(ma);
            } else if ("select".equalsIgnoreCase(typeStr)) {
                SelectAttribute ma = new SelectAttribute(null, null, null, null);
                ma.parse(el);
                this.addAttribute(ma);
            } else if ("password".equalsIgnoreCase(typeStr)) {
                PasswordAttribute ta = new PasswordAttribute(null, null, null);
                ta.parse(el);
                this.addAttribute(ta);
            }
        }
    }

    public static Node createGroups(Node top, List<String> path) {
        String name = path.get(0);
        NodeList nl = top.getChildNodes();
        Node paramEL = null;
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Element && name.equalsIgnoreCase(n.getNodeName())) {
                paramEL = n;
            }
            ++i;
        }
        if (paramEL == null) {
            Element el = top.getOwnerDocument().createElement(name);
            top.appendChild(el);
            paramEL = el;
        }
        if (path.size() > 1) {
            paramEL = Group.createGroups(paramEL, path.subList(1, path.size()));
        }
        return paramEL;
    }

    public static Node createGroup(Node top, String name) {
        NodeList nl = top.getChildNodes();
        Node paramEL = null;
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Element && name.equalsIgnoreCase(n.getNodeName())) {
                paramEL = n;
            }
            ++i;
        }
        if (paramEL == null) {
            Document ownerDocument = top.getOwnerDocument();
            if (top instanceof Document) {
                ownerDocument = (Document)top;
            }
            Element el = ownerDocument.createElement(name);
            top.appendChild(el);
            paramEL = el;
        }
        return paramEL;
    }
}

