/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.jobs;

import com.blixx.shared.XMLFactory;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.UnsupportedTypeException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapAttribute
extends AbstractAttribute {
    public static final String KEY_EDITABLE = "editable.key";
    public static final String VALUE_EDITABLE = "editable.value";
    public static final String KEY_VALIDATION = null;
    public static final String VALUE_VALIDATION = null;
    public boolean m_keyEditable = true;
    public boolean m_valueEditable = true;

    public MapAttribute(String name, Map<String, String> value, String label) {
        super(name, "map", value, label);
        if (value == null) {
            this.m_value = new LinkedHashMap();
        }
    }

    @Override
    public void addValueToXML(Node parent) {
        MapAttribute.addMap(parent, this);
    }

    @Override
    public Map<String, String> getValue() {
        return (Map)this.m_value;
    }

    @Override
    public void setValue(Object value) throws UnsupportedTypeException {
        if (!(value instanceof Map)) {
            throw new UnsupportedTypeException("Only Map is supported for the MapAttribute");
        }
        this.m_value = (Map)value;
    }

    public boolean isKeyEditable() {
        return this.m_keyEditable;
    }

    public void setKeyEditable(boolean keyEditable) {
        this.m_keyEditable = keyEditable;
    }

    public boolean isValueEditable() {
        return this.m_valueEditable;
    }

    public void setValueEditable(boolean valueEditable) {
        this.m_valueEditable = valueEditable;
    }

    @Override
    public void parse(Element parent) {
        super.parse(parent);
        NodeList nl0 = parent.getChildNodes();
        int i = 0;
        while (i < nl0.getLength()) {
            Node n = nl0.item(i);
            if (n instanceof Element) {
                if (KEY_EDITABLE.equalsIgnoreCase(n.getNodeName())) {
                    try {
                        this.m_keyEditable = Boolean.parseBoolean(n.getTextContent());
                    }
                    catch (Throwable throwable) {}
                } else if (VALUE_EDITABLE.equalsIgnoreCase(n.getNodeName())) {
                    try {
                        this.m_valueEditable = Boolean.parseBoolean(n.getTextContent());
                    }
                    catch (Throwable throwable) {}
                }
            }
            ++i;
        }
        NodeList nl = parent.getElementsByTagName("value");
        if (nl.getLength() == 1) {
            Node value = nl.item(0);
            NodeList rows = value.getChildNodes();
            int i2 = 0;
            while (i2 < rows.getLength()) {
                Node row = rows.item(i2);
                if (row instanceof Element) {
                    String key = null;
                    String val = null;
                    Element elrow = (Element)row;
                    NodeList temp = elrow.getElementsByTagName("key");
                    if (temp.getLength() == 1) {
                        key = XMLFactory.unescape(temp.item(0).getTextContent());
                    }
                    if ((temp = elrow.getElementsByTagName("val")).getLength() == 1) {
                        val = XMLFactory.unescape(temp.item(0).getTextContent());
                    }
                    if (key != null) {
                        this.getValue().put(key, val);
                    }
                }
                ++i2;
            }
        }
    }

    public static void addMap(Node parent, MapAttribute ma) {
        Object values = ma.getValue();
        MapAttribute.setAttr(parent, KEY_EDITABLE, "" + ma.m_keyEditable);
        MapAttribute.setAttr(parent, VALUE_EDITABLE, "" + ma.m_valueEditable);
        Element eList = parent.getOwnerDocument().createElement("value");
        parent.appendChild(eList);
        Iterator it = values.entrySet().iterator();
        while (it.hasNext()) {
            Element row = parent.getOwnerDocument().createElement("row");
            eList.appendChild(row);
            Map.Entry val = it.next();
            Element eKey = row.getOwnerDocument().createElement("key");
            eKey.setTextContent((String)val.getKey());
            row.appendChild(eKey);
            Element eValue = row.getOwnerDocument().createElement("val");
            String v = (String)val.getValue();
            if (v != null) {
                eValue.setTextContent(v);
            }
            row.appendChild(eValue);
        }
    }
}

