/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.jobs;

import com.blixx.shared.XMLFactory;
import com.blixx.shared.jobs.AbstractAttribute;
import com.blixx.shared.jobs.UnsupportedTypeException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectAttribute
extends AbstractAttribute {
    public static String VLIST = "vlist";
    public List<String> m_list = null;

    public SelectAttribute(String name, List<String> values, String selected, String label) {
        super(name, "select", selected, label);
        this.m_list = values;
        if (this.m_list == null) {
            this.m_list = new ArrayList<String>();
        }
    }

    @Override
    public void addValueToXML(Node parent) {
        SelectAttribute.addList(parent, this.m_list);
        SelectAttribute.setAttr(parent, "value", (String)this.m_value);
    }

    @Override
    public void parse(Element parent) {
        Node value;
        super.parse(parent);
        NodeList nl = parent.getElementsByTagName("value");
        if (nl.getLength() == 1) {
            value = nl.item(0);
            this.m_value = XMLFactory.unescape(value.getTextContent());
        }
        if ((nl = parent.getElementsByTagName(VLIST)).getLength() == 1) {
            value = nl.item(0);
            NodeList items = value.getChildNodes();
            int i = 0;
            while (i < items.getLength()) {
                Node ii = items.item(i);
                if (ii instanceof Element) {
                    this.addItem(XMLFactory.unescape(ii.getTextContent()));
                }
                ++i;
            }
        }
    }

    public void addItem(String item) {
        this.getList().add(item);
    }

    @Override
    public String getValue() {
        return (String)this.m_value;
    }

    @Override
    public void setValue(Object value) throws UnsupportedTypeException {
        if (!(value instanceof String)) {
            throw new UnsupportedTypeException("Only String is supported for the SelectAttribute");
        }
        if (this.m_list == null || !this.m_list.contains(value)) {
            throw new UnsupportedTypeException("unknown selection value");
        }
        this.m_value = (String)value;
    }

    public void setList(List<String> values) {
        this.m_list = values;
    }

    public List<String> getList() {
        return this.m_list;
    }

    public static void addList(Node parent, List<String> values) {
        Element eList = parent.getOwnerDocument().createElement(VLIST);
        parent.appendChild(eList);
        int i = 0;
        while (i < values.size()) {
            String value = values.get(i);
            Element eValue = parent.getOwnerDocument().createElement("item");
            if (value != null) {
                eValue.setTextContent(value);
            }
            eList.appendChild(eValue);
            ++i;
        }
    }
}

