/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.jobs;

import java.io.File;

public class SftpHostConfig {
    public static final String WRONG_CONFIG = "WRONG_CONFIG";
    public static final String USER_PASS_CONNECTION = "USER_PASS";
    public static final String PUBLIC_KEY_CONNECTION = "PUBLIC_KEY";
    private String host = null;
    private int port = 22;
    private String user = null;
    private String pass = null;
    private String dir = ".";
    private String sftpPrivateKey = null;
    private String sftpPublicKey = null;
    private String sftpPrivateKeyPass = null;
    private String errorMessage = "";

    public SftpHostConfig() {
    }

    public SftpHostConfig(String host, int port, String user, String pass, String dir) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.pass = pass;
        this.dir = dir;
    }

    public String getConnectionType() {
        if (this.host == null || this.user == null || this.dir == null) {
            this.errorMessage = "Missing SFTP parameters.";
            return WRONG_CONFIG;
        }
        if (this.host.length() == 0 || this.user.length() == 0 || this.dir.length() == 0) {
            this.errorMessage = "Missing SFTP parameters.";
            return WRONG_CONFIG;
        }
        if (!(this.host == null || this.user == null || this.pass == null || this.host.isEmpty() || this.user.isEmpty() || this.pass.isEmpty())) {
            return USER_PASS_CONNECTION;
        }
        if (this.sftpPrivateKey != null && this.sftpPrivateKey.length() > 0) {
            boolean pubKeyExist = false;
            boolean keyExist = this.doesFileExist(this.sftpPrivateKey);
            if (keyExist) {
                if (this.sftpPublicKey == null || this.sftpPublicKey.length() == 0) {
                    this.sftpPublicKey = String.valueOf(this.sftpPrivateKey) + ".pub";
                }
                if (pubKeyExist = this.doesFileExist(this.sftpPublicKey)) {
                    return PUBLIC_KEY_CONNECTION;
                }
                this.errorMessage = "SFTP Public key " + this.sftpPublicKey + " does not exist!";
                return WRONG_CONFIG;
            }
            this.errorMessage = "SFTP key " + this.sftpPrivateKey + " does not exist!";
            return WRONG_CONFIG;
        }
        this.errorMessage = "Missing SFTP Private/Public Keys in XML File. ";
        return WRONG_CONFIG;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String sftpHost) {
        this.host = sftpHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int sftpPort) {
        this.port = sftpPort;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String sftpUser) {
        this.user = sftpUser;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String sftpPass) {
        this.pass = sftpPass;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String sftpDir) {
        this.dir = sftpDir;
    }

    public String getSftpPrivateKey() {
        return this.sftpPrivateKey;
    }

    public void setSftpPrivateKey(String sftpPrivateKey) {
        this.sftpPrivateKey = sftpPrivateKey;
    }

    public String getSftpPublicKey() {
        return this.sftpPublicKey;
    }

    public void setSftpPublicKey(String sftpPublicKey) {
        this.sftpPublicKey = sftpPublicKey;
    }

    public String getSftpPrivateKeyPass() {
        return this.sftpPrivateKeyPass;
    }

    public void setSftpPrivateKeyPass(String sftpPrivateKeyPass) {
        this.sftpPrivateKeyPass = sftpPrivateKeyPass;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private boolean doesFileExist(String name) {
        boolean exist = false;
        File file = new File(name);
        if (file != null && file.exists()) {
            exist = true;
        }
        return exist;
    }

    public String toString() {
        return "Config Host : " + this.host + " port : " + this.port + " user " + this.user + " target directory " + this.dir;
    }
}

