/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.os;

import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.shared.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemUtils {
    public static final int INIT_PROBLEM = -1;
    public static final int OTHER = 0;
    public static final int WINDOWS = 1;
    public static final int UNIX = 2;
    public static int OS;
    public static int UNIX_WHO;
    public static final int UNIX_LINUX = 1;
    public static final int UNIX_HPUX = 2;
    public static final int UNIX_SUN = 3;
    public static final int UNIX_MAC = 4;
    public static final int UNIX_FREBSD = 5;
    public static final int UNIX_OS400 = 6;
    public static String osNameStr;
    public static String osNameFullStr;
    public static ArrayList<String> knownLinuxVersionFiles;

    static {
        block27: {
            UNIX_WHO = 0;
            osNameStr = "Other";
            osNameFullStr = "";
            knownLinuxVersionFiles = new ArrayList(0);
            try {
                String osName;
                OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
                String osVersionFromBean = osBean.getVersion();
                osNameStr = osName = System.getProperty("os.name");
                if (osName == null) {
                    osNameStr = "Other";
                    break block27;
                }
                if ((osName = osName.toLowerCase()).indexOf("windows") != -1) {
                    OS = 1;
                    break block27;
                }
                if (osName.indexOf("linux") != -1 || osName.indexOf("sun os") != -1 || osName.indexOf("sunos") != -1 || osName.indexOf("solaris") != -1 || osName.indexOf("mpe/ix") != -1 || osName.indexOf("hp-ux") != -1 || osName.indexOf("aix") != -1 || osName.indexOf("freebsd") != -1 || osName.indexOf("irix") != -1 || osName.indexOf("digital unix") != -1 || osName.indexOf("unix") != -1 || osName.indexOf("400") != -1 || osName.indexOf("mac os x") != -1) {
                    OS = 2;
                    if (osName.indexOf("linux") != -1) {
                        UNIX_WHO = 1;
                        try {
                            knownLinuxVersionFiles.ensureCapacity(20);
                            knownLinuxVersionFiles.add("debian_version");
                            knownLinuxVersionFiles.add("gentoo-release");
                            knownLinuxVersionFiles.add("fedora-release");
                            knownLinuxVersionFiles.add("mandriva-release");
                            knownLinuxVersionFiles.add("mandrake-release");
                            knownLinuxVersionFiles.add("meego-release");
                            knownLinuxVersionFiles.add("arch-release");
                            knownLinuxVersionFiles.add("oracle-release");
                            knownLinuxVersionFiles.add("enterprise-release");
                            knownLinuxVersionFiles.add("ovs-release");
                            knownLinuxVersionFiles.add("vmware-release");
                            knownLinuxVersionFiles.add("redhat-release");
                            knownLinuxVersionFiles.add("SuSE-release");
                            knownLinuxVersionFiles.add("bluewhite64-version");
                            knownLinuxVersionFiles.add("slamd64-version");
                            knownLinuxVersionFiles.add("slackware-version");
                            knownLinuxVersionFiles.add("alpine-release");
                            knownLinuxVersionFiles.add("system-release");
                            knownLinuxVersionFiles.add("centos-release");
                            knownLinuxVersionFiles.add("issue.net");
                            File etc = new File("/etc");
                            if (!etc.isDirectory()) break block27;
                            for (String fname : knownLinuxVersionFiles) {
                                File pr = new File(etc, fname);
                                if (!pr.exists()) continue;
                                String release_or_version = FileUtils.readFile(pr);
                                RTLogger.print(1, release_or_version);
                                if (fname.equals("issue.net") && release_or_version.contains("Linux")) continue;
                                if (fname.endsWith("version")) {
                                    Pattern verT = Pattern.compile(".*(\\d+\\.\\d+)\\.\\d+\\s*");
                                    Matcher mt = verT.matcher(release_or_version);
                                    if (mt.matches()) {
                                        release_or_version = mt.group(1);
                                    }
                                    osNameFullStr = String.valueOf(fname.substring(0, 1).toUpperCase()) + fname.substring(1, fname.length() - 8) + ' ' + release_or_version.replace("/sid", "").replace(" GNU/Linux", "");
                                    try {
                                        ExecResult er = ExecUtils.exec2("lsb_release -d", new File("."), 10);
                                        if (er.resultCode == 0) {
                                            String str = er.getOutput();
                                            Pattern verP = Pattern.compile(".*:\\s+(.*\\s+\\d+\\.\\d+)\\.*\\d*.*");
                                            Matcher m = verP.matcher(str);
                                            if (m.matches()) {
                                                osNameFullStr = m.group(1);
                                                osNameFullStr = osNameFullStr.replace(" Linux", "").replace(" Server", "").replace(" release", "").replace(" version", "").replace(" GNU/Linux", "").replace("/sid", "");
                                            }
                                            break block27;
                                        }
                                        RTLogger.print(1, "lsb_release -d error: " + er.toStringOnError());
                                    }
                                    catch (Throwable e) {
                                        RTLogger.print(1, "lsb_release -d error: ", e);
                                    }
                                    break block27;
                                }
                                if (release_or_version.indexOf(10) != -1) {
                                    release_or_version = release_or_version.substring(0, release_or_version.indexOf(10)).trim();
                                }
                                if (release_or_version.indexOf(40) != -1) {
                                    release_or_version = release_or_version.substring(0, release_or_version.indexOf(40)).trim();
                                }
                                release_or_version = String.valueOf(release_or_version.substring(0, 1).toUpperCase()) + release_or_version.substring(1);
                                osNameFullStr = release_or_version.replace(" Linux", "").replace(" Server", "").replace(" release", "").replace(" version", "").replace("/sid", "");
                                Pattern verP = Pattern.compile("(.*\\s+\\d+\\.\\d+)\\.\\d+\\s*");
                                Matcher m = verP.matcher(osNameFullStr);
                                if (m.matches()) {
                                    osNameFullStr = m.group(1);
                                }
                                break block27;
                            }
                            break block27;
                        }
                        catch (Throwable throwable) {}
                        break block27;
                    }
                    if (osName.indexOf("hp-ux") != -1) {
                        UNIX_WHO = 2;
                        osNameFullStr = osVersionFromBean;
                    } else if (osName.indexOf("400") != -1) {
                        UNIX_WHO = 6;
                        osNameFullStr = osVersionFromBean;
                    } else if (osName.indexOf("freebsd") != -1) {
                        UNIX_WHO = 5;
                        String release = osNameFullStr = osVersionFromBean;
                        osNameFullStr = release.replace("-RELEASE", "");
                    } else if (osName.indexOf("sun os") != -1 || osName.indexOf("sunos") != -1 || osName.indexOf("solaris") != -1) {
                        UNIX_WHO = 3;
                        osNameFullStr = osVersionFromBean;
                    } else if (osName.indexOf("mac") != -1) {
                        UNIX_WHO = 4;
                        osNameFullStr = osVersionFromBean;
                    }
                    break block27;
                }
                OS = 0;
            }
            catch (Throwable ex) {
                OS = -1;
                RTLogger.print(1, "Error defining OS name: ", ex);
            }
        }
    }

    private static String execSimpleCmd(String command) throws IOException {
        Process p = Runtime.getRuntime().exec(command);
        byte[] arr = new byte[1024];
        try {
            Thread.sleep(200L);
        }
        catch (Throwable throwable) {}
        int chars = p.getInputStream().read(arr);
        String release = new String(arr, 0, chars);
        p.getInputStream().close();
        release = release.trim();
        if (release.indexOf(10) != -1) {
            release = release.substring(0, release.indexOf(10)).trim();
        }
        return release;
    }
}

