/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.pg;

import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.pg.IAssignmentTree;
import com.blixx.shared.pg.INodeGroupTree;
import com.blixx.shared.pg.IPolicyTree;
import com.blixx.shared.pg.IPowerGroupMgr;
import com.blixx.shared.pg.ObjectType;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.pg.PGEntityPermissionFlag;
import com.blixx.shared.pg.PGItem;
import com.blixx.shared.pg.PowerGroup;
import com.blixx.shared.utils.ConcurrentHashMapMap;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PowerGroupFactory
implements IPowerGroupMgr {
    public static final String UNLINKED2ANYROLE = "";
    private static IPowerGroupMgr m_instance = null;
    private INodeGroupTree m_nodeGroups = null;
    private IPolicyTree m_policyGroups = null;
    private IAssignmentTree m_assignmentGroups = null;
    private GroupTreeObject m_actionGroups = null;
    private GroupTreeObject m_packageGroups = null;
    private Map<String, AbstractAgentCard> m_agents = null;
    private ConcurrentHashMapMap<String, PowerGroup> m_rights = new ConcurrentHashMapMap();

    public static synchronized IPowerGroupMgr getInstance() {
        if (m_instance == null) {
            m_instance = new PowerGroupFactory();
        }
        return m_instance;
    }

    @Override
    public GroupTreeObject getNodeGroups() {
        return this.m_nodeGroups == null ? null : this.m_nodeGroups.getNodeGroupTree();
    }

    @Override
    public void setNodeGroups(INodeGroupTree nodeGroups) {
        this.m_nodeGroups = nodeGroups;
    }

    @Override
    public GroupTreeObject getPolicyGroups() {
        return this.m_policyGroups == null ? null : this.m_policyGroups.getPolicyTree();
    }

    @Override
    public void setPolicyGroups(IPolicyTree policyGroupsTree) {
        this.m_policyGroups = policyGroupsTree;
    }

    @Override
    public GroupTreeObject getAssignmentGroups() {
        return this.m_assignmentGroups == null ? null : this.m_assignmentGroups.getAsnTree();
    }

    @Override
    public void setAssignmentGroups(IAssignmentTree assignmentGroups) {
        this.m_assignmentGroups = assignmentGroups;
    }

    @Override
    public GroupTreeObject getActionGroups() {
        return this.m_actionGroups;
    }

    @Override
    public void setActionGroups(GroupTreeObject actionGroups) {
        this.m_actionGroups = actionGroups;
    }

    @Override
    public GroupTreeObject getPackageGroups() {
        return this.m_packageGroups;
    }

    @Override
    public void setPackageGroups(GroupTreeObject packageGroups) {
        this.m_packageGroups = packageGroups;
    }

    @Override
    public Map<String, AbstractAgentCard> getAgents() {
        return this.m_agents;
    }

    @Override
    public void setAgents(Map<String, AbstractAgentCard> agents) {
        this.m_agents = agents;
    }

    @Override
    public void addPowerGroup(String userRoleID, PowerGroup pg) {
        this.m_rights.removeElement(userRoleID, pg);
        this.m_rights.putV(userRoleID, pg);
    }

    @Override
    public boolean removePowerGroup(String userRoleID, List<String> pgidList) {
        Map<PowerGroup, Object> m = this.m_rights.getHashMap(userRoleID);
        boolean found = false;
        if (m != null) {
            Iterator<Map.Entry<PowerGroup, Object>> it = m.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<PowerGroup, Object> en = it.next();
                if (!pgidList.contains(en.getKey().m_ID)) continue;
                it.remove();
                found = true;
            }
        }
        return found;
    }

    public void clearAllRights() {
        this.m_rights.clear();
    }

    @Override
    public Map<PowerGroup, Object> getAllPowerGroups() {
        LinkedHashMap<PowerGroup, Object> mapGroups = new LinkedHashMap<PowerGroup, Object>();
        for (String userRole : this.m_rights.keySet()) {
            Map pumap = (Map)this.m_rights.get(userRole);
            mapGroups.putAll(pumap);
        }
        return mapGroups;
    }

    @Override
    public ConcurrentHashMapMap<String, PowerGroup> getAllPowerGroups2() {
        return this.m_rights;
    }

    @Override
    public Map<PowerGroup, Object> getPowerGroups(String userRoleID) {
        HashMap hashMap = this.m_rights.getHashMap(userRoleID);
        return hashMap == null ? new HashMap(0) : hashMap;
    }

    @Override
    public boolean isObjectTypeFiltered(String userRoleID, ObjectType objType) {
        Map<PowerGroup, Object> powerGroups = this.getPowerGroups(userRoleID);
        if (powerGroups != null) {
            for (PowerGroup pg : powerGroups.keySet()) {
                if (!pg.hasItems(objType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<PGItem> getAllExclusiveItems(ObjectType type) {
        Map<PowerGroup, Object> mapGroups = this.getAllPowerGroups();
        LinkedList<PGItem> powerGroups = new LinkedList<PGItem>();
        for (PowerGroup pg : mapGroups.keySet()) {
            Map<PGItem, Object> map = pg.getExclusiveItems(type);
            if (map == null) continue;
            powerGroups.addAll(map.keySet());
        }
        return powerGroups;
    }

    @Override
    public Collection<PGItem> getExclusiveItems(String userRoleID, ObjectType type) {
        LinkedList<PGItem> powerGroups = new LinkedList<PGItem>();
        Map map = (Map)this.m_rights.get(userRoleID);
        if (map != null) {
            for (PowerGroup pg : map.keySet()) {
                Map<PGItem, Object> mapItems = pg.getExclusiveItems(type);
                if (mapItems == null) continue;
                powerGroups.addAll(mapItems.keySet());
            }
        }
        return powerGroups;
    }

    @Override
    public GroupTreeObject getAsnTreePermissions(String userRoleID, int generalAccess) {
        GroupTreeObject rootPermissions = new GroupTreeObject(new TreeObject("root", null, null));
        this.setGeneralRoorPermissions(generalAccess, rootPermissions);
        try {
            Map map = (Map)this.m_rights.get(userRoleID);
            Collection<PGItem> allExclusiveItems = this.getAllExclusiveItems(ObjectType.pga);
            allExclusiveItems.removeAll(this.getExclusiveItems(userRoleID, ObjectType.pga));
            if (map != null && map.size() > 0) {
                for (PowerGroup pg : map.keySet()) {
                    List<GroupTreeObject> gtos;
                    Map<PGItem, Object> items = pg.getItems(ObjectType.pga, PGEntityPermissionFlag.RESTRICT);
                    if (items != null) {
                        for (PGItem item : items.keySet()) {
                            this.setPermit4AsnTree(rootPermissions, item, PGEntityPermissionFlag.RESTRICT);
                        }
                    }
                    if ((items = pg.getItems(ObjectType.pga, PGEntityPermissionFlag.ENFORCE)) != null) {
                        for (PGItem item : items.keySet()) {
                            this.setPermit4AsnTree(rootPermissions, item, PGEntityPermissionFlag.ENFORCE);
                        }
                    }
                    for (PGItem item : allExclusiveItems) {
                        gtos = this.setPermit4AsnTree(rootPermissions, item, PGEntityPermissionFlag.RESTRICT);
                        for (GroupTreeObject gto : gtos) {
                            if (gto == null || !gto.hasElements().booleanValue()) continue;
                            gto.clean();
                        }
                    }
                    items = pg.getItems(ObjectType.pga, PGEntityPermissionFlag.EXCLUSIVE);
                    if (items == null) continue;
                    for (PGItem item : items.keySet()) {
                        gtos = this.setPermit4AsnTree(rootPermissions, item, PGEntityPermissionFlag.EXCLUSIVE);
                        for (GroupTreeObject gto : gtos) {
                            if (gto == null || !gto.hasElements().booleanValue()) continue;
                            gto.clean();
                        }
                    }
                }
            } else {
                for (PGItem item : allExclusiveItems) {
                    this.setPermit4AsnTree(rootPermissions, item, PGEntityPermissionFlag.RESTRICT);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return rootPermissions;
    }

    private void setGeneralRoorPermissions(int generalAccess, GroupTreeObject rootPermissions) {
        switch (generalAccess) {
            case 2: {
                rootPermissions.setAttribute(PGEntityAction.READ.name(), PGEntityPermissionFlag.ENFORCE.name());
                rootPermissions.setAttribute(PGEntityAction.MODIFY.name(), PGEntityPermissionFlag.RESTRICT.name());
                break;
            }
            case 3: {
                rootPermissions.setAttribute(PGEntityAction.READ.name(), PGEntityPermissionFlag.ENFORCE.name());
                rootPermissions.setAttribute(PGEntityAction.MODIFY.name(), PGEntityPermissionFlag.ENFORCE.name());
                break;
            }
            default: {
                rootPermissions.setAttribute(PGEntityAction.READ.name(), PGEntityPermissionFlag.RESTRICT.name());
                rootPermissions.setAttribute(PGEntityAction.MODIFY.name(), PGEntityPermissionFlag.RESTRICT.name());
            }
        }
    }

    @Override
    public GroupTreeObject getPolicyTreePermissions(String userRoleID, int generalAccess) {
        GroupTreeObject rootPermissions = new GroupTreeObject(new TreeObject("root", null, null));
        this.setGeneralRoorPermissions(generalAccess, rootPermissions);
        try {
            Map map = (Map)this.m_rights.get(userRoleID);
            Collection<PGItem> allExclusiveItems = this.getAllExclusiveItems(ObjectType.pol);
            allExclusiveItems.removeAll(this.getExclusiveItems(userRoleID, ObjectType.pol));
            if (map != null && map.size() > 0) {
                for (PowerGroup pg : map.keySet()) {
                    List<GroupTreeObject> gtos;
                    Map<PGItem, Object> items = pg.getItems(ObjectType.pol, PGEntityPermissionFlag.RESTRICT);
                    if (items != null) {
                        for (PGItem item : items.keySet()) {
                            this.setPermit4PolicyTree(rootPermissions, item, PGEntityPermissionFlag.RESTRICT);
                        }
                    }
                    if ((items = pg.getItems(ObjectType.pol, PGEntityPermissionFlag.ENFORCE)) != null) {
                        for (PGItem item : items.keySet()) {
                            this.setPermit4PolicyTree(rootPermissions, item, PGEntityPermissionFlag.ENFORCE);
                        }
                    }
                    for (PGItem item : allExclusiveItems) {
                        gtos = this.setPermit4PolicyTree(rootPermissions, item, PGEntityPermissionFlag.RESTRICT);
                        for (GroupTreeObject gto : gtos) {
                            if (gto == null || !gto.hasElements().booleanValue()) continue;
                            gto.clean();
                        }
                    }
                    items = pg.getItems(ObjectType.pol, PGEntityPermissionFlag.EXCLUSIVE);
                    if (items == null) continue;
                    for (PGItem item : items.keySet()) {
                        gtos = this.setPermit4PolicyTree(rootPermissions, item, PGEntityPermissionFlag.EXCLUSIVE);
                        for (GroupTreeObject gto : gtos) {
                            if (gto == null || !gto.hasElements().booleanValue()) continue;
                            gto.clean();
                        }
                    }
                }
            } else {
                for (PGItem item : allExclusiveItems) {
                    this.setPermit4PolicyTree(rootPermissions, item, PGEntityPermissionFlag.RESTRICT);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return rootPermissions;
    }

    public GroupTreeObject getNodeGroupTreePermissions(String userRoleID, int generalAccess) {
        GroupTreeObject rootPermissions = new GroupTreeObject(new TreeObject("root", null, null));
        GroupTreeObject groups = new GroupTreeObject(new TreeObject("_Groups", UNLINKED2ANYROLE, null));
        rootPermissions.addElement(groups);
        this.setGeneralRoorPermissions(generalAccess, groups);
        try {
            Map map = (Map)this.m_rights.get(userRoleID);
            Collection<PGItem> allExclusiveItems = this.getAllExclusiveItems(ObjectType.ngr);
            allExclusiveItems.removeAll(this.getExclusiveItems(userRoleID, ObjectType.ngr));
            if (map != null && map.size() > 0) {
                for (PowerGroup pg : map.keySet()) {
                    GroupTreeObject folderTemp;
                    Map<PGItem, Object> items = pg.getItems(ObjectType.ngr, PGEntityPermissionFlag.RESTRICT);
                    if (items != null) {
                        for (PGItem item : items.keySet()) {
                            this.setPermit4NodeGroupTree(rootPermissions, item, PGEntityPermissionFlag.RESTRICT);
                        }
                    }
                    if ((items = pg.getItems(ObjectType.ngr, PGEntityPermissionFlag.ENFORCE)) != null) {
                        for (PGItem item : items.keySet()) {
                            this.setPermit4NodeGroupTree(rootPermissions, item, PGEntityPermissionFlag.ENFORCE);
                        }
                    }
                    for (PGItem item : allExclusiveItems) {
                        this.setPermit4NodeGroupTree(rootPermissions, item, PGEntityPermissionFlag.RESTRICT);
                        folderTemp = rootPermissions.searchPath(item.getPath(), UNLINKED2ANYROLE);
                        if (folderTemp == null) continue;
                        for (GroupTreeObject gto : folderTemp.getElements()) {
                            gto.clearAttributesRecursive(item.getAction().name());
                        }
                    }
                    items = pg.getItems(ObjectType.ngr, PGEntityPermissionFlag.EXCLUSIVE);
                    if (items == null) continue;
                    for (PGItem item : items.keySet()) {
                        this.setPermit4NodeGroupTree(rootPermissions, item, PGEntityPermissionFlag.EXCLUSIVE);
                        folderTemp = rootPermissions.searchPath(item.getPath(), UNLINKED2ANYROLE);
                        if (folderTemp == null) continue;
                        for (GroupTreeObject gto : folderTemp.getElements()) {
                            gto.clearAttributesRecursive(item.getAction().name(), PGEntityPermissionFlag.RESTRICT.name());
                        }
                    }
                }
            } else {
                for (PGItem item : allExclusiveItems) {
                    this.setPermit4NodeGroupTree(rootPermissions, item, PGEntityPermissionFlag.RESTRICT);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return rootPermissions;
    }

    @Override
    public boolean checkAction4PolicyTree(String userRoleID, PGEntityAction action, String policyNameOrPath, String policyType, int generalAccessRight) {
        GroupTreeObject rootPermissions = this.getPolicyTreePermissions(userRoleID, generalAccessRight);
        GroupTreeObject mainObjectTree = this.getPolicyGroups();
        return this.processCheckPermissionAbstract(action, policyNameOrPath, policyType, rootPermissions, mainObjectTree);
    }

    public boolean checkAction4NodeGroupTree(String userRoleID, PGEntityAction action, String agentIDOrPath, int generalAccessRight) {
        GroupTreeObject rootPermissions = this.getNodeGroupTreePermissions(userRoleID, generalAccessRight);
        GroupTreeObject mainObjectTree = this.getNodeGroups();
        return this.processCheckPermissionAbstract(action, agentIDOrPath, "agt", rootPermissions, mainObjectTree);
    }

    protected boolean processCheckPermissionAbstract(PGEntityAction action, String objNameOrPath, String type, GroupTreeObject rootPermissionsTree, GroupTreeObject mainObjectTree) {
        List<PGEntityAction> actions = PGEntityAction.MODIFY == action ? Arrays.asList(PGEntityAction.READ, PGEntityAction.MODIFY) : Arrays.asList(action);
        return this.processCheckPermissionAbstract(actions, objNameOrPath, type, rootPermissionsTree, mainObjectTree);
    }

    protected boolean processCheckPermissionAbstract(List<PGEntityAction> actions, String objNameOrPath, String type, GroupTreeObject rootPermissionsTree, GroupTreeObject mainObjectTree) {
        ArrayList<String> permitAttributes = new ArrayList<String>(actions.size());
        int i = 0;
        while (i < actions.size()) {
            permitAttributes.add(null);
            ++i;
        }
        GroupTreeObject permissionTreeObject = null;
        String path = objNameOrPath;
        GroupTreeObjectLast gtoPolicy = mainObjectTree.findElement(objNameOrPath, type);
        if (gtoPolicy != null) {
            permissionTreeObject = rootPermissionsTree.searchPath(gtoPolicy.getPath(), type);
            path = gtoPolicy.getPath();
        }
        while (permitAttributes.contains(null) && path.length() > 1) {
            if (permissionTreeObject == null) {
                int lastIndexOf = path.lastIndexOf(47);
                if (lastIndexOf == -1) {
                    return true;
                }
                path = path.substring(0, lastIndexOf);
                permissionTreeObject = rootPermissionsTree.searchPath(path, UNLINKED2ANYROLE);
                continue;
            }
            int i2 = 0;
            while (i2 < actions.size()) {
                String attribute;
                if (permitAttributes.get(i2) == null && (attribute = permissionTreeObject.getAttribute(actions.get(i2).name())) != null) {
                    permitAttributes.set(i2, attribute);
                }
                ++i2;
            }
            permissionTreeObject = permissionTreeObject.getParent();
        }
        boolean permitted = true;
        int i3 = 0;
        while (i3 < permitAttributes.size()) {
            permitted = permitted && !PGEntityPermissionFlag.RESTRICT.name().equals(permitAttributes.get(i3));
            ++i3;
        }
        return permitted;
    }

    @Override
    public boolean checkAction4AsnTree(String userRoleID, PGEntityAction action, String policyNameOrPath, int generalAccessRight) {
        GroupTreeObject rootPermissions = this.getAsnTreePermissions(userRoleID, generalAccessRight);
        GroupTreeObject mainObjectTree = this.getAssignmentGroups();
        return this.processCheckPermissionAbstract(action, policyNameOrPath, "pga", rootPermissions, mainObjectTree);
    }

    private List<GroupTreeObject> setPermit4PolicyTree(GroupTreeObject permissions, PGItem item, PGEntityPermissionFlag flag) throws CloneNotSupportedException {
        ArrayList<GroupTreeObject> result = new ArrayList<GroupTreeObject>(2);
        String path = item.getPath();
        if (path != null) {
            GroupTreeObject gto = this.getPolicyGroups().searchPath(path, UNLINKED2ANYROLE);
            if (gto != null) {
                GroupTreeObject el = GroupTreeObject.createPath(gto.getPath(), permissions);
                el.setAttribute(item.getAction().name(), flag.name());
                result.add(el);
            }
            if ((gto = this.getPolicyGroups().searchPath(path, "mon")) != null) {
                result.add(this.addGtoSetAttributes(permissions, item, gto, flag));
            }
            if ((gto = this.getPolicyGroups().searchPath(path, "msg")) != null) {
                result.add(this.addGtoSetAttributes(permissions, item, gto, flag));
            }
        } else {
            String name = item.getIdOrName();
            List<GroupTreeObject> elements = this.getPolicyGroups().findElements(name, "msg");
            if (elements != null) {
                for (GroupTreeObject el : elements) {
                    result.add(this.addGtoSetAttributes(permissions, item, el, flag));
                }
            }
            if ((elements = this.getPolicyGroups().findElements(name, "mon")) != null) {
                for (GroupTreeObject el : elements) {
                    result.add(this.addGtoSetAttributes(permissions, item, el, flag));
                }
            }
        }
        return result;
    }

    private List<GroupTreeObject> setPermit4NodeGroupTree(GroupTreeObject permissions, PGItem item, PGEntityPermissionFlag flag) throws CloneNotSupportedException {
        ArrayList<GroupTreeObject> result = new ArrayList<GroupTreeObject>(2);
        String path = item.getPath();
        if (path != null) {
            GroupTreeObject gto = this.getNodeGroups().searchPath(path, UNLINKED2ANYROLE);
            if (gto != null) {
                GroupTreeObject el = GroupTreeObject.createPath(gto.getPath(), permissions);
                el.setAttribute(item.getAction().name(), flag.name());
                result.add(el);
            }
            if ((gto = this.getNodeGroups().searchPath(path, "agt")) != null) {
                result.add(this.addGtoSetAttributes(permissions, item, gto, flag));
            }
        } else {
            String name = item.getIdOrName();
            List<GroupTreeObject> elements = this.getNodeGroups().findElements(name, "agt");
            if (elements != null) {
                for (GroupTreeObject el : elements) {
                    result.add(this.addGtoSetAttributes(permissions, item, el, flag));
                }
            }
        }
        return result;
    }

    private List<GroupTreeObject> setPermit4AsnTree(GroupTreeObject permissions, PGItem item, PGEntityPermissionFlag flag) throws CloneNotSupportedException {
        ArrayList<GroupTreeObject> result = new ArrayList<GroupTreeObject>(2);
        String path = item.getPath();
        if (path != null) {
            GroupTreeObject gto = this.getAssignmentGroups().searchPath(path, "pga");
            if (gto != null) {
                result.add(this.addGtoSetAttributes(permissions, item, gto, flag));
            }
        } else {
            String name = item.getIdOrName();
            List<GroupTreeObject> elements = this.getAssignmentGroups().findElements(name, "pga");
            if (elements != null) {
                for (GroupTreeObject el : elements) {
                    result.add(this.addGtoSetAttributes(permissions, item, el, flag));
                }
            }
        }
        return result;
    }

    private GroupTreeObject addGtoSetAttributes(GroupTreeObject permissions, PGItem item, GroupTreeObject gto, PGEntityPermissionFlag flag) throws CloneNotSupportedException {
        GroupTreeObject el = GroupTreeObject.createPath(gto.getParentPath(), permissions);
        GroupTreeObject newEl = el.getChild(gto.getName(), gto.getType());
        if (newEl == null) {
            newEl = gto.clone();
            el.addElement(newEl);
        }
        newEl.setAttribute(item.getAction().name(), flag.name());
        return newEl;
    }
}

