/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.pg;

import com.blixx.shared.pg.PGItem;
import java.util.LinkedHashMap;
import java.util.Map;

public class PowerGroupItemContainer {
    Map<PGItem, Object> m_filterItems = new LinkedHashMap<PGItem, Object>();
    Map<PGItem, Object> m_exclusiveItems = new LinkedHashMap<PGItem, Object>();
    Map<PGItem, Object> m_plusItems = new LinkedHashMap<PGItem, Object>();
    Map<PGItem, Object> m_minusItems = new LinkedHashMap<PGItem, Object>();

    public void add(PGItem item) {
        switch (item.getPermFlag()) {
            case FILTER: {
                this.m_filterItems.put(item, item);
                break;
            }
            case EXCLUSIVE: {
                this.m_exclusiveItems.put(item, item);
                break;
            }
            case ENFORCE: {
                this.m_plusItems.put(item, item);
                break;
            }
            case RESTRICT: {
                this.m_minusItems.put(item, item);
                break;
            }
        }
    }

    public boolean remove(PGItem item) {
        boolean removed = false;
        switch (item.getPermFlag()) {
            case FILTER: {
                removed = this.m_filterItems.remove(item) != null;
                break;
            }
            case EXCLUSIVE: {
                removed = this.m_exclusiveItems.remove(item) != null;
                break;
            }
            case ENFORCE: {
                removed = this.m_plusItems.remove(item) != null;
                break;
            }
            case RESTRICT: {
                removed = this.m_minusItems.remove(item) != null;
                break;
            }
        }
        return removed;
    }

    public int getTotalSize() {
        int count = 0;
        count += this.m_filterItems.size();
        count += this.m_exclusiveItems.size();
        count += this.m_plusItems.size();
        return count += this.m_minusItems.size();
    }

    public Map<PGItem, Object> getFilterItems() {
        return this.m_filterItems;
    }

    public Map<PGItem, Object> getExclusiveItems() {
        return this.m_exclusiveItems;
    }

    public Map<PGItem, Object> getPlusItems() {
        return this.m_plusItems;
    }

    public Map<PGItem, Object> getMinusItems() {
        return this.m_minusItems;
    }
}

