/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.space;

import com.blixx.log.RTLogger;
import com.blixx.shared.IID;
import com.blixx.shared.SecureDocumentBuilderFactory;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.ext.IServiceStatus;
import com.blixx.shared.space.Connection;
import com.blixx.shared.space.Node;
import com.blixx.shared.space.NodeXComparator;
import com.blixx.shared.space.Separator;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GCube {
    public static final String CATEGORY = "category";
    public static final String TARGET_ID = "targetID";
    public static final String SOURCE_ID = "sourceID";
    public static final String GCONNECTION = "GCONNECTION";
    public static final String GNODE = "GNODE";
    public static final String GSEP = "GSEP";
    public static final String PROPS = "PROPS";
    public static final String Z = "z";
    public static final String Y = "y";
    public static final String X = "x";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String IMAGE_URL = "imgurl";
    public LinkedHashMap<String, Node> m_nodes = new LinkedHashMap();
    public Map<String, Node> m_roots = new LinkedHashMap<String, Node>();
    public Map<String, Connection> m_connections = new LinkedHashMap<String, Connection>();
    public Map<String, Object> m_attributes = new LinkedHashMap<String, Object>();
    public Map<Integer, Integer> m_levels = new HashMap<Integer, Integer>();
    public static final char SEPARATOR_DEFAULT = '\u25ba';
    public boolean m_editMode = false;

    public GCube(boolean isEditMode) {
        this.m_editMode = isEditMode;
    }

    public boolean isEditMode() {
        return this.m_editMode;
    }

    public void updateFrom(GCube newCube) {
        this.m_nodes.clear();
        this.m_nodes.putAll(newCube.getNodes());
        this.m_connections.clear();
        this.m_connections.putAll(newCube.getConnections());
        this.m_roots.clear();
        this.m_roots.putAll(newCube.getRoots());
        this.m_attributes.clear();
        this.m_attributes.putAll(newCube.m_attributes);
        this.m_levels.clear();
        this.m_levels.putAll(newCube.m_levels);
    }

    public void addNode(Node node) {
        if (node.getType().equals("agt")) {
            node.sety(1000.0);
        }
        node.m_cube = this;
        this.applyCoordinats(node);
        this.m_nodes.put(node.getID(), node);
        for (Connection con : node.getTargets()) {
            this.m_connections.put(con.getID(), con);
        }
    }

    public Map getLevels() {
        return this.m_levels;
    }

    public void pack() {
        Iterator<Integer> it = this.m_levels.keySet().iterator();
        while (it.hasNext()) {
            Integer level = it.next();
            Integer size = this.m_levels.get(level);
            if (size != 0) continue;
            it.remove();
        }
        ArrayList<Integer> levels = new ArrayList<Integer>(this.m_levels.keySet());
        Collections.sort(levels);
        Iterator it2 = levels.iterator();
        int levelCount = 0;
        while (it2.hasNext()) {
            Integer level = (Integer)it2.next();
            List<Node> nodes = this.getNodes(level);
            Collections.sort(nodes, new NodeXComparator());
            Iterator<Node> itNodes = nodes.iterator();
            int xpos = 0;
            while (itNodes.hasNext()) {
                Node n = itNodes.next();
                n.setx(xpos);
                n.sety(levelCount);
                ++xpos;
            }
            this.m_levels.remove(level);
            if (xpos > 0) {
                this.m_levels.put(levelCount, xpos);
            }
            ++levelCount;
        }
    }

    public void insertNode(Node node) {
        int y = (int)node.gety();
        Integer count = this.m_levels.get(y);
        if (count == null) {
            this.m_levels.put(y, 1);
        } else {
            count = count + 1;
            this.m_levels.put(y, count);
        }
        List<Node> list = this.getNodes(y);
        int i = 0;
        while (i < list.size()) {
            Node tmp = list.get(i);
            if (tmp.getx() >= node.getx()) {
                int tx = (int)tmp.getx();
                tmp.setx(++tx);
            }
            ++i;
        }
        this.m_nodes.put(node.getID(), node);
        Iterator<Connection> it = node.getTargets().iterator();
        while (it.hasNext()) {
            Connection con = it.next();
            Node target = this.getNode(con.getTagetID());
            if (target != null && target.gety() == node.gety()) {
                it.remove();
                continue;
            }
            this.m_connections.put(con.getID(), con);
        }
    }

    public void addRoot(Node node) {
        this.applyCoordinats(node);
        this.m_nodes.put(node.getID(), node);
        this.m_roots.put(node.getID(), node);
        for (Connection con : node.getTargets()) {
            this.m_connections.put(con.getID(), con);
        }
    }

    private void applyCoordinats(Node n) {
        int y = (int)n.gety();
        Integer count = this.m_levels.get(y);
        if (count == null) {
            this.m_levels.put(y, 1);
            if (n.getx() <= 0.0) {
                n.setx(0.0);
            }
        } else {
            if (n.getx() < 0.0) {
                n.setx(count.intValue());
            }
            count = count + 1;
            this.m_levels.put(y, count);
        }
    }

    public int getMaxElements() {
        int max = 1;
        for (Integer level : this.m_levels.keySet()) {
            max = Math.max(max, this.m_levels.get(level));
        }
        return max;
    }

    public int getSize(int level) {
        Integer size = this.m_levels.get(level);
        if (size == null) {
            size = 0;
        }
        return size;
    }

    public int getRealSlices() {
        return this.m_levels.size();
    }

    public Map<String, Node> getRoots() {
        return this.m_roots;
    }

    public void setDataObject(String key, Object value) {
        this.m_attributes.put(key, value);
    }

    public Object getDataObject(String key) {
        return this.m_attributes.get(key);
    }

    public Map getDataObjects() {
        return this.m_attributes;
    }

    public Map<String, Node> getNodes() {
        return this.m_nodes;
    }

    public Map<String, Connection> getConnections() {
        return this.m_connections;
    }

    public GroupTreeObject getTree(String id, String direction, List<String> endTypes) {
        GroupTreeObject root = null;
        Node n = this.m_nodes.get(id);
        root = new GroupTreeObject(new TreeObject(n.getName(), n.getType(), n.getID()));
        this.addChildren(direction, endTypes, root, n);
        return root;
    }

    public void clear() {
        this.m_nodes.clear();
        this.m_connections.clear();
        this.m_levels.clear();
        this.m_roots.clear();
        this.m_attributes.clear();
    }

    public void addTree(GroupTreeObject root, String cubeRootID, int startY, int Z) {
        Node n = this.m_nodes.get(cubeRootID);
        if (n != null) {
            Iterator<GroupTreeObject> it = root.getElements().iterator();
            int folderX = 0;
            while (it.hasNext()) {
                GroupTreeObject gto = it.next();
                if (gto instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
                    if (gtol.getLinkedPath() != null) {
                        n.addTargetYplus(this, gtol.getLinkedPath(), "link");
                        continue;
                    }
                    String ID = gto.getPath();
                    Object o = gto.getTreeObject().getObject();
                    if (o != null && o instanceof IID) {
                        ID = ((IID)o).getID();
                    }
                    Node lastElement = new Node(this, ID, -1.0, startY, Z, gto.getName(), gto.getTreeObject().getType());
                    lastElement.setObject(o);
                    n.addTargetYplus(this, lastElement.getID(), "");
                    this.addNode(lastElement);
                    continue;
                }
                Node folder = new Node(this, gto.getPath(), ++folderX, startY, Z, gto.getName(), gto.getTreeObject().getType());
                n.addTargetYplus(this, folder.getID(), "");
                this.addNode(folder);
                this.addTree(gto, folder.getID(), startY + 1, Z);
            }
        }
    }

    private void addChildren(String direction, List<String> endTypes, GroupTreeObject currGTO, Node currNode) {
        Set<Connection> clist = currNode.getTargets();
        for (Connection c : clist) {
            String targetID;
            Node child;
            if (!c.getType().equalsIgnoreCase(direction) || (child = this.m_nodes.get(targetID = c.getTagetID())) == null) continue;
            String type = child.getType();
            if (endTypes.contains(type)) {
                GroupTreeObjectLast gtol = new GroupTreeObjectLast(new TreeObject(child.getName(), child.getType(), child.getID()), null, null);
                currGTO.addElement(gtol);
                continue;
            }
            GroupTreeObject gto = new GroupTreeObject(new TreeObject(child.getName(), child.getType(), child.getID()));
            currGTO.addElement(gto);
            this.addChildren(direction, endTypes, gto, child);
        }
    }

    public Node getNode(String id) {
        return this.m_nodes.get(id);
    }

    public void storeXML(String filename) {
        try {
            Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("GCUBE");
            doc.appendChild(root);
            for (String id : this.m_nodes.keySet()) {
                Node n = this.m_nodes.get(id);
                this.createNodeXML(doc, root, n);
            }
            GCube.writeXml(doc, new File(filename));
        }
        catch (Throwable e) {
            RTLogger.print(2, "", e);
        }
    }

    public void storeXML(String filename, List<String> exceptTypes) {
        try {
            Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("GCUBE");
            doc.appendChild(root);
            for (String id : this.m_nodes.keySet()) {
                Node n = this.m_nodes.get(id);
                if (exceptTypes.contains(n.getType())) continue;
                Iterator<Connection> it2 = n.getTargets().iterator();
                while (it2.hasNext()) {
                    Connection id2 = it2.next();
                    if (this.m_nodes.containsKey(id2.getTagetID())) continue;
                    it2.remove();
                }
                this.createNodeXML(doc, root, n);
            }
            GCube.writeXml(doc, new File(filename));
        }
        catch (Throwable e) {
            RTLogger.print(2, "", e);
        }
    }

    public void loadXML(String pathname) {
        File file = new File(pathname);
        if (file.exists() && file.canRead()) {
            this.loadXML(file);
        }
    }

    public void loadXML(File file) {
        try {
            FileInputStream fio = new FileInputStream(file);
            try {
                Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fio);
                Element top = doc.getDocumentElement();
                NodeList nl = top.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node n;
                    String type;
                    String name;
                    double z;
                    String zS;
                    double y;
                    String yS;
                    double x;
                    String xS;
                    String id;
                    org.w3c.dom.Node item = nl.item(i);
                    String node = item.getNodeName();
                    if (node.equals(GNODE)) {
                        id = XMLFactory.unescape(((Element)item).getAttribute(ID));
                        xS = XMLFactory.unescape(((Element)item).getAttribute(X));
                        x = 0.0;
                        try {
                            x = Double.parseDouble(xS);
                        }
                        catch (Throwable throwable) {}
                        yS = XMLFactory.unescape(((Element)item).getAttribute(Y));
                        y = 0.0;
                        try {
                            y = Double.parseDouble(yS);
                        }
                        catch (Throwable throwable) {}
                        zS = XMLFactory.unescape(((Element)item).getAttribute(Z));
                        z = 0.0;
                        try {
                            z = Double.parseDouble(zS);
                        }
                        catch (Throwable throwable) {}
                        name = XMLFactory.unescape(((Element)item).getAttribute(NAME));
                        type = XMLFactory.unescape(((Element)item).getAttribute(TYPE));
                        n = new Node(this, id, x, y, z, name, type);
                        String imgURL = XMLFactory.unescape(((Element)item).getAttribute(IMAGE_URL));
                        n.setImgURL(imgURL);
                        NodeList cl = item.getChildNodes();
                        int j = 0;
                        while (j < cl.getLength()) {
                            org.w3c.dom.Node itemC = cl.item(j);
                            String nname = itemC.getNodeName();
                            if (nname.equals(PROPS)) {
                                org.w3c.dom.Node cdata = XMLFactory.searchCDATA(itemC);
                                String data = cdata.getNodeValue().trim();
                                Properties elProperties = XMLFactory.extractProperties("\u25ba", data);
                                if (elProperties != null) {
                                    n.setProperties(elProperties);
                                }
                            } else if (nname.equals(GCONNECTION)) {
                                XMLFactory.unescape(((Element)itemC).getAttribute(SOURCE_ID));
                                String targetID = XMLFactory.unescape(((Element)itemC).getAttribute(TARGET_ID));
                                String typeC = XMLFactory.unescape(((Element)itemC).getAttribute(TYPE));
                                String cat = XMLFactory.unescape(((Element)itemC).getAttribute(CATEGORY));
                                NodeList connCH = itemC.getChildNodes();
                                Properties connProperties = null;
                                int k = 0;
                                while (k < connCH.getLength()) {
                                    org.w3c.dom.Node cdata;
                                    String data;
                                    org.w3c.dom.Node nodeInC = connCH.item(k);
                                    String nnameInC = nodeInC.getNodeName();
                                    if (nnameInC.equals(PROPS) && (connProperties = XMLFactory.extractProperties("\u25ba", data = (cdata = XMLFactory.searchCDATA(nodeInC)).getNodeValue().trim())) != null && connProperties.isEmpty()) {
                                        connProperties = null;
                                    }
                                    ++k;
                                }
                                n.addTargetConnection(this, typeC, targetID, cat, connProperties);
                            }
                            ++j;
                        }
                        if (type.equals("root")) {
                            this.addRoot(n);
                        } else {
                            this.addNode(n);
                        }
                    } else if (node.equals(GSEP)) {
                        id = XMLFactory.unescape(((Element)item).getAttribute(ID));
                        xS = XMLFactory.unescape(((Element)item).getAttribute(X));
                        x = 0.0;
                        try {
                            x = Double.parseDouble(xS);
                        }
                        catch (Throwable throwable) {}
                        yS = XMLFactory.unescape(((Element)item).getAttribute(Y));
                        y = 0.0;
                        try {
                            y = Double.parseDouble(yS);
                        }
                        catch (Throwable throwable) {}
                        zS = XMLFactory.unescape(((Element)item).getAttribute(Z));
                        z = 0.0;
                        try {
                            z = Double.parseDouble(zS);
                        }
                        catch (Throwable throwable) {}
                        name = "";
                        type = GSEP;
                        n = new Separator(this, id, x, y, z, name, type);
                        this.addNode(n);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                RTLogger.print(1, "Error parsing xml file: " + e.getMessage());
                RTLogger.print(2, "", e);
            }
            try {
                fio.close();
            }
            catch (Throwable throwable) {}
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public void createNodeXML(Document doc, Element root, Node node) throws IOException {
        if (node instanceof Separator) {
            this.createSeparatorXML(doc, root, (Separator)node);
            return;
        }
        Element el = doc.createElement(GNODE);
        el.setAttribute(ID, XMLFactory.escape(node.getID()));
        el.setAttribute(NAME, XMLFactory.escape(node.getName()));
        el.setAttribute(TYPE, XMLFactory.escape(node.getType()));
        el.setAttribute(X, "" + node.getx());
        el.setAttribute(Y, "" + node.gety());
        el.setAttribute(Z, "" + node.getz());
        el.setAttribute(IMAGE_URL, XMLFactory.escape(node.getImgURL()));
        Element cdata = XMLFactory.getCDATA(doc, PROPS, node.getProperties(), "\u25ba");
        el.appendChild(cdata);
        Set<Connection> list = node.getTargets();
        for (Connection conn : list) {
            this.createConnectionXML(doc, el, conn);
        }
        root.appendChild(el);
    }

    public void createConnectionXML(Document doc, Element node, Connection conn) throws IOException {
        Element el = doc.createElement(GCONNECTION);
        el.setAttribute(SOURCE_ID, XMLFactory.escape(conn.getSourceID()));
        el.setAttribute(TARGET_ID, XMLFactory.escape(conn.getTagetID()));
        el.setAttribute(TYPE, XMLFactory.escape(conn.getType()));
        el.setAttribute(CATEGORY, XMLFactory.escape(conn.getSubType()));
        Element cdata = XMLFactory.getCDATA(doc, PROPS, conn.getProperties(), "\u25ba");
        el.appendChild(cdata);
        node.appendChild(el);
    }

    public void createSeparatorXML(Document doc, Element root, Separator node) throws IOException {
        Element el = doc.createElement(GSEP);
        el.setAttribute(ID, XMLFactory.escape(node.getID()));
        el.setAttribute(NAME, XMLFactory.escape(node.getName()));
        el.setAttribute(TYPE, XMLFactory.escape(node.getType()));
        el.setAttribute(X, "" + node.getx());
        el.setAttribute(Y, "" + node.gety());
        el.setAttribute(Z, "" + node.getz());
        root.appendChild(el);
    }

    protected static boolean writeXml(Document doc, File file) {
        return XMLFactory.writeXml(doc, file);
    }

    public List<Node> getNodes(int level) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (String id : this.m_nodes.keySet()) {
            Node n = this.m_nodes.get(id);
            if (level != (int)n.gety()) continue;
            list.add(n);
        }
        return list;
    }

    public void moveNodes(int level, int newLevel) {
        Iterator<String> it = this.m_nodes.keySet().iterator();
        this.m_levels.put(level, 0);
        while (it.hasNext()) {
            String id = it.next();
            Node n = this.m_nodes.get(id);
            if (level != (int)n.gety()) continue;
            n.sety(newLevel);
            this.applyCoordinats(n);
        }
    }

    public Separator moveNode(Node n, int inc) {
        Separator sep = null;
        if (n.gety() == 0.0 || n.getType().equals("service")) {
            return sep;
        }
        if (n.gety() <= 1.0 && inc < 0) {
            return sep;
        }
        int oldLevel = (int)n.gety();
        this.removeNode(n, true);
        if (this.getNodes(oldLevel).size() == 0) {
            if (inc < 0) {
                int i = oldLevel + 1;
                while (i < this.getRealSlices()) {
                    this.moveNodes(i, i - 1);
                    ++i;
                }
                i = this.getRealSlices() - 1;
                while (i > 0) {
                    if (this.m_levels.get(i) == 0) {
                        this.m_levels.remove(i);
                        --i;
                        continue;
                    }
                    break;
                }
            } else if (inc > 0) {
                sep = new Separator(this, UUID.randomUUID().toString(), 0.0, oldLevel, n.getz(), "", GSEP);
                this.insertNode(sep);
            }
        }
        int mY = inc + oldLevel;
        n.sety(mY);
        if (mY == this.getRealSlices() - 1) {
            this.moveNodes(this.getRealSlices() - 1, this.getRealSlices());
            n.setx(0.0);
        }
        this.insertNode(n);
        return sep;
    }

    public void removeNode(Node node, boolean keepConnection) {
        String id2 = this.removeNodeInternal(node);
        if (keepConnection) {
            return;
        }
        Iterator<String> it = this.m_connections.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            Connection con = this.m_connections.get(id);
            if (con.getSourceID().equals(id2)) {
                it.remove();
                continue;
            }
            if (!con.getTagetID().equals(id2)) continue;
            String parentID = con.getSourceID();
            Node n = this.getNode(parentID);
            if (n != null) {
                n.removeConnection(con);
            }
            it.remove();
        }
    }

    private String removeNodeInternal(Node node) {
        String id2 = node.getID();
        int xpos = (int)node.getx();
        this.m_nodes.remove(id2);
        int level = (int)node.gety();
        Integer count = this.m_levels.get(level);
        count = count - 1;
        this.m_levels.put(level, count);
        List<Node> list = this.getNodes(level);
        int i = 0;
        while (i < list.size()) {
            Node n = list.get(i);
            int getx = (int)n.getx();
            if (getx > xpos) {
                n.setx(--getx);
            }
            ++i;
        }
        return id2;
    }

    public Separator moveHorizontal(Node node, int inc) {
        if (node.gety() == (double)(this.getRealSlices() - 1)) {
            return null;
        }
        if (node.getx() <= 0.0 && inc < 0) {
            return null;
        }
        Separator sep = null;
        int oldX = (int)node.getx();
        int newX = inc + oldX;
        if (newX == this.getSize((int)node.gety())) {
            this.removeNodeInternal(node);
            sep = new Separator(this, UUID.randomUUID().toString(), oldX, node.gety(), node.getz(), "", GSEP);
            this.insertNode(sep);
        } else {
            this.removeNodeInternal(node);
        }
        node.setx(newX);
        this.insertNode(node);
        return sep;
    }

    public void cleanLastLevel() {
        if (this.m_levels.get(this.getRealSlices() - 1) == 0) {
            this.m_levels.remove(this.getRealSlices() - 1);
        }
    }

    public void removeConnection(Connection c) {
        if (c == null || c.getSourceID() == null) {
            return;
        }
        Node n = this.getNode(c.getSourceID());
        if (n != null) {
            n.removeConnection(c);
        }
        this.m_connections.remove(c.getSourceID());
    }

    public void invalidateStatuses() {
        for (String id : this.m_nodes.keySet()) {
            Node n = this.m_nodes.get(id);
            if (n == null || !n.isStatusAvailable()) continue;
            IServiceStatus iss = (IServiceStatus)n.getObject();
            iss.invalidateStatus();
        }
    }
}

