/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.RTLogger;
import com.blixx.shared.utils.FileSyncUtils;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class AsfUtils {
    public static final String EXTENSION = ".asf";
    public static final String AGENTID = "agentID";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonArray parseFile(File file) {
        JsonArray array = null;
        InputStreamReader freader = null;
        try {
            try {
                JsonParser parser = new JsonParser();
                freader = new FileReader(file);
                array = parser.parse(freader).getAsJsonArray();
                return array;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (freader == null) return array;
                try {
                    freader.close();
                    return array;
                }
                catch (IOException e) {
                    RTLogger.print(5, "", e);
                }
                return array;
            }
            catch (Throwable throwable) {
                if (freader == null) return array;
                try {
                    freader.close();
                    return array;
                }
                catch (IOException e) {
                    RTLogger.print(5, "", e);
                }
                return array;
            }
        }
        finally {
            if (freader != null) {
                try {
                    freader.close();
                }
                catch (IOException e) {
                    RTLogger.print(5, "", e);
                }
            }
        }
    }

    public static String getAgentSpecificJson(JsonArray array, String agentID) {
        JsonArray nArray = new JsonArray();
        for (JsonElement obj : array) {
            String joAgentID;
            JsonElement aid;
            if (obj == null || (aid = obj.getAsJsonObject().get(AGENTID)) != null && !agentID.equals(joAgentID = aid.getAsString()) && joAgentID.length() > 0 && !joAgentID.equals("*")) continue;
            nArray.add(obj);
        }
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        builder.disableHtmlEscaping();
        return builder.create().toJson(nArray);
    }

    public static String getAgentSpecificJson(File file, String agentID) {
        String result = null;
        JsonArray content = AsfUtils.parseFile(file);
        if (content != null) {
            result = AsfUtils.getAgentSpecificJson(content, agentID);
        }
        return result;
    }

    public static String getDigest(File file, String agentID) {
        String digest = null;
        JsonArray arr = AsfUtils.parseFile(file);
        if (arr != null) {
            String agentSpecificJson = AsfUtils.getAgentSpecificJson(arr, agentID);
            try {
                digest = FileSyncUtils.getDigest(file.getName(), agentSpecificJson);
            }
            catch (Throwable throwable) {}
        }
        return digest;
    }
}

