/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.RTLogger;
import com.blixx.shared.utils.Digest;
import com.blixx.shared.utils.Shabal256;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class FileSyncUtils {
    public static final String MARK_MODIFIED = "[M]";
    public static final String MARK_ADDED = "[A]";
    public static final String MARK_DELETED = "[D]";
    public static final String MARK_CONFLICT = "[!]";
    public static final String MARK_OK = "[OK]";
    static final byte[] DIR_STUB = "<dir>".getBytes();
    static final byte[] EMPTY_DIR_STUB = "<empty>".getBytes();
    static final String DIR_HASH = FileSyncUtils.byteArray2Hex(DIR_STUB);
    static final String EMPTY_DIR_HASH = FileSyncUtils.byteArray2Hex(EMPTY_DIR_STUB);

    public static String getDigest(File f) throws Exception {
        HashMap<String, byte[]> m = FileSyncUtils.getDigestMap(f);
        return FileSyncUtils.formatDigest(m);
    }

    public static String getDigest(String fileName, String content) throws Exception {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        Shabal256 d = new Shabal256();
        m.put(fileName, FileSyncUtils.string2digest(d, fileName, content));
        return FileSyncUtils.formatDigest(m);
    }

    public static HashMap<String, byte[]> getDigestMap(File f) throws Exception {
        File[] children;
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        Shabal256 d = new Shabal256();
        if (f.isFile()) {
            m.put(f.getName(), FileSyncUtils.file2digest(d, f));
        } else if (f.isDirectory() && (children = f.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    m.put(child.getName(), FileSyncUtils.file2digest(d, child));
                } else {
                    m.putAll(FileSyncUtils.collectDirDigest(String.valueOf(child.getName()) + "/", d, child));
                }
                ++n2;
            }
            if (children.length == 0) {
                String name = "/";
                m.put(name, EMPTY_DIR_STUB);
            }
        }
        return m;
    }

    public static Map<String, String> formatDigestMap(Map<String, byte[]> digest) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, byte[]> e : digest.entrySet()) {
            result.put(e.getKey(), FileSyncUtils.byteArray2Hex(e.getValue()));
        }
        return result;
    }

    public static String getShortDigest(File f) throws Exception {
        HashMap<String, byte[]> m = FileSyncUtils.getShortDigestMap(f);
        return FileSyncUtils.formatDigest(m);
    }

    public static String getShortDigestPackages(File f) throws Exception {
        HashMap<String, byte[]> m = FileSyncUtils.getShortDigestMapPackages(f);
        return FileSyncUtils.formatDigest(m);
    }

    public static HashMap<String, byte[]> getShortDigestMap(File f) throws Exception {
        File[] children;
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        Shabal256 d = new Shabal256();
        if (f.isFile()) {
            m.put(f.getName(), FileSyncUtils.file2digest(d, f));
        } else if (f.isDirectory() && (children = f.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    m.put(child.getName(), FileSyncUtils.file2digest(d, child));
                } else {
                    m.put(String.valueOf(child.getName()) + "/", FileSyncUtils.dir2digest(d, child));
                }
                ++n2;
            }
            if (children.length == 0) {
                String name = "/";
                m.put(name, EMPTY_DIR_STUB);
            }
        }
        return m;
    }

    public static HashMap<String, byte[]> getShortDigestMapPackages(File f) throws Exception {
        File[] children;
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        Shabal256 d = new Shabal256();
        if (f.isFile()) {
            m.put(f.getName(), FileSyncUtils.file2digest(d, f));
        } else if (f.isDirectory() && (children = f.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (!child.isFile()) {
                    m.put(String.valueOf(child.getName()) + "/", FileSyncUtils.dir2digest(d, child));
                }
                ++n2;
            }
            if (m.size() == 0) {
                String name = "/";
                m.put(name, EMPTY_DIR_STUB);
            }
        }
        return m;
    }

    public static String verifyDigest(File f, String digest, boolean verbose) throws Exception {
        int n;
        HashMap<String, String> original = FileSyncUtils.parseDigest(digest);
        HashMap<String, String> result = new HashMap<String, String>();
        String signature = original.remove("/");
        if (signature != null) {
            assert (signature.equals(EMPTY_DIR_HASH));
            if (f.isFile()) {
                result.put("/", MARK_CONFLICT);
            } else {
                File[] children = f.listFiles();
                if (children != null) {
                    File[] fileArray = children;
                    n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        String name = child.getName();
                        if (f.isDirectory()) {
                            name = String.valueOf(name) + "/";
                        }
                        result.put(name, MARK_ADDED);
                        ++n2;
                    }
                }
            }
        } else {
            Shabal256 d = new Shabal256();
            if (f.isFile()) {
                result = FileSyncUtils.verifyFileDigest(original, f.getName(), d, f);
            } else {
                File[] children = f.listFiles();
                if (children != null) {
                    File[] fileArray = children;
                    int n3 = children.length;
                    n = 0;
                    while (n < n3) {
                        File child = fileArray[n];
                        if (child.isFile()) {
                            result.putAll(FileSyncUtils.verifyFileDigest(original, child.getName(), d, child));
                        } else {
                            result.putAll(FileSyncUtils.verifyDirDigest(original, child.getName(), d, child));
                        }
                        ++n;
                    }
                }
            }
        }
        for (String key : original.keySet()) {
            result.put(key, MARK_DELETED);
        }
        return FileSyncUtils.formatReport(result, verbose);
    }

    public static String verifyDigestPackages(File f, String digest, boolean verbose) throws Exception {
        int n;
        HashMap<String, String> original = FileSyncUtils.parseDigest(digest);
        HashMap<String, String> result = new HashMap<String, String>();
        String signature = original.remove("/");
        if (signature != null) {
            assert (signature.equals(EMPTY_DIR_HASH));
            if (f.isFile()) {
                result.put("/", MARK_CONFLICT);
            } else {
                File[] children = f.listFiles();
                if (children != null) {
                    File[] fileArray = children;
                    n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        String name = child.getName();
                        if (f.isDirectory()) {
                            name = String.valueOf(name) + "/";
                        }
                        result.put(name, MARK_ADDED);
                        ++n2;
                    }
                }
            }
        } else {
            Shabal256 d = new Shabal256();
            if (f.isFile()) {
                result = FileSyncUtils.verifyFileDigest(original, f.getName(), d, f);
            } else {
                File[] children = f.listFiles();
                if (children != null) {
                    File[] fileArray = children;
                    int n3 = children.length;
                    n = 0;
                    while (n < n3) {
                        File child = fileArray[n];
                        if (!child.isFile()) {
                            result.putAll(FileSyncUtils.verifyDirDigest(original, child.getName(), d, child));
                        }
                        ++n;
                    }
                }
            }
        }
        for (String key : original.keySet()) {
            result.put(key, MARK_DELETED);
        }
        return FileSyncUtils.formatReport(result, verbose);
    }

    public static byte[] file2digest(Digest algorithm, File file) throws Exception {
        algorithm = algorithm.copy();
        algorithm.reset();
        FileSyncUtils.updateDigest(algorithm, file);
        return algorithm.digest();
    }

    public static byte[] string2digest(Digest algorithm, String filename, String content) throws Exception {
        algorithm = algorithm.copy();
        algorithm.reset();
        algorithm.update(filename.getBytes());
        if (content.length() != 0) {
            ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes());
            FileSyncUtils.updateDigest(algorithm, bis);
        }
        return algorithm.digest();
    }

    public static void updateDigest(Digest algorithm, File file) throws Exception {
        algorithm.update(file.getName().getBytes());
        if (file.length() == 0L) {
            return;
        }
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        FileSyncUtils.updateDigest(algorithm, bis);
    }

    public static void updateDigest(Digest algorithm, InputStream bis) throws IOException {
        try {
            int count;
            byte[] arr = new byte[65536];
            while ((count = bis.read(arr)) != -1) {
                algorithm.update(arr, 0, count);
            }
        }
        finally {
            bis.close();
        }
    }

    public static byte[] dir2digest(Digest algorithm, File dir) throws Exception {
        algorithm = algorithm.copy();
        algorithm.reset();
        FileSyncUtils.updateDigestRecursively(algorithm, dir);
        return algorithm.digest();
    }

    public static void updateDigestRecursively(Digest algorithm, File dir) throws Exception {
        algorithm.update((String.valueOf(dir.getName()) + "/").getBytes());
        Object[] children = dir.list();
        if (children != null) {
            Arrays.sort(children);
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object name = objectArray[n2];
                File f = new File(dir, (String)name);
                if (f.isFile()) {
                    FileSyncUtils.updateDigest(algorithm, f);
                } else {
                    FileSyncUtils.updateDigestRecursively(algorithm, f);
                }
                ++n2;
            }
        }
    }

    public static String byteArray2Hex(byte[] hash) {
        String result = null;
        Formatter formatter = null;
        try {
            formatter = new Formatter();
            byte[] byArray = hash;
            int n = hash.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                formatter.format("%02x", b);
                ++n2;
            }
            result = formatter.toString();
        }
        catch (Throwable throwable) {
            if (formatter != null) {
                try {
                    formatter.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (formatter != null) {
            try {
                formatter.close();
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public static HashMap<String, String> parseDigest(String digest) {
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 0;
        while (i != -1) {
            int start = i;
            int mid = digest.indexOf(10, start + 1);
            if (mid == -1) {
                RTLogger.print(3, new StringBuffer("Malformed Digest: ").append(digest));
                throw new RuntimeException("Malformed digest string: ");
            }
            int end = digest.indexOf(10, mid + 1);
            if (end == -1) {
                end = digest.length();
                i = -1;
            } else {
                i = end == digest.length() - 1 ? -1 : end + 1;
            }
            String name = digest.substring(start, mid);
            String hash = digest.substring(mid + 1, end);
            result.put(name, hash);
        }
        return result;
    }

    private static HashMap<String, String> verifyFileDigest(Map<String, String> original, String name, Digest algorithm, File f) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String signature = original.remove(String.valueOf(name) + "/");
        if (signature != null) {
            if (original.containsKey(name)) {
                throw new RuntimeException("Invalid digest: ambiguous data for " + name);
            }
            result.put(name, MARK_CONFLICT);
            return result;
        }
        signature = original.remove(name);
        if (signature == null) {
            result.put(name, MARK_ADDED);
        } else {
            byte[] b = FileSyncUtils.file2digest(algorithm, f);
            if (!signature.equals(FileSyncUtils.byteArray2Hex(b))) {
                result.put(name, MARK_MODIFIED);
            } else {
                result.put(name, MARK_OK);
            }
        }
        return result;
    }

    private static HashMap<String, String> verifyDirDigest(Map<String, String> original, String name, Digest algorithm, File dir) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String signature = original.remove(name);
        name = String.valueOf(name) + "/";
        if (signature != null) {
            result.put(name, MARK_CONFLICT);
            return result;
        }
        signature = original.remove(name);
        if (signature == null) {
            result.put(name, MARK_ADDED);
        } else if (signature.equals(DIR_HASH)) {
            result.put(name, MARK_OK);
            File[] children = dir.listFiles();
            if (children != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isFile()) {
                        result.putAll(FileSyncUtils.verifyFileDigest(original, String.valueOf(name) + f.getName(), algorithm, f));
                    } else {
                        result.putAll(FileSyncUtils.verifyDirDigest(original, String.valueOf(name) + f.getName(), algorithm, f));
                    }
                    ++n2;
                }
            }
        } else {
            String actual = FileSyncUtils.byteArray2Hex(FileSyncUtils.dir2digest(algorithm, dir));
            if (actual != null && actual.equals(signature)) {
                result.put(name, MARK_OK);
            } else {
                result.put(name, MARK_MODIFIED);
            }
        }
        return result;
    }

    private static HashMap<String, byte[]> collectDirDigest(String name, Digest d, File dir) throws Exception {
        assert (name.endsWith("/"));
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put(name, DIR_STUB);
        File[] children = dir.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    m.put(String.valueOf(name) + f.getName(), FileSyncUtils.file2digest(d, f));
                } else {
                    m.putAll(FileSyncUtils.collectDirDigest(String.valueOf(name) + f.getName() + "/", d, f));
                }
                ++n2;
            }
        }
        return m;
    }

    public static String formatReport(Map<String, String> m, boolean verbose) {
        StringBuilder sb = new StringBuilder(m.size() * 256);
        for (Map.Entry<String, String> e : m.entrySet()) {
            if (!verbose && e.getValue().equals(MARK_OK)) continue;
            sb.append(e.getValue()).append(e.getKey()).append('\n');
        }
        return sb.toString();
    }

    public static String formatDigest(Map<String, byte[]> m) {
        StringBuilder sb = new StringBuilder(m.size() * 256);
        for (Map.Entry<String, byte[]> e : m.entrySet()) {
            sb.append(e.getKey()).append('\n').append(FileSyncUtils.byteArray2Hex(e.getValue())).append('\n');
        }
        return sb.toString();
    }
}

