/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.os.SystemUtils;
import com.blixx.shared.utils.DirFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FileUtils {
    public static String invalidFileNameChars_regex = "[\"/*?<>:\\\\|@',;!% =]+";

    private FileUtils() {
    }

    public static void copyFile(File source, File target) throws IOException {
        block24: {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                try {
                    fis = new FileInputStream(source);
                    fos = new FileOutputStream(target);
                    int count = -1;
                    byte[] buffer = new byte[2048];
                    while ((count = fis.read(buffer)) != -1) {
                        fos.write(buffer, 0, count);
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable4) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable5) {}
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void appendFile(File source, File target) throws IOException {
        block24: {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                try {
                    fis = new FileInputStream(source);
                    fos = new FileOutputStream(target, true);
                    int count = -1;
                    byte[] buffer = new byte[2048];
                    while ((count = fis.read(buffer)) != -1) {
                        fos.write(buffer, 0, count);
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable4) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable5) {}
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static String resolveEnvVars(String in) {
        Set<String> keys = System.getenv().keySet();
        for (String key : keys) {
            String val = System.getenv(key);
            if (val == null) {
                val = "";
            }
            if (SystemUtils.OS == 1) {
                in = in.replace("%" + key + "%", val);
                continue;
            }
            in = in.replace("${" + key + "}", val);
            in = in.replace("$" + key, val);
        }
        return in;
    }

    public static void deleteDirectoryRecursive(String dirPath) throws IOException {
        File dir = new File(dirPath);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String canonicalPath = file.getCanonicalPath();
                    if (file.isFile()) {
                        Files.deleteIfExists(file.toPath());
                    } else {
                        FileUtils.deleteDirectoryRecursive(canonicalPath);
                    }
                    ++n2;
                }
            }
            Files.deleteIfExists(dir.toPath());
        }
    }

    public static List<File> getPathsRecursive(String dirPath) throws IOException {
        LinkedList<File> toCollect = new LinkedList<File>();
        File dir = new File(dirPath);
        if (dir.exists() && dir.isDirectory()) {
            toCollect.add(dir);
            File[] files = dir.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        toCollect.add(file);
                    } else {
                        toCollect.addAll(FileUtils.getPathsRecursive(file.getCanonicalPath()));
                    }
                    ++n2;
                }
            }
        }
        return toCollect;
    }

    public static List<File> getPaths(String dirPath, boolean recursive, String reg) throws IOException {
        File dir;
        LinkedList<File> toCollect = new LinkedList<File>();
        DirFilter filter = null;
        if (reg != null && !reg.isEmpty()) {
            filter = new DirFilter(reg);
        }
        if ((dir = new File(dirPath)).exists()) {
            File[] files;
            File[] fileArray = files = filter == null ? dir.listFiles() : dir.listFiles(filter);
            if (files != null) {
                File[] fileArray2 = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray2[n2];
                    if (file.isFile()) {
                        toCollect.add(file);
                    } else if (!file.isFile() && recursive) {
                        toCollect.addAll(FileUtils.getPaths(file.getCanonicalPath(), recursive, reg));
                    }
                    ++n2;
                }
            }
        }
        return toCollect;
    }

    public static long getFileCreationDate(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File not found : " + file.getName());
        }
        BasicFileAttributes attr = Files.readAttributes(Paths.get(file.toURI()), BasicFileAttributes.class, new LinkOption[0]);
        FileTime fileTime = attr.creationTime();
        return fileTime.toMillis();
    }

    public static String getValidFileName(String name) {
        return name.replaceAll(invalidFileNameChars_regex, "_");
    }

    public static String readFile(File file) throws IOException {
        StringBuilder sb;
        block25: {
            sb = new StringBuilder();
            FileReader fr = null;
            BufferedReader br = null;
            try {
                try {
                    fr = new FileReader(file);
                    br = new BufferedReader(fr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(line);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {}
                }
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (Throwable throwable3) {}
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return sb.toString();
    }

    public static List<String> readFileAsList(File file) throws IOException {
        LinkedList<String> lines;
        block24: {
            lines = new LinkedList<String>();
            FileReader fr = null;
            BufferedReader br = null;
            try {
                try {
                    fr = new FileReader(file);
                    br = new BufferedReader(fr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        lines.add(line);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {}
                }
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (Throwable throwable3) {}
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return lines;
    }

    public static void writeFileAsList(File file, List<String> lines) throws IOException {
        block15: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(file, false);
                    for (String line : lines) {
                        fos.write(line.getBytes());
                        fos.write(10);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void writeFile(File file, String content) throws IOException {
        block14: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(file, false);
                    fos.write(content.getBytes());
                    fos.flush();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

