/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HashMapArray<E, K>
extends HashMap<E, List<K>> {
    private static final long serialVersionUID = 3806544826848172575L;

    public boolean containsValue(E key, K value) {
        List<K> al = this.getArray(key);
        if (al == null) {
            return false;
        }
        return al.contains(value);
    }

    public List<K> getArray(E key) {
        return (List)this.get(key);
    }

    public List<K> putV(E key, K value) {
        List<K> list = this.getArray(key);
        if (list == null) {
            list = new LinkedList<K>();
        }
        if (!list.contains(value)) {
            list.add(value);
        }
        return super.put(key, list);
    }

    @Override
    public List<K> put(E key, List<K> values) {
        List<K> list = this.getArray(key);
        if (list == null) {
            list = values;
        } else {
            list.addAll(values);
        }
        return super.put(key, list);
    }

    public List<K> values(E key) {
        return this.getArray(key);
    }

    public Iterator<K> iterator(E key) {
        List<K> array = this.getArray(key);
        if (array == null) {
            array = new LinkedList<K>();
        }
        return array.iterator();
    }

    public void add(E key) {
        List<K> list = this.getArray(key);
        if (list == null) {
            list = new LinkedList<K>();
            super.put(key, list);
        }
    }
}

