/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.utils.Digest;
import com.blixx.shared.utils.MD5;
import com.blixx.shared.utils.Shabal256;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Formatter;

public class ShabalUtils {
    public static void processDirectory(File dir, Digest algorithm) throws Exception {
        algorithm.update(dir.getName().getBytes());
        File[] list = dir.listFiles();
        int i = 0;
        while (i < list.length) {
            if (list[i].isDirectory()) {
                ShabalUtils.processDirectory(list[i], algorithm);
            } else {
                ShabalUtils.updateDisgest(algorithm, list[i]);
            }
            ++i;
        }
    }

    public static void updateDisgest(Digest algorithm, File file) throws Exception {
        algorithm.update(file.getName().getBytes());
        if (file.length() == 0L) {
            return;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            byte[] arr = new byte[65536];
            int count = -1;
            while ((count = bis.read(arr)) != -1) {
                algorithm.update(arr, 0, count);
            }
        }
        catch (Throwable throwable) {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable3) {}
            }
            throw throwable;
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (Throwable throwable) {}
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static String byteArray2Hex(byte[] hash) {
        Formatter formatter = null;
        String result = null;
        try {
            formatter = new Formatter();
            byte[] byArray = hash;
            int n = hash.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                formatter.format("%02x", b);
                ++n2;
            }
            result = formatter.toString();
        }
        catch (Throwable throwable) {
            if (formatter != null) {
                try {
                    formatter.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (formatter != null) {
            try {
                formatter.close();
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public static String getHex(Digest algorithm) {
        byte[] hash = algorithm.digest();
        return ShabalUtils.byteArray2Hex(hash);
    }

    public static void updateDisgest(Digest algorithm, InputStream is) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] arr = new byte[65536];
        int count = -1;
        while ((count = bis.read(arr)) != -1) {
            algorithm.update(arr, 0, count);
        }
        bis.close();
    }

    public static void updateDisgestKSO(Digest algorithm, InputStream is) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] arr = new byte[65536];
        int count = -1;
        while ((count = bis.read(arr)) != -1) {
            algorithm.update(arr, 0, count);
        }
    }

    public static String getShabal256Hex(File file) throws Exception {
        Shabal256 sh256 = new Shabal256();
        ShabalUtils.updateDisgest((Digest)sh256, file);
        return ShabalUtils.getHex(sh256);
    }

    public static String getShabal256Hex4Dir(File dir) throws Exception {
        Shabal256 sh256 = new Shabal256();
        ShabalUtils.processDirectory(dir, sh256);
        return ShabalUtils.getHex(sh256);
    }

    public static String getMD5Hex(File file) throws Exception {
        MD5 md5 = new MD5();
        ShabalUtils.updateDisgest((Digest)md5, file);
        return ShabalUtils.getHex(md5);
    }

    public static String getMD5Hex4Dir(File dir) throws Exception {
        MD5 md5 = new MD5();
        ShabalUtils.processDirectory(dir, md5);
        return ShabalUtils.getHex(md5);
    }

    public static String getMD5(String data) throws Exception {
        MD5 md5 = new MD5();
        md5.update(data.getBytes());
        return ShabalUtils.getHex(md5);
    }
}

