/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.utils.AStatisticClass;
import com.blixx.shared.utils.EscapeChars;
import com.blixx.shared.utils.IResolveAgentID;
import com.blixx.shared.utils.IResolveConditionID;
import com.blixx.shared.utils.PStatisticClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StatisticManager {
    private Map<String, AStatisticClass> m_agentStats = null;
    private Map<String, PStatisticClass> m_policyStats = null;
    private IResolveAgentID m_agentIdResolver = null;
    private IResolveConditionID m_conditionIdResolver = null;
    private static String DESCENDING = "DESCENDING";
    private EscapeChars m_escapeCharacters = null;
    private List<Character> m_chars2ignore = null;
    private List<Character> m_chars2escape = null;

    public StatisticManager(IResolveAgentID ra, IResolveConditionID rc) {
        this.m_agentIdResolver = ra;
        this.m_conditionIdResolver = rc;
        this.m_escapeCharacters = new EscapeChars();
        this.m_chars2escape = new LinkedList<Character>();
        this.m_chars2escape.add(Character.valueOf('\"'));
        this.m_chars2escape.add(Character.valueOf('\\'));
        this.m_chars2ignore = new LinkedList<Character>();
        this.m_chars2ignore.add(Character.valueOf('\n'));
        this.m_chars2ignore.add(Character.valueOf('\r'));
    }

    public IResolveAgentID getAgentIdResolver() {
        return this.m_agentIdResolver;
    }

    public void setAgentIdResolver(IResolveAgentID mAgentIdResolver) {
        this.m_agentIdResolver = mAgentIdResolver;
    }

    public IResolveConditionID getConditionIdResolver() {
        return this.m_conditionIdResolver;
    }

    public void setConditionIdResolver(IResolveConditionID mConditionIdResolver) {
        this.m_conditionIdResolver = mConditionIdResolver;
    }

    public void addAgentStatistic(Map<String, AStatisticClass> agentStats) {
        this.m_agentStats = agentStats;
    }

    public void addPolicyStatistic(Map<String, PStatisticClass> policyStats) {
        this.m_policyStats = policyStats;
    }

    public AStatisticClass getAgentStats(String agentID) {
        return this.m_agentStats.get(agentID);
    }

    public String getTopAgentsHTML(int topCount, List<String[]> topAgents) {
        StringBuffer sbTopAgents = new StringBuffer();
        sbTopAgents.append("var topAgentsHTML=\"");
        sbTopAgents.append("<table id=TOP_A_TABLE width='100%' border=1 bordercolor='#C0C0C0' rules='groups' cellpadding='2'>");
        sbTopAgents.append("<tbody>").append("<tr align=left valign=center bgcolor='#C0C0C0'>").append("<td  colspan='2'><b>Top ").append(topCount).append(" Agents</b></td>").append("<td colspan='7'><b>Related Indications</b></td>").append("<td rowspan='2'><b>Related<br>Policies</b></td>").append("</tr>");
        sbTopAgents.append("<tr align=left valign=center bgcolor='#C0C0C0'>").append("<td bgcolor='#C0C0C0'><b>ID</b></td>").append("<td bgcolor='#C0C0C0'><b>Agent Name</b></td>").append("<td bgcolor='#C0C0C0'><b>Total</b></td>").append("<td bgcolor='#C0C0C0'><b>Unknown</b></td>").append("<td bgcolor='#A6DF73'><b>Normal</b></td>").append("<td bgcolor='#8BA3C7'><b>Warning</b></td>").append("<td bgcolor='#EFE61E'><b>Minor</b></td>").append("<td bgcolor='#E6AA68'><b>Major</b></td>").append("<td bgcolor='#FF3738'><b>Critical</b></td>").append("</tr>").append("</tbody>");
        sbTopAgents.append("<tfoot>");
        int i = 0;
        while (i < topAgents.size()) {
            String[] param = topAgents.get(i);
            String agentID = param[0];
            String agentName = param[1];
            if (this.m_agentIdResolver != null) {
                agentName = this.m_agentIdResolver.resolve(agentID);
            }
            AStatisticClass aStats = this.m_agentStats.get(agentID);
            int relPolicies = aStats.getPolicyCount();
            int relIndications = aStats.getMessageCount();
            List<Integer> currSevArr = aStats.getSevCountGlobal();
            sbTopAgents.append("<tr valign=top bgcolor='#FFFFFF' ").append("onmouseover='changeRowColorOnMouseOver(this, true), style.cursor=\\\"pointer\\\";' ").append("onmouseout='changeRowColorOnMouseOver(this, false);' ").append("onclick='updateAgentDetails(this);'>").append("<td nowrap='nowrap' align=left>").append(this.m_escapeCharacters.escape(agentID, this.m_chars2escape, this.m_chars2ignore)).append("</td>").append("<td nowrap='nowrap' align=left>").append(this.m_escapeCharacters.escape(agentName, this.m_chars2escape, this.m_chars2ignore)).append("</td>").append("<td nowrap='nowrap' align=right>").append(relIndications).append("</td>").append("<td align=right valign=top>").append("" + currSevArr.get(0)).append("</td>").append("<td align=right valign=top>").append("" + currSevArr.get(1)).append("</td>").append("<td align=right valign=top>").append("" + currSevArr.get(2)).append("</td>").append("<td align=right valign=top>").append("" + currSevArr.get(3)).append("</td>").append("<td align=right valign=top>").append("" + currSevArr.get(4)).append("</td>").append("<td align=right valign=top>").append("" + currSevArr.get(5)).append("</td>").append("<td nowrap='nowrap' align=right>").append(relPolicies).append("</td>").append("</tr>");
            ++i;
        }
        sbTopAgents.append("</tfoot>").append("</table>");
        sbTopAgents.append("\";\n");
        return sbTopAgents.toString();
    }

    public String getAgentDetailsHTML(int topAgtCount, String agentID, String agentName, List<String> topPolicies) {
        StringBuffer sbAgentDetails = new StringBuffer();
        int topPolCount = topPolicies.size();
        AStatisticClass aStats = this.m_agentStats.get(agentID);
        Map<String, List<Integer>> policiesWithSev = aStats.getPoliciesWithSev();
        sbAgentDetails.append("\nvar A").append(topAgtCount).append("=\"");
        String agentLabel = agentName;
        if (agentName == null || agentName.equals("")) {
            agentLabel = agentID;
        }
        sbAgentDetails.append("<br><b>Agent:&nbsp;&nbsp;").append(this.m_escapeCharacters.escape(agentLabel, this.m_chars2escape, this.m_chars2ignore)).append("</b><br><br>");
        sbAgentDetails.append("<table id=A_DETAILS_TABLE width='100%' border=1 bordercolor='#C0C0C0' rules='groups' cellpadding='2'>");
        sbAgentDetails.append("<tbody>").append("<tr align=left valign=center bgcolor='#C0C0C0'>").append("<td rowspan='2'><b>Top ").append(topPolCount).append(" Policies</b></td>").append("<td colspan='7'><b>Related Indications</b></td>").append("<td rowspan='2'><b>Related<br>Conditions</b></td>").append("</tr>");
        sbAgentDetails.append("<tr align=left>").append("<td bgcolor='#C0C0C0'><b>Total</b></td>").append("<td bgcolor='#C0C0C0'><b>Unknown</b></td>").append("<td bgcolor='#A6DF73'><b>Normal</b></td>").append("<td bgcolor='#8BA3C7'><b>Warning</b></td>").append("<td bgcolor='#EFE61E'><b>Minor</b></td>").append("<td bgcolor='#E6AA68'><b>Major</b></td>").append("<td bgcolor='#FF3738'><b>Critical</b></td>").append("</tr>").append("</tbody>");
        sbAgentDetails.append("<tfoot>");
        int i = 0;
        while (i < topPolicies.size()) {
            String policyName = topPolicies.get(i);
            int relIndications = aStats.getMessageCount(policyName);
            List<Integer> severities = policiesWithSev.get(policyName);
            Map<String, Integer> conditions = aStats.getConditions(policyName);
            int relConditions = conditions.size();
            sbAgentDetails.append("<tr>").append("<td align=left valign=top nowrap='nowrap'>").append(this.m_escapeCharacters.escape(policyName, this.m_chars2escape, this.m_chars2ignore)).append("</td>").append("<td align=right valign=top nowrap='nowrap'>").append(relIndications).append("</td>").append("<td align=right valign=top>").append("" + severities.get(0)).append("</td>").append("<td align=right valign=top>").append("" + severities.get(1)).append("</td>").append("<td align=right valign=top>").append("" + severities.get(2)).append("</td>").append("<td align=right valign=top>").append("" + severities.get(3)).append("</td>").append("<td align=right valign=top>").append("" + severities.get(4)).append("</td>").append("<td align=right valign=top>").append("" + severities.get(5)).append("</td>").append("<td align=right valign=top nowrap='nowrap'>").append(relConditions).append("</td>").append("</tr>");
            ++i;
        }
        sbAgentDetails.append("</tfoot>").append("</table>");
        sbAgentDetails.append("\";");
        return sbAgentDetails.toString();
    }

    public String getTopPoliciesHTML(List<String> topPolicies) {
        StringBuffer sbTopPolicies = new StringBuffer();
        int topPolCount = topPolicies.size();
        sbTopPolicies.append("\nvar topPoliciesHTML=\"");
        sbTopPolicies.append("<table id=TOP_P_TABLE width='100%' border=1 bordercolor='#C0C0C0' rules='groups' cellpadding='2'>");
        sbTopPolicies.append("<tbody>").append("<tr align=left valign=center bgcolor='#C0C0C0'>").append("<td rowspan='2'><b>Global Top ").append(topPolCount).append(" Polcies</b></td>").append("<td colspan='7'><b>Related Indications</b></td>").append("<td rowspan='2'><b>Related<br>Conditions</b></td>").append("</tr>");
        sbTopPolicies.append("<tr align=left valign=center bgcolor='#C0C0C0'>").append("<td bgcolor='#C0C0C0'><b>Total</b></td>").append("<td bgcolor='#C0C0C0'><b>Unknown</b></td>").append("<td bgcolor='#A6DF73'><b>Normal</b></td>").append("<td bgcolor='#8BA3C7'><b>Warning</b></td>").append("<td bgcolor='#EFE61E'><b>Minor</b></td>").append("<td bgcolor='#E6AA68'><b>Major</b></td>").append("<td bgcolor='#FF3738'><b>Critical</b></td>").append("</tr>").append("</tbody>");
        sbTopPolicies.append("<tfoot>");
        int i = 0;
        while (i < topPolicies.size()) {
            String policyName = topPolicies.get(i);
            PStatisticClass pStats = this.m_policyStats.get(policyName);
            List<Integer> severities = pStats.getSeverityCount();
            int relIndications = pStats.getMessageCount();
            Map<String, Integer> conditions = pStats.getConditions();
            int relConditions = conditions.size();
            sbTopPolicies.append("<tr valign=top bgcolor='#FFFFFF' ").append("onmouseover='changeRowColorOnMouseOver(this, true), style.cursor=\\\"pointer\\\";' ").append("onmouseout='changeRowColorOnMouseOver(this, false);' ").append("onclick='updatePolicyDetails(this);'>").append("<td align=left valign=top nowrap='nowrap'>").append(this.m_escapeCharacters.escape(policyName, this.m_chars2escape, this.m_chars2ignore)).append("</td>").append("<td align=right valign=top nowrap='nowrap'>").append(relIndications).append("</td>").append("<td align=right valign=top>").append("" + severities.get(0)).append("</td>").append("<td align=right valign=top>").append("" + severities.get(1)).append("</td>").append("<td align=right valign=top>").append("" + severities.get(2)).append("</td>").append("<td align=right valign=top>").append("" + severities.get(3)).append("</td>").append("<td align=right valign=top>").append("" + severities.get(4)).append("</td>").append("<td align=right valign=top>").append("" + severities.get(5)).append("</td>").append("<td align=right valign=top nowrap='nowrap'>").append(relConditions).append("</td>").append("</tr>");
            ++i;
        }
        sbTopPolicies.append("</tfoot>").append("</table>");
        sbTopPolicies.append("\";");
        return sbTopPolicies.toString();
    }

    public String getPolicyDetailsHTML(int index, String polName) {
        StringBuffer sbPoliciesDetails = new StringBuffer();
        sbPoliciesDetails.append("\nvar P").append(index).append("=\"");
        sbPoliciesDetails.append("<br><b>Policy:&nbsp;&nbsp;").append(this.m_escapeCharacters.escape(polName, this.m_chars2escape, this.m_chars2ignore)).append("</b><br><br>");
        sbPoliciesDetails.append("<table id=A_DETAILS_TABLE width='100%' border=1 bordercolor='#C0C0C0' rules='groups' cellpadding='2'>");
        sbPoliciesDetails.append("<tbody>").append("<tr align=left valign=center bgcolor='#C0C0C0'>").append("<td colspan='2'><b>Related Conditions</b></td>").append("<td rowspan='2'><b>Related<br>Indications</b></td>").append("</tr>");
        sbPoliciesDetails.append("<tr align=left valign=center bgcolor='#C0C0C0'>").append("<td><b>ID</b></td>").append("<td><b>Condition Name</b></td>").append("</tr>");
        sbPoliciesDetails.append("</tbody>");
        sbPoliciesDetails.append("</tfoot>");
        PStatisticClass pStats = this.m_policyStats.get(polName);
        Map<String, Integer> conditions = pStats.getConditions();
        List<String> countBySev_sorted = this.sortConditions(conditions, DESCENDING);
        int i = 0;
        while (i < countBySev_sorted.size()) {
            String condID = countBySev_sorted.get(i);
            String condName = "";
            if (this.m_conditionIdResolver != null) {
                condName = this.m_conditionIdResolver.resolve(polName, condID);
            }
            int numOfRelIndications = conditions.get(condID);
            sbPoliciesDetails.append("<tr valign=top bgcolor='#FFFFFF'>").append("<td nowrap='nowrap' align=left>").append(this.m_escapeCharacters.escape(condID, this.m_chars2escape, this.m_chars2ignore)).append("</td>").append("<td nowrap='nowrap' align=left>").append(this.m_escapeCharacters.escape(condName, this.m_chars2escape, this.m_chars2ignore)).append("</td>").append("<td nowrap='nowrap' align=right>").append(numOfRelIndications).append("</tr>");
            ++i;
        }
        sbPoliciesDetails.append("</tfoot>").append("</table>");
        sbPoliciesDetails.append("\";");
        return sbPoliciesDetails.toString();
    }

    private List<String> sortConditions(final Map<String, Integer> map, String sortType) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(map.keySet());
        Collections.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Object v1 = map.get(o1);
                Object v2 = map.get(o2);
                if (v1 == null) {
                    return v2 == null ? 0 : 1;
                }
                if (v1 instanceof Comparable) {
                    return ((Comparable)v1).compareTo(v2);
                }
                return 0;
            }
        });
        if (sortType != null && sortType.equals(DESCENDING)) {
            Collections.reverse(keys);
        }
        return keys;
    }
}

