/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.RTLogger;
import java.util.ArrayList;
import java.util.Arrays;

public class StrUtils {
    public static final char DOUBLEQUOTE_CHAR = '\"';
    public static String SEP = "\u001d\u001e\u001f";

    public String[] processQuoted(String cmd) {
        if (cmd == null) {
            return new String[0];
        }
        cmd = cmd.replace("\r", "");
        String[] inCMD = null;
        if (cmd.indexOf(SEP) != -1) {
            inCMD = cmd.split("(" + SEP + ")+");
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, "v2 recon: " + Arrays.asList(inCMD));
            }
            return inCMD;
        }
        if (cmd.indexOf(34) != -1) {
            inCMD = cmd.split(" {1}");
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, "v2 recon: " + Arrays.asList(inCMD));
            }
            ArrayList<String> params = new ArrayList<String>(inCMD.length);
            boolean quoteStarted = false;
            String quoted = null;
            int i = 0;
            while (i < inCMD.length) {
                String el;
                int firstQ = inCMD[i].indexOf("\"");
                int lastQ = inCMD[i].lastIndexOf("\"");
                if (!quoteStarted && firstQ != -1 && firstQ == lastQ) {
                    quoteStarted = true;
                    quoted = String.valueOf(inCMD[i]) + " ";
                } else if (quoteStarted && inCMD[i].endsWith("\\\"")) {
                    quoted = String.valueOf(quoted) + inCMD[i] + " ";
                } else if (quoteStarted && !inCMD[i].endsWith("\"")) {
                    quoted = String.valueOf(quoted) + inCMD[i] + " ";
                } else if (quoteStarted && inCMD[i].endsWith("\"")) {
                    quoted = String.valueOf(quoted) + inCMD[i];
                    quoteStarted = false;
                    el = quoted.replace("\\\"", "\"");
                    params.add(el);
                    quoted = null;
                } else {
                    el = inCMD[i].replace("\\\"", "\"");
                    if (!el.equals("")) {
                        params.add(el);
                    }
                }
                ++i;
            }
            if (quoted != null && !quoted.equals("")) {
                params.add(quoted.replace("\\\"", "\""));
            }
            inCMD = params.toArray(new String[0]);
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, "msg recon: " + params);
            }
        } else {
            inCMD = cmd.split(" +");
        }
        return inCMD;
    }

    public String[] processQuoted(String cmd, char splitChar) {
        if (cmd == null) {
            return new String[0];
        }
        cmd = cmd.replace("\r", "");
        String[] inCMD = null;
        if (cmd.indexOf(34) != -1) {
            inCMD = cmd.split(String.valueOf(splitChar) + "{1}");
            ArrayList<String> params = new ArrayList<String>(inCMD.length);
            boolean quoteStarted = false;
            String quoted = null;
            int i = 0;
            while (i < inCMD.length) {
                String el;
                int firstQ = inCMD[i].indexOf("\"");
                int lastQ = inCMD[i].lastIndexOf("\"");
                if (!quoteStarted && firstQ != -1 && firstQ == lastQ) {
                    quoteStarted = true;
                    quoted = String.valueOf(inCMD[i]) + splitChar;
                } else if (quoteStarted && inCMD[i].endsWith("\\\"")) {
                    quoted = String.valueOf(quoted) + inCMD[i] + splitChar;
                } else if (quoteStarted && !inCMD[i].endsWith("\"")) {
                    quoted = String.valueOf(quoted) + inCMD[i] + splitChar;
                } else if (quoteStarted && inCMD[i].endsWith("\"")) {
                    quoted = String.valueOf(quoted) + inCMD[i];
                    quoteStarted = false;
                    el = quoted.replace("\\\"", "\"");
                    params.add(el);
                    quoted = null;
                } else {
                    el = inCMD[i].replace("\\\"", "\"");
                    params.add(el);
                }
                ++i;
            }
            if (quoted != null) {
                params.add(quoted.replace("\\\"", "\""));
            }
            inCMD = params.toArray(new String[0]);
        } else {
            inCMD = cmd.split(String.valueOf(splitChar) + "{1}");
        }
        return inCMD;
    }

    public String removeQuotes(String in) {
        if (in != null) {
            if (in.length() > 0 && in.charAt(0) == '\"') {
                in = in.substring(1);
            }
            if (in.endsWith("\"")) {
                in = in.substring(0, in.length() - 1);
            }
        }
        return in;
    }

    public String removeQuotesStrict(String in) {
        if (in != null && in.startsWith("\"") && in.endsWith("\"")) {
            in = in.substring(1, in.length() - 1);
        }
        return in;
    }

    public String removeQuotesStrict(StringBuffer in) {
        if (in == null) {
            return null;
        }
        if (in.length() > 1 && in.charAt(0) == '\"' && in.charAt(in.length() - 1) == '\"') {
            in = in.deleteCharAt(0);
            in = in.deleteCharAt(in.length() - 1);
        }
        return in.toString();
    }

    public String removeQuotesStrict(StringBuilder in) {
        if (in == null) {
            return null;
        }
        if (in.length() > 1 && in.charAt(0) == '\"' && in.charAt(in.length() - 1) == '\"') {
            in = in.deleteCharAt(0);
            in = in.deleteCharAt(in.length() - 1);
        }
        return in.toString();
    }

    public String[] split(String input, char character) {
        if (input == null) {
            return new String[0];
        }
        String[] res = new String[]{};
        if (input != null) {
            res = input.split("(?<![\\\\])(?:[" + character + "])");
            int i = 0;
            while (i < res.length) {
                res[i] = res[i].replace("\\" + character, "" + character).trim();
                ++i;
            }
        }
        return res;
    }

    public String[] split(String input, String separators) {
        if (input == null) {
            return null;
        }
        ArrayList<String> arr = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean isDQ = false;
        int i = 0;
        while (i < input.length()) {
            if (!isDQ && separators.indexOf(input.charAt(i)) != -1) {
                arr.add(sb.toString());
                sb = new StringBuilder();
            } else if (input.charAt(i) == '\\') {
                if (i < input.length() - 1) {
                    sb.append(input.charAt(++i));
                } else {
                    sb.append('\\');
                }
            } else {
                if (input.charAt(i) == '\"') {
                    isDQ = !isDQ;
                }
                sb.append(input.charAt(i));
            }
            ++i;
        }
        arr.add(sb.toString());
        return arr.toArray(new String[0]);
    }

    public static boolean areStringEquals(String val1, String val2) {
        return val1 == null ? val2 == null : val1.equals(val2);
    }
}

