/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.RTLogger;
import com.blixx.shared.SecureDocumentBuilderFactory;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLTree {
    public static String GROUP = "GROUP";
    public static String ELEMENT = "ELEMENT";
    public static String NAME = "name";
    public static String TYPE = "type";
    public static String LINK = "link";
    public static String VALUE = "value";
    public static String OID = "oid";
    public static Map<String, String> m_fixedAttributes = new HashMap<String, String>();

    static {
        m_fixedAttributes.put(NAME, NAME);
        m_fixedAttributes.put(TYPE, TYPE);
        m_fixedAttributes.put(LINK, LINK);
        m_fixedAttributes.put(VALUE, VALUE);
        m_fixedAttributes.put(OID, OID);
    }

    @Deprecated
    public GroupTreeObject parseXML(InputStream io) {
        return this.parseXML(io, false);
    }

    @Deprecated
    public GroupTreeObject parseXMLStrict(InputStream io) {
        return this.parseXML(io, false);
    }

    public GroupTreeObject parseXML(InputStream io, boolean includeAttributes) {
        GroupTreeObject root = new GroupTreeObject(new TreeObject("root", "", null));
        try {
            this.parse(io, root, includeAttributes);
        }
        catch (Throwable e) {
            RTLogger.print(6, "Error parsing xml file: " + e.getMessage());
            RTLogger.print(2, "", e);
            throw new RuntimeException(e);
        }
        return root;
    }

    protected void parse(InputStream io, GroupTreeObject root, boolean includeAttributes) throws SAXException, IOException, ParserConfigurationException {
        Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(io);
        Element top = doc.getDocumentElement();
        String type = XMLFactory.unescape(top.getAttribute(TYPE));
        if (type == null) {
            type = "";
        }
        String obj = XMLFactory.unescape(top.getAttribute(VALUE));
        TreeObject treeObject = new TreeObject(XMLFactory.unescape(top.getAttribute(NAME)), type, obj);
        try {
            treeObject.setOID(XMLFactory.unescape(top.getAttribute(OID)));
        }
        catch (Throwable throwable) {}
        GroupTreeObject groupTO = new GroupTreeObject(treeObject);
        if (includeAttributes) {
            this.processAttributes(top, groupTO);
        }
        root.addElement(groupTO);
        this.processElement(top, groupTO, includeAttributes);
    }

    protected void processElement(Element top, GroupTreeObject groupTO, boolean includeAttributes) {
        NodeList nl = top.getChildNodes();
        int length = nl.getLength();
        groupTO.ensureCapacity(length);
        int i = 0;
        while (i < length) {
            Node item = nl.item(i);
            if (item instanceof Element) {
                Element itemAsElement = (Element)item;
                String node = item.getNodeName();
                if (node.equals(GROUP)) {
                    String nameF = XMLFactory.unescape(itemAsElement.getAttribute(NAME));
                    String typeF = XMLFactory.unescape(itemAsElement.getAttribute(TYPE));
                    if (typeF == null) {
                        typeF = "";
                    }
                    String obj = XMLFactory.unescape(itemAsElement.getAttribute(VALUE));
                    TreeObject treeObject = new TreeObject(nameF, typeF, obj);
                    try {
                        treeObject.setOID(XMLFactory.unescape(itemAsElement.getAttribute(OID)));
                    }
                    catch (Throwable throwable) {}
                    GroupTreeObject gto = new GroupTreeObject(treeObject);
                    if (includeAttributes) {
                        this.processAttributes(itemAsElement, gto);
                    }
                    groupTO.addElementNoSorting(gto);
                    this.processElement(itemAsElement, gto, includeAttributes);
                } else {
                    NamedNodeMap nnm = item.getAttributes();
                    if (nnm != null) {
                        String nameItem = XMLFactory.unescape(itemAsElement.getAttribute(NAME));
                        String typeItem = XMLFactory.unescape(itemAsElement.getAttribute(TYPE));
                        String linkItem = null;
                        String link = XMLFactory.unescape(itemAsElement.getAttribute(LINK));
                        if (link != null && (linkItem = link).trim().length() == 0) {
                            linkItem = null;
                        }
                        String obj = XMLFactory.unescape(itemAsElement.getAttribute(VALUE));
                        TreeObject to = new TreeObject(nameItem, typeItem, obj);
                        try {
                            to.setOID(XMLFactory.unescape(itemAsElement.getAttribute(OID)));
                        }
                        catch (Throwable throwable) {}
                        String icon = null;
                        if (typeItem.equals("mon")) {
                            icon = "IMAGE_MON";
                            if (linkItem != null) {
                                icon = "IMAGE_MON_LNK";
                            }
                        } else if (typeItem.equals("msg")) {
                            icon = "IMAGE_MSG";
                            if (linkItem != null) {
                                icon = "IMAGE_MSG_LNK";
                            }
                        } else if (typeItem.equals("pkg")) {
                            icon = "pkg";
                            if (linkItem != null) {
                                icon = "IMAGE_PKG_LNK";
                            }
                        }
                        GroupTreeObjectLast gtol = new GroupTreeObjectLast(to, linkItem, icon);
                        if (includeAttributes) {
                            this.processAttributes(itemAsElement, gtol);
                        }
                        groupTO.addElementNoSortingNoChecking(gtol);
                    }
                }
            }
            ++i;
        }
    }

    private void processAttributes(Element itemAsElement, GroupTreeObject gto) {
        NamedNodeMap nnm = itemAsElement.getAttributes();
        int ai = 0;
        while (ai < nnm.getLength()) {
            Attr attr = (Attr)nnm.item(ai);
            String attrName = XMLFactory.unescape(attr.getNodeName());
            String attrValue = XMLFactory.unescape(attr.getNodeValue());
            if (!m_fixedAttributes.containsKey(attrName)) {
                gto.setAttribute(attrName, attrValue);
            }
            ++ai;
        }
    }

    public Document getXML(GroupTreeObject root) {
        return this.getXML(root, false);
    }

    public Document getXML(GroupTreeObject root, boolean includeAttributes) {
        Document doc = null;
        try {
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            List<GroupTreeObject> al = root.getElements();
            int i = 0;
            while (i < al.size()) {
                this.createElement(doc, null, al.get(i), includeAttributes);
                ++i;
            }
        }
        catch (Throwable e) {
            RTLogger.print(2, "XML create Doc error. ", e);
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        return doc;
    }

    protected Element createElement(Document doc, Node top, GroupTreeObject gto, boolean includeAttributes) {
        Element el = null;
        if (!(gto instanceof GroupTreeObjectLast)) {
            Map<String, String> attributes;
            String oid;
            el = doc.createElement(GROUP);
            el.setAttribute(NAME, XMLFactory.escape(gto.getName()));
            if (top == null) {
                doc.appendChild(el);
            } else {
                top.appendChild(el);
            }
            String type2 = gto.getTreeObject().getType();
            if (type2 != null) {
                el.setAttribute(TYPE, XMLFactory.escape(type2));
            } else {
                el.setAttribute(TYPE, XMLFactory.escape(""));
            }
            Object obj = gto.getTreeObject().getObject();
            if (obj != null && obj instanceof String) {
                el.setAttribute(VALUE, XMLFactory.escape(obj));
            }
            if ((oid = gto.getTreeObject().getOID()) != null && oid.length() > 0) {
                el.setAttribute(OID, XMLFactory.escape(oid));
            }
            if ((attributes = gto.getAttributes()) != null) {
                for (Map.Entry<String, String> en : attributes.entrySet()) {
                    el.setAttribute(en.getKey(), XMLFactory.escape(en.getValue()));
                }
            }
            if (gto.getIcon() != null && gto.getIcon().length() > 0) {
                el.setAttribute("GTOICON", XMLFactory.escape(gto.getIcon()));
            }
            List<GroupTreeObject> al = gto.getElements();
            int i = 0;
            while (i < al.size()) {
                this.createElement(doc, el, al.get(i), includeAttributes);
                ++i;
            }
        } else {
            Map<String, String> attributes;
            String oid;
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
            el = doc.createElement(ELEMENT);
            Object obj = gtol.getTreeObject().getObject();
            el.setAttribute(NAME, XMLFactory.escape(gtol.getName()));
            el.setAttribute(TYPE, XMLFactory.escape(gtol.getTreeObject().getType()));
            String link = gtol.getLinkedPath();
            if (link != null) {
                el.setAttribute(LINK, XMLFactory.escape(link));
            }
            if (obj != null && (obj instanceof String || obj instanceof ITreeObject) && !gtol.getName().equals(obj.toString())) {
                el.setAttribute(VALUE, XMLFactory.escape(obj.toString()));
            }
            if ((oid = gtol.getTreeObject().getOID()) != null && oid.length() > 0) {
                el.setAttribute(OID, XMLFactory.escape(oid));
            }
            if ((attributes = gto.getAttributes()) != null) {
                for (Map.Entry<String, String> en : attributes.entrySet()) {
                    el.setAttribute(en.getKey(), XMLFactory.escape(en.getValue()));
                }
            }
            if (gto.getIcon() != null && gto.getIcon().length() > 0) {
                el.setAttribute("GTOICON", XMLFactory.escape(gto.getIcon()));
            }
            if (top == null) {
                doc.appendChild(el);
            } else {
                top.appendChild(el);
            }
        }
        return el;
    }
}

