/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.RTLogger;
import com.blixx.shared.exceptions.LockedFileException;
import com.blixx.shared.utils.AsfUtils;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.zip.ZipEntry;
import com.blixx.shared.zip.ZipFile;
import com.blixx.shared.zip.ZipOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZIP {
    public static final String DIRECTORY_IS_EMPTY = "Directory is empty";
    protected List<Pattern> exceptMasks = new ArrayList<Pattern>();
    protected String specificAgentID = null;
    protected boolean isSpecificFound = false;

    public void addExceptionMask(String mask) {
        mask = mask.replace(".", "\\.");
        mask = mask.replace("*", ".*");
        mask = mask.replace("?", ".");
        Pattern p = Pattern.compile(mask);
        this.exceptMasks.add(p);
    }

    public void cleanExceptions() {
        this.exceptMasks.clear();
    }

    public void zipAgent(String sourcePath, String targetZipPath, File agent, File conf) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(targetZipPath);
            zos = new ZipOutputStream(fos);
            sourcePath = sourcePath.replace('\\', File.separatorChar);
            sourcePath = sourcePath.replace('/', File.separatorChar);
            if (sourcePath.endsWith(File.separator)) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            this.zipFile(zos, agent, String.valueOf(agent.getParentFile().getPath()) + File.separatorChar);
            ZipEntry anEntry = new ZipEntry("conf/");
            anEntry.setUnixMode(16877);
            zos.putNextEntry(anEntry);
            this.zipAgent(zos, "conf/", conf);
            String zipRootPath = String.valueOf(sourcePath) + File.separatorChar;
            try {
                this.zipDir(sourcePath, zos, zipRootPath);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (Throwable throwable) {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Throwable throwable2) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable3) {}
            }
            throw throwable;
        }
        if (zos != null) {
            try {
                zos.close();
            }
            catch (Throwable throwable) {}
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void zipDir(String sourcePath, String targetZipPath) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(targetZipPath);
            zos = new ZipOutputStream(fos);
            sourcePath = sourcePath.replace('\\', File.separatorChar);
            sourcePath = sourcePath.replace('/', File.separatorChar);
            if (sourcePath.endsWith(File.separator)) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            String zipRootPath = String.valueOf(sourcePath) + File.separator;
            this.zipDir(sourcePath, zos, zipRootPath);
        }
        catch (Throwable throwable) {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Throwable throwable2) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable3) {}
            }
            throw throwable;
        }
        if (zos != null) {
            try {
                zos.close();
            }
            catch (Throwable throwable) {}
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void zipDir(String sourcePath, List<String> onlySubDirs, String targetZipPath) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(targetZipPath);
            zos = new ZipOutputStream(fos);
            sourcePath = sourcePath.replace('\\', File.separatorChar);
            sourcePath = sourcePath.replace('/', File.separatorChar);
            if (sourcePath.endsWith(File.separator)) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            String zipRootPath = String.valueOf(sourcePath) + File.separator;
            int i = 0;
            while (i < onlySubDirs.size()) {
                File f = new File(sourcePath, onlySubDirs.get(i));
                if (f.exists() && f.isDirectory()) {
                    String filePath = f.getPath();
                    String zipPath = f.getPath().replace(zipRootPath, "");
                    ZipEntry anEntry = new ZipEntry(String.valueOf(zipPath) + "/");
                    anEntry.setUnixMode(16877);
                    zos.putNextEntry(anEntry);
                    try {
                        this.zipDir(filePath, zos, zipRootPath);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Throwable throwable2) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable3) {}
            }
            throw throwable;
        }
        if (zos != null) {
            try {
                zos.close();
            }
            catch (Throwable throwable) {}
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void zipDirZero(String sourcePath, String targetZipPath) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(targetZipPath);
            zos = new ZipOutputStream(fos);
            sourcePath = sourcePath.replace('\\', File.separatorChar);
            sourcePath = sourcePath.replace('/', File.separatorChar);
            if (sourcePath.endsWith(File.separator)) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            String zipRootPath = String.valueOf(sourcePath) + File.separator;
            this.zipDir(sourcePath, zos, zipRootPath);
        }
        catch (Throwable throwable) {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Throwable throwable2) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable3) {}
            }
            throw throwable;
        }
        if (zos != null) {
            try {
                zos.close();
            }
            catch (Throwable throwable) {}
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void zipDirZero(String dir2zip, ZipOutputStream zos, String zipRootPath) throws FileNotFoundException, IOException {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        int i = 0;
        while (i < dirList.length) {
            block5: {
                File f;
                block6: {
                    block4: {
                        f = new File(zipDir, dirList[i]);
                        if (!f.isDirectory()) break block4;
                        String filePath = f.getPath();
                        String zipPath = f.getPath().replace(zipRootPath, "");
                        ZipEntry anEntry = new ZipEntry(String.valueOf(zipPath) + "/");
                        anEntry.setUnixMode(16877);
                        zos.putNextEntry(anEntry);
                        this.zipDirZero(filePath, zos, zipRootPath);
                        break block5;
                    }
                    if (this.exceptMasks.size() <= 0) break block6;
                    boolean toSkip = false;
                    for (Pattern p : this.exceptMasks) {
                        String cpath;
                        Matcher m = p.matcher(cpath = f.getCanonicalPath());
                        if (!m.matches()) continue;
                        toSkip = true;
                        RTLogger.print(4, "Skipped zipping file: " + cpath);
                        break;
                    }
                    if (toSkip) break block5;
                }
                this.zipFileZero(zos, f, zipRootPath);
            }
            ++i;
        }
    }

    public void zipDir(String dir2zip, ZipOutputStream zos, String zipRootPath) throws FileNotFoundException, IOException {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        if (dirList.length == 0) {
            throw new FileNotFoundException("Directory is empty {" + dir2zip + "}");
        }
        int i = 0;
        while (i < dirList.length) {
            block9: {
                File f;
                block10: {
                    block8: {
                        f = new File(zipDir, dirList[i]);
                        if (!f.isDirectory()) break block8;
                        String filePath = f.getPath();
                        String zipPath = f.getPath().replace(zipRootPath, "");
                        ZipEntry anEntry = new ZipEntry(String.valueOf(zipPath) + "/");
                        anEntry.setUnixMode(16877);
                        zos.putNextEntry(anEntry);
                        try {
                            this.zipDir(filePath, zos, zipRootPath);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                        break block9;
                    }
                    if (this.exceptMasks.isEmpty()) break block10;
                    boolean toSkip = false;
                    for (Pattern p : this.exceptMasks) {
                        String cpath;
                        Matcher m = p.matcher(cpath = f.getCanonicalPath());
                        if (!m.matches()) continue;
                        toSkip = true;
                        RTLogger.print(4, "Skipped zipping file: " + cpath);
                        break;
                    }
                    if (toSkip) break block9;
                }
                this.zipFile(zos, f, zipRootPath);
            }
            ++i;
        }
    }

    public void zipFile(ZipOutputStream zos, File f, String rootPath) throws FileNotFoundException, IOException {
        byte[] readBuffer = new byte[2048];
        int bytesIn = 0;
        InputStream fis = null;
        try {
            String zipPath = f.getPath().replace(rootPath, "");
            zipPath = zipPath.replace('\\', '/');
            ZipEntry anEntry = new ZipEntry(zipPath);
            zos.putNextEntry(anEntry);
            if (this.isForceAgentSpecificFilesProcessing() && f.getName().toLowerCase().endsWith(".asf")) {
                String data = AsfUtils.getAgentSpecificJson(f, this.specificAgentID);
                if (data == null) {
                    fis = new FileInputStream(f);
                } else {
                    fis = new ByteArrayInputStream(data.getBytes());
                    this.isSpecificFound = true;
                }
            } else {
                fis = new FileInputStream(f);
            }
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
        }
        catch (Throwable throwable) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void zipFileZero(ZipOutputStream zos, File f, String rootPath) throws FileNotFoundException, IOException {
        String zipPath = f.getPath().replace(rootPath, "");
        ZipEntry anEntry = new ZipEntry(zipPath);
        zos.putNextEntry(anEntry);
    }

    public void zipAgent(ZipOutputStream zos, String zipPath, File f) throws FileNotFoundException, IOException {
        byte[] readBuffer = new byte[2048];
        int bytesIn = 0;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            if (!zipPath.endsWith("/")) {
                zipPath = String.valueOf(zipPath) + "/";
            }
            zipPath = zipPath.replace('\\', '/');
            ZipEntry anEntry = new ZipEntry(String.valueOf(zipPath) + f.getName());
            zos.putNextEntry(anEntry);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
        }
        catch (Throwable throwable) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public List<String> unzip(String zipfile, String targetDir) throws IOException, LockedFileException {
        LinkedList<String> result = new LinkedList<String>();
        File targetD = new File(targetDir);
        if (!targetD.exists()) {
            targetD.mkdirs();
        }
        ZipFile zipFile = new ZipFile(zipfile);
        try {
            String name;
            ZipEntry entry;
            Enumeration<ZipEntry> entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                name = entry.getName();
                name = name.replace('\\', File.separatorChar);
                String parent = new File(name = name.replace('/', File.separatorChar)).getParent();
                if (parent != null) {
                    new File(targetD, parent).mkdirs();
                }
                if (!entry.isDirectory()) continue;
                name = name.replace('\\', File.separatorChar);
                File dir = new File(targetD, name = name.replace('/', File.separatorChar));
                if (dir.exists()) continue;
                dir.mkdirs();
            }
            entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                File nf;
                block30: {
                    entry = entries.nextElement();
                    name = entry.getName();
                    name = name.replace('\\', File.separatorChar);
                    name = name.replace('/', File.separatorChar);
                    if (entry.isDirectory()) {
                        File dir = new File(targetD, name);
                        if (!dir.exists()) {
                            dir.mkdirs();
                        } else if (dir.isFile()) {
                            dir.delete();
                            dir.mkdirs();
                        }
                        result.add(dir.getCanonicalPath());
                        continue;
                    }
                    nf = new File(targetD, name);
                    if (nf.isDirectory()) {
                        FileUtils.deleteDirectoryRecursive(nf.getCanonicalPath());
                    }
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(nf, false);
                    }
                    catch (Throwable e) {
                        throw new LockedFileException(e);
                    }
                    try {
                        try {
                            this.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(fileOutputStream));
                        }
                        catch (Throwable throwable) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Throwable throwable2) {}
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Throwable throwable3) {}
                        throw throwable;
                    }
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
                result.add(nf.getCanonicalPath());
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable4) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public void deleteFilesExcept(List<String> canonical_names, String rootDir) {
        File targetD = new File(rootDir);
        if (targetD.exists() && targetD.isDirectory()) {
            File[] list = targetD.listFiles();
            int i = 0;
            while (i < list.length) {
                block9: {
                    try {
                        String cname = list[i].getCanonicalPath();
                        if (list[i].isDirectory()) {
                            this.deleteFilesExcept(canonical_names, cname);
                            File[] rest = list[i].listFiles();
                            if (rest != null && rest.length == 0 && !canonical_names.contains(cname)) {
                                list[i].delete();
                            }
                            break block9;
                        }
                        if (canonical_names.contains(cname)) break block9;
                        if (!this.exceptMasks.isEmpty()) {
                            boolean toSkip = false;
                            for (Pattern p : this.exceptMasks) {
                                String cpath;
                                Matcher m = p.matcher(cpath = list[i].getCanonicalPath());
                                if (!m.matches()) continue;
                                toSkip = true;
                                break;
                            }
                            if (toSkip) break block9;
                        }
                        list[i].delete();
                    }
                    catch (Throwable throwable) {
                        RTLogger.print(3, "Can't delete file: " + list[i].getName());
                    }
                }
                ++i;
            }
        }
    }

    private synchronized void copyInputStream(InputStream in, OutputStream out) throws IOException {
        try {
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable throwable3) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean isForceAgentSpecificFilesProcessing() {
        return this.specificAgentID != null;
    }

    public void setForceAgentSpecificFilesProcessing(String agentID) {
        this.specificAgentID = agentID;
        this.isSpecificFound = false;
    }

    public boolean isAgentSpecificFileFound() {
        return this.isSpecificFound;
    }
}

