/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.ArrayList;
import java.util.HashMap;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;

class MibAnalyzerUtil {
    private static HashMap commentTokens = new HashMap();

    MibAnalyzerUtil() {
    }

    static boolean isBitValue(Node node) {
        if (node.getId() == 1004) {
            return true;
        }
        if (node.getId() == 2079 && node.getChildCount() < 4) {
            return true;
        }
        int i = 0;
        while (i < node.getChildCount()) {
            if (MibAnalyzerUtil.isBitValue(node.getChildAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static String getComments(Node node) {
        Token token;
        String comment = "";
        String str = MibAnalyzerUtil.getCommentsBefore(node);
        if (str != null) {
            comment = str;
        }
        if ((str = MibAnalyzerUtil.getCommentsInside(node)) != null) {
            if (comment.length() > 0) {
                comment = String.valueOf(comment) + "\n\n";
            }
            comment = String.valueOf(comment) + str;
        }
        if ((token = MibAnalyzerUtil.getCommentTokenSameLine(node)) != null) {
            if (comment.length() > 0) {
                comment = String.valueOf(comment) + "\n\n";
            }
            token = token.getPreviousToken();
            comment = String.valueOf(comment) + MibAnalyzerUtil.getCommentsAfter((Node)token);
        }
        return comment.length() <= 0 ? null : comment;
    }

    static String getCommentsFooter(Node node) {
        String comment = MibAnalyzerUtil.getCommentsAfter(node);
        commentTokens.clear();
        return comment;
    }

    private static String getCommentsBefore(Node node) {
        Token token = MibAnalyzerUtil.getFirstToken(node);
        ArrayList<String> comments = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        String res = "";
        if (token != null) {
            token = token.getPreviousToken();
        }
        while (token != null) {
            if (token.getId() == 1106) {
                comments.add(MibAnalyzerUtil.getLineBreaks(token.getImage()));
            } else {
                if (token.getId() != 1107 || commentTokens.containsKey(token)) break;
                commentTokens.put(token, null);
                comments.add(token.getImage().substring(2).trim());
            }
            token = token.getPreviousToken();
        }
        int i = comments.size() - 1;
        while (i >= 0) {
            buffer.append(comments.get(i));
            --i;
        }
        res = buffer.toString().trim();
        return res.length() <= 0 ? null : res;
    }

    private static String getCommentsAfter(Node node) {
        String res;
        Token token = MibAnalyzerUtil.getLastToken(node);
        StringBuffer comment = new StringBuffer();
        if (token != null) {
            token = token.getNextToken();
        }
        while (token != null) {
            if (token.getId() == 1106) {
                comment.append(MibAnalyzerUtil.getLineBreaks(token.getImage()));
            } else {
                if (token.getId() != 1107 || commentTokens.containsKey(token)) break;
                commentTokens.put(token, null);
                comment.append(token.getImage().substring(2).trim());
            }
            token = token.getNextToken();
        }
        return (res = comment.toString().trim()).length() <= 0 ? null : res;
    }

    private static String getCommentsInside(Node node) {
        Token token = MibAnalyzerUtil.getFirstToken(node);
        Token last = MibAnalyzerUtil.getLastToken(node);
        StringBuffer comment = new StringBuffer();
        while (token != null && token != last) {
            if (token.getId() == 1107 && !commentTokens.containsKey(token)) {
                commentTokens.put(token, null);
                comment.append(token.getImage().substring(2).trim());
                comment.append("\n");
            }
            token = token.getNextToken();
        }
        String res = comment.toString().trim();
        return res.length() <= 0 ? null : res;
    }

    private static Token getCommentTokenSameLine(Node node) {
        Token last = MibAnalyzerUtil.getLastToken(node);
        if (last == null) {
            return null;
        }
        Token token = last.getNextToken();
        while (token != null) {
            switch (token.getId()) {
                case 1004: 
                case 1106: {
                    break;
                }
                case 1107: {
                    if (last.getEndLine() == token.getStartLine()) {
                        return token;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            token = token.getNextToken();
        }
        return null;
    }

    private static Token getFirstToken(Node node) {
        while (node instanceof Production) {
            node = node.getChildAt(0);
        }
        return (Token)node;
    }

    private static Token getLastToken(Node node) {
        while (node instanceof Production) {
            node = node.getChildAt(node.getChildCount() - 1);
        }
        return (Token)node;
    }

    private static String getLineBreaks(String str) {
        StringBuffer res = new StringBuffer();
        if (str == null) {
            return null;
        }
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\n') {
                res.append('\n');
            }
            ++i;
        }
        return res.toString();
    }
}

