/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MibDirectoryCache {
    private static final Pattern NAME = Pattern.compile("[a-zA-Z][a-zA-Z0-9-_]*");
    private File dir;
    private HashMap nameCache = null;
    private HashMap contentCache = null;

    public MibDirectoryCache(File dir) {
        this.dir = dir;
    }

    public File getDir() {
        return this.dir;
    }

    public File findByName(String mibName) {
        if (this.nameCache == null) {
            this.initNameCache();
        }
        return (File)this.nameCache.get(mibName.toUpperCase());
    }

    private void initNameCache() {
        File[] files = this.dir.listFiles();
        this.nameCache = new HashMap();
        int i = 0;
        while (files != null && i < files.length) {
            String name = files[i].getName();
            Matcher m = NAME.matcher(name);
            if (m.lookingAt() && files[i].isFile()) {
                this.nameCache.put(m.group().toUpperCase(), files[i]);
            }
            ++i;
        }
    }

    public File findByContent(String mibName) {
        if (this.contentCache == null) {
            this.initContentCache();
        }
        return (File)this.contentCache.get(mibName);
    }

    private void initContentCache() {
        File[] files = this.dir.listFiles();
        this.contentCache = new HashMap();
        int i = 0;
        while (i < files.length) {
            String name = this.readMibName(files[i]);
            if (name != null) {
                this.contentCache.put(name, files[i]);
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readMibName(File file) {
        String string;
        BufferedReader in = null;
        if (!file.canRead()) return null;
        if (!file.isFile()) {
            return null;
        }
        try {
            String str;
            in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                if ((str = str.trim()).equals("") || str.startsWith("--")) continue;
                Matcher m = NAME.matcher(str);
                String string2 = string = m.lookingAt() ? m.group() : null;
                if (in == null) return string;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (in == null) return null;
            try {
                in.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (IOException iOException) {
            if (in == null) return null;
            {
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
            }
            try {
                in.close();
                return null;
            }
            catch (IOException iOException3) {}
            return null;
        }
        {
            try {
                in.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
            break;
        }
        if (in == null) return null;
        try {
            in.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }
}

