/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.mibble.DefaultContext;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibAnalyzer;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibDirectoryCache;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.asn1.Asn1Parser;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibLoader {
    private ArrayList dirCaches = new ArrayList();
    private ArrayList resources = new ArrayList();
    private ArrayList mibs = new ArrayList();
    private ArrayList queue = new ArrayList();
    private DefaultContext context = new DefaultContext();

    public MibLoader() {
        this.addResourceDir("mibs/iana");
        this.addResourceDir("mibs/ietf");
    }

    public boolean hasDir(File dir) {
        if (dir == null) {
            dir = new File(".");
        } else if (!dir.isDirectory()) {
            dir = dir.getParentFile();
        }
        int i = 0;
        while (i < this.dirCaches.size()) {
            MibDirectoryCache cache = (MibDirectoryCache)this.dirCaches.get(i);
            if (cache.getDir().equals(dir)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public File[] getDirs() {
        File[] res = new File[this.dirCaches.size()];
        int i = 0;
        while (i < this.dirCaches.size()) {
            MibDirectoryCache cache = (MibDirectoryCache)this.dirCaches.get(i);
            res[i] = cache.getDir();
            ++i;
        }
        return res;
    }

    public void addDir(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        if (!this.hasDir(dir) && dir.isDirectory()) {
            this.dirCaches.add(new MibDirectoryCache(dir));
        }
    }

    public void addDirs(File[] dirs) {
        int i = 0;
        while (i < dirs.length) {
            this.addDir(dirs[i]);
            ++i;
        }
    }

    public void addAllDirs(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        this.addDir(dir);
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.addAllDirs(files[i]);
            }
            ++i;
        }
    }

    public void removeDir(File dir) {
        int i = 0;
        while (i < this.dirCaches.size()) {
            MibDirectoryCache cache = (MibDirectoryCache)this.dirCaches.get(i);
            if (cache.getDir().equals(dir)) {
                this.dirCaches.remove(i--);
            }
            ++i;
        }
    }

    public void removeAllDirs() {
        this.dirCaches.clear();
    }

    public boolean hasResourceDir(String dir) {
        return this.resources.contains(dir);
    }

    public String[] getResourceDirs() {
        return this.resources.toArray(new String[this.resources.size()]);
    }

    public void addResourceDir(String dir) {
        if (!this.hasResourceDir(dir)) {
            this.resources.add(dir);
        }
    }

    public void removeResourceDir(String dir) {
        this.resources.remove(dir);
    }

    public void removeAllResourceDirs() {
        this.resources.clear();
    }

    public void reset() {
        this.mibs.clear();
        this.queue.clear();
        this.context = new DefaultContext();
    }

    public MibContext getDefaultContext() {
        return this.context;
    }

    public ObjectIdentifierValue getRootOid() {
        MibSymbol symbol = this.context.findSymbol("iso", false);
        MibValue value = ((MibValueSymbol)symbol).getValue();
        return (ObjectIdentifierValue)value;
    }

    public Mib getMib(String name) {
        int i = 0;
        while (i < this.mibs.size()) {
            Mib mib = (Mib)this.mibs.get(i);
            if (mib.equals(name)) {
                return mib;
            }
            ++i;
        }
        return null;
    }

    public Mib getMib(File file) {
        int i = 0;
        while (i < this.mibs.size()) {
            Mib mib = (Mib)this.mibs.get(i);
            if (mib.equals(file)) {
                return mib;
            }
            ++i;
        }
        return null;
    }

    public Mib[] getAllMibs() {
        Mib[] res = new Mib[this.mibs.size()];
        this.mibs.toArray(res);
        return res;
    }

    public Mib load(String name) throws IOException, MibLoaderException {
        Mib mib = this.getMib(name);
        if (mib == null) {
            MibSource src = this.locate(name);
            if (src == null) {
                throw new FileNotFoundException("couldn't locate MIB: '" + name + "'");
            }
            mib = this.load(src);
        } else {
            mib.setLoaded(true);
        }
        return mib;
    }

    public Mib load(File file) throws IOException, MibLoaderException {
        Mib mib = this.getMib(file);
        if (mib == null) {
            mib = this.load(new MibSource(file));
        } else {
            mib.setLoaded(true);
        }
        return mib;
    }

    public Mib load(URL url) throws IOException, MibLoaderException {
        return this.load(new MibSource(url));
    }

    public Mib load(Reader input) throws IOException, MibLoaderException {
        return this.load(new MibSource(input));
    }

    private Mib load(MibSource src) throws IOException, MibLoaderException {
        int position = this.mibs.size();
        this.queue.clear();
        this.queue.add(src);
        MibLoaderLog log = this.loadQueue();
        if (log.errorCount() > 0) {
            throw new MibLoaderException(log);
        }
        return (Mib)this.mibs.get(position);
    }

    public void unload(String name) throws MibLoaderException {
        int i = 0;
        while (i < this.mibs.size()) {
            Mib mib = (Mib)this.mibs.get(i);
            if (mib.equals(name)) {
                this.unload(mib);
                return;
            }
            ++i;
        }
    }

    public void unload(File file) throws MibLoaderException {
        int i = 0;
        while (i < this.mibs.size()) {
            Mib mib = (Mib)this.mibs.get(i);
            if (mib.equals(file)) {
                this.unload(mib);
                return;
            }
            ++i;
        }
    }

    public void unload(Mib mib) throws MibLoaderException {
        int pos = this.mibs.indexOf(mib);
        if (pos >= 0) {
            Mib[] referers = mib.getImportingMibs();
            if (referers.length > 0) {
                String message = "cannot be unloaded due to reference in " + referers[0];
                throw new MibLoaderException(mib.getFile(), message);
            }
            mib = (Mib)this.mibs.remove(pos);
            mib.clear();
        }
    }

    public void unloadAll() {
        int i = 0;
        while (i < this.mibs.size()) {
            ((Mib)this.mibs.get(i)).clear();
            ++i;
        }
        this.reset();
    }

    void scheduleLoad(String name) {
        if (this.getMib(name) == null && !this.queue.contains(name)) {
            this.queue.add(name);
        }
    }

    private MibLoaderLog loadQueue() throws IOException {
        int i;
        MibLoaderLog log = new MibLoaderLog();
        ArrayList processed = new ArrayList();
        while (this.queue.size() > 0) {
            try {
                MibSource src;
                boolean loaded = false;
                Object obj = this.queue.get(0);
                if (obj instanceof MibSource) {
                    loaded = true;
                    src = (MibSource)obj;
                } else {
                    src = this.getMib((String)obj) == null ? this.locate((String)obj) : null;
                }
                if (src != null && this.getMib(src.getFile()) == null) {
                    ArrayList list = src.parseMib(this, log);
                    i = 0;
                    while (i < list.size()) {
                        ((Mib)list.get(i)).setLoaded(loaded);
                        ++i;
                    }
                    this.mibs.addAll(list);
                    processed.addAll(list);
                }
            }
            catch (MibLoaderException mibLoaderException) {}
            this.queue.remove(0);
        }
        i = processed.size() - 1;
        while (i >= 0) {
            try {
                ((Mib)processed.get(i)).initialize();
            }
            catch (MibLoaderException mibLoaderException) {}
            --i;
        }
        i = processed.size() - 1;
        while (i >= 0) {
            try {
                ((Mib)processed.get(i)).validate();
            }
            catch (MibLoaderException mibLoaderException) {}
            --i;
        }
        if (log.errorCount() > 0) {
            this.mibs.removeAll(processed);
        }
        return log;
    }

    private MibSource locate(String name) {
        File file;
        MibDirectoryCache cache;
        ClassLoader loader = this.getClass().getClassLoader();
        int i = 0;
        while (i < this.dirCaches.size()) {
            cache = (MibDirectoryCache)this.dirCaches.get(i);
            file = cache.findByName(name);
            if (file != null) {
                return new MibSource(file);
            }
            ++i;
        }
        i = 0;
        while (i < this.resources.size()) {
            URL url = loader.getResource(this.resources.get(i) + "/" + name);
            if (url != null) {
                return new MibSource(name, url);
            }
            ++i;
        }
        i = 0;
        while (i < this.dirCaches.size()) {
            cache = (MibDirectoryCache)this.dirCaches.get(i);
            file = cache.findByContent(name);
            if (file != null) {
                return new MibSource(file);
            }
            ++i;
        }
        return null;
    }

    private static class MibSource {
        private static Asn1Parser parser = null;
        private File file = null;
        private URL url = null;
        private Reader input = null;

        public MibSource(File file) {
            this.file = file;
        }

        public MibSource(URL url) {
            this.url = url;
        }

        public MibSource(String name, URL url) {
            this(url);
            this.file = new File(name);
        }

        public MibSource(Reader input) {
            this.input = input;
        }

        public boolean equals(Object obj) {
            try {
                if (obj instanceof MibSource) {
                    MibSource src = (MibSource)obj;
                    if (this.url != null) {
                        return this.url.toString().equals(src.url.toString());
                    }
                    if (this.file != null) {
                        return this.file.equals(src.file);
                    }
                }
            }
            catch (Throwable throwable) {}
            return false;
        }

        public int hashCode() {
            if (this.url != null) {
                return this.url.toString().hashCode();
            }
            if (this.file != null) {
                return this.file.hashCode();
            }
            return super.hashCode();
        }

        public File getFile() {
            return this.file;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ArrayList parseMib(MibLoader loader, MibLoaderLog log) throws IOException, MibLoaderException {
            ArrayList arrayList;
            if (this.input == null) {
                this.input = this.url != null ? new InputStreamReader(this.url.openStream()) : new FileReader(this.file);
            }
            MibAnalyzer analyzer = new MibAnalyzer(this.file, loader, log);
            try {
                if (parser == null) {
                    parser = new Asn1Parser(this.input, analyzer);
                    parser.getTokenizer().setUseTokenList(true);
                } else {
                    parser.reset(this.input, analyzer);
                }
                parser.parse();
                arrayList = analyzer.getMibs();
            }
            catch (ParserCreationException e) {
                try {
                    String msg = "parser creation error in ASN.1 parser: " + e.getMessage();
                    log.addInternalError(this.file, msg);
                    throw new MibLoaderException(log);
                    catch (ParserLogException e2) {
                        log.addAll(this.file, e2);
                        throw new MibLoaderException(log);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.input.close();
                    }
                    catch (Throwable throwable2) {}
                    analyzer.reset();
                    throw throwable;
                }
            }
            try {
                this.input.close();
            }
            catch (Throwable throwable) {}
            analyzer.reset();
            return arrayList;
        }
    }
}

