/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.mibble.FileLocation;

public class MibLoaderLog {
    private ArrayList entries = new ArrayList();
    private int errors = 0;
    private int warnings = 0;

    public int errorCount() {
        return this.errors;
    }

    public int warningCount() {
        return this.warnings;
    }

    public void add(LogEntry entry) {
        if (entry.isError()) {
            ++this.errors;
        }
        if (entry.isWarning()) {
            ++this.warnings;
        }
        this.entries.add(entry);
    }

    public void addInternalError(FileLocation location, String message) {
        this.add(new LogEntry(1, location, message));
    }

    public void addInternalError(File file, String message) {
        this.addInternalError(new FileLocation(file), message);
    }

    public void addError(FileLocation location, String message) {
        this.add(new LogEntry(2, location, message));
    }

    public void addError(File file, int line, int column, String message) {
        this.addError(new FileLocation(file, line, column), message);
    }

    public void addWarning(FileLocation location, String message) {
        this.add(new LogEntry(3, location, message));
    }

    public void addWarning(File file, int line, int column, String message) {
        this.addWarning(new FileLocation(file, line, column), message);
    }

    public void addAll(MibLoaderLog log) {
        int i = 0;
        while (i < log.entries.size()) {
            this.add((LogEntry)log.entries.get(i));
            ++i;
        }
    }

    void addAll(File file, ParserLogException log) {
        int i = 0;
        while (i < log.getErrorCount()) {
            ParseException e = log.getError(i);
            this.addError(file, e.getLine(), e.getColumn(), e.getErrorMessage());
            ++i;
        }
    }

    public Iterator entries() {
        return this.entries.iterator();
    }

    public void printTo(PrintStream output) {
        this.printTo(new PrintWriter(output));
    }

    public void printTo(PrintWriter output) {
        this.printTo(output, 70);
    }

    public void printTo(PrintWriter output, int margin) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.entries.size()) {
            LogEntry entry = (LogEntry)this.entries.get(i);
            buffer.setLength(0);
            switch (entry.getType()) {
                case 2: {
                    buffer.append("Error: ");
                    break;
                }
                case 3: {
                    buffer.append("Warning: ");
                    break;
                }
                default: {
                    buffer.append("Internal Error: ");
                }
            }
            buffer.append("in ");
            buffer.append(this.relativeFilename(entry.getFile()));
            if (entry.getLineNumber() > 0) {
                buffer.append(": line ");
                buffer.append(entry.getLineNumber());
            }
            buffer.append(":\n");
            String str = this.linebreakString(entry.getMessage(), "    ", margin);
            buffer.append(str);
            str = entry.readLine();
            if (str != null && str.length() >= entry.getColumnNumber()) {
                buffer.append("\n\n");
                buffer.append(str);
                buffer.append("\n");
                int j = 1;
                while (j < entry.getColumnNumber()) {
                    if (str.charAt(j - 1) == '\t') {
                        buffer.append("\t");
                    } else {
                        buffer.append(" ");
                    }
                    ++j;
                }
                buffer.append("^");
            }
            output.println(buffer.toString());
            ++i;
        }
        output.flush();
    }

    private String relativeFilename(File file) {
        if (file == null) {
            return "<unknown file>";
        }
        try {
            String currentPath = new File(".").getCanonicalPath();
            String filePath = file.getCanonicalPath();
            if (filePath.startsWith(currentPath)) {
                if ((filePath = filePath.substring(currentPath.length())).charAt(0) == '/' || filePath.charAt(0) == '\\') {
                    return filePath.substring(1);
                }
                return filePath;
            }
        }
        catch (IOException iOException) {}
        return file.toString();
    }

    private String linebreakString(String str, String prefix, int length) {
        StringBuffer buffer = new StringBuffer();
        while (str.length() + prefix.length() > length) {
            int pos = str.lastIndexOf(32, length - prefix.length());
            if (pos < 0 && (pos = str.indexOf(32)) < 0) break;
            buffer.append(prefix);
            buffer.append(str.substring(0, pos));
            str = str.substring(pos + 1);
            buffer.append("\n");
        }
        buffer.append(prefix);
        buffer.append(str);
        return buffer.toString();
    }

    public class LogEntry {
        public static final int INTERNAL_ERROR = 1;
        public static final int ERROR = 2;
        public static final int WARNING = 3;
        private int type;
        private FileLocation location;
        private String message;

        public LogEntry(int type, FileLocation location, String message) {
            this.type = type;
            this.location = location == null || location.getFile() == null ? new FileLocation(new File("<unknown file>")) : location;
            this.message = message;
        }

        public boolean isError() {
            return this.type == 1 || this.type == 2;
        }

        public boolean isWarning() {
            return this.type == 3;
        }

        public int getType() {
            return this.type;
        }

        public File getFile() {
            return this.location.getFile();
        }

        public int getLineNumber() {
            return this.location.getLineNumber();
        }

        public int getColumnNumber() {
            return this.location.getColumnNumber();
        }

        public String getMessage() {
            return this.message;
        }

        public String readLine() {
            return this.location.readLine();
        }
    }
}

