/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibValueSymbol
extends MibSymbol {
    private MibType type;
    private MibValue value;

    public MibValueSymbol(FileLocation location, Mib mib, String name, MibType type, MibValue value) {
        super(location, mib, name);
        this.type = type;
        this.value = value;
    }

    @Override
    public void initialize(MibLoaderLog log) throws MibException {
        ObjectIdentifierValue oid;
        if (this.type != null) {
            try {
                this.type = this.type.initialize(this, log);
            }
            catch (MibException e) {
                log.addError(e.getLocation(), e.getMessage());
                this.type = null;
            }
        }
        if (this.value != null) {
            try {
                this.value = this.value.initialize(log, this.type);
            }
            catch (MibException e) {
                log.addError(e.getLocation(), e.getMessage());
                this.value = null;
            }
        }
        if (this.type != null && this.value != null && !this.type.isCompatible(this.value)) {
            log.addError(this.getLocation(), "value is not compatible with type");
        }
        if (this.value instanceof ObjectIdentifierValue && (oid = (ObjectIdentifierValue)this.value).getSymbol() == null) {
            oid.setSymbol(this);
        }
    }

    @Override
    void clear() {
        this.type = null;
        if (this.value != null) {
            this.value.clear();
        }
        this.value = null;
    }

    public boolean isScalar() {
        return this.type instanceof SnmpObjectType && !this.isTable() && !this.isTableRow() && !this.isTableColumn();
    }

    public boolean isTable() {
        if (this.type instanceof SnmpObjectType) {
            MibType syntax = ((SnmpObjectType)this.type).getSyntax();
            return syntax instanceof SequenceOfType;
        }
        return false;
    }

    public boolean isTableRow() {
        if (this.type instanceof SnmpObjectType) {
            MibType syntax = ((SnmpObjectType)this.type).getSyntax();
            return syntax instanceof SequenceType;
        }
        return false;
    }

    public boolean isTableColumn() {
        MibValueSymbol parent = this.getParent();
        return this.type instanceof SnmpObjectType && parent != null && parent.isTableRow();
    }

    public MibType getType() {
        return this.type;
    }

    public MibValue getValue() {
        return this.value;
    }

    public MibValueSymbol getParent() {
        ObjectIdentifierValue oid;
        if (this.value instanceof ObjectIdentifierValue && (oid = ((ObjectIdentifierValue)this.value).getParent()) != null) {
            return oid.getSymbol();
        }
        return null;
    }

    public int getChildCount() {
        if (this.value instanceof ObjectIdentifierValue) {
            return ((ObjectIdentifierValue)this.value).getChildCount();
        }
        return 0;
    }

    public MibValueSymbol getChild(int index) {
        ObjectIdentifierValue oid;
        if (this.value instanceof ObjectIdentifierValue && (oid = ((ObjectIdentifierValue)this.value).getChild(index)) != null) {
            return oid.getSymbol();
        }
        return null;
    }

    public MibValueSymbol[] getChildren() {
        MibValueSymbol[] children;
        if (this.value instanceof ObjectIdentifierValue) {
            ObjectIdentifierValue oid = (ObjectIdentifierValue)this.value;
            children = new MibValueSymbol[oid.getChildCount()];
            int i = 0;
            while (i < oid.getChildCount()) {
                children[i] = oid.getChild(i).getSymbol();
                ++i;
            }
        } else {
            children = new MibValueSymbol[]{};
        }
        return children;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("VALUE ");
        buffer.append(this.getName());
        buffer.append(" ");
        buffer.append(this.getType());
        buffer.append("\n    ::= ");
        buffer.append(this.getValue());
        return buffer.toString();
    }
}

