/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;

public class MibbleValidator {
    private static final String COMMAND_HELP = "Validates a set of SNMP MIB files. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibbleValidator <file(s) or URL(s)>";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";

    public static void main(String[] args) {
        File file;
        MibLoader loader = new MibLoader();
        ArrayList<Serializable> queue = new ArrayList<Serializable>();
        int errors = 0;
        int warnings = 0;
        if (args.length < 1) {
            MibbleValidator.printHelp("No file(s) specified");
            System.exit(1);
        }
        int i = 0;
        while (i < args.length) {
            try {
                if (args[0].contains(":")) {
                    queue.add(new URL(args[0]));
                } else {
                    file = new File(args[i]);
                    if (!file.exists()) {
                        System.out.println("Warning: Skipping " + args[i] + ": file not found");
                    } else if (file.isDirectory()) {
                        MibbleValidator.addMibs(file, queue);
                    } else {
                        queue.add(file);
                    }
                }
            }
            catch (MalformedURLException e) {
                System.out.println("Warning: Skipping " + args[i] + ": " + e.getMessage());
            }
            ++i;
        }
        i = 0;
        while (i < queue.size()) {
            Object src = queue.get(i);
            System.out.print(i);
            System.out.print("/");
            System.out.print(queue.size());
            System.out.print(": Reading " + src + "... ");
            System.out.flush();
            try {
                Mib mib;
                loader.unloadAll();
                if (src instanceof URL) {
                    loader.removeAllDirs();
                    mib = loader.load((URL)src);
                } else {
                    file = (File)src;
                    if (!loader.hasDir(file.getParentFile())) {
                        loader.removeAllDirs();
                        loader.addDir(file.getParentFile());
                    }
                    mib = loader.load(file);
                }
                System.out.println("[OK]");
                if (mib.getLog().warningCount() > 0) {
                    mib.getLog().printTo(System.out);
                    ++warnings;
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("[FAILED]");
                MibbleValidator.printError(src.toString(), e);
                ++errors;
            }
            catch (IOException e) {
                System.out.println("[FAILED]");
                MibbleValidator.printError(src.toString(), e);
                ++errors;
            }
            catch (MibLoaderException e) {
                System.out.println("[FAILED]");
                e.getLog().printTo(System.out);
                ++errors;
            }
            catch (RuntimeException e) {
                System.out.println();
                MibbleValidator.printInternalError(e);
                System.exit(1);
            }
            ++i;
        }
        System.out.println();
        System.out.println("Files processed:  " + queue.size());
        System.out.println("  with errors:    " + errors);
        System.out.println("  with warnings:  " + warnings);
        if (errors > 0) {
            System.err.println("Error: validation errors were encountered");
        }
        System.exit(errors);
    }

    private static void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            System.err.print("Error: ");
            System.err.println(error);
            System.err.println();
        }
    }

    private static void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private static void printError(String file, FileNotFoundException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: couldn't open file:");
        buffer.append("\n    ");
        buffer.append(file);
        System.out.println(buffer.toString());
    }

    private static void printError(String url, IOException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: couldn't open URL:");
        buffer.append("\n    ");
        buffer.append(url);
        System.out.println(buffer.toString());
    }

    private static void addMibs(File dir, ArrayList queue) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isHidden()) {
                if (files[i].isDirectory()) {
                    MibbleValidator.addMibs(files[i], queue);
                } else if (MibbleValidator.isMib(files[i])) {
                    queue.add(files[i]);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isMib(File file) {
        BufferedReader in = null;
        StringBuffer buffer = new StringBuffer();
        int line = 0;
        if (!file.canRead()) return false;
        if (!file.isFile()) {
            return false;
        }
        try {
            String str;
            in = new BufferedReader(new FileReader(file));
            while (line++ < 100 && (str = in.readLine()) != null) {
                buffer.append(str);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (in == null) return buffer.indexOf("DEFINITIONS") > 0 && buffer.indexOf("::=") > 0 && buffer.indexOf("BEGIN") > 0;
            try {
                in.close();
                return buffer.indexOf("DEFINITIONS") > 0 && buffer.indexOf("::=") > 0 && buffer.indexOf("BEGIN") > 0;
            }
            catch (IOException iOException) {}
            return buffer.indexOf("DEFINITIONS") > 0 && buffer.indexOf("::=") > 0 && buffer.indexOf("BEGIN") > 0;
        }
        catch (IOException iOException) {
            try {
                if (in == null) return buffer.indexOf("DEFINITIONS") > 0 && buffer.indexOf("::=") > 0 && buffer.indexOf("BEGIN") > 0;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                in.close();
                return buffer.indexOf("DEFINITIONS") > 0 && buffer.indexOf("::=") > 0 && buffer.indexOf("BEGIN") > 0;
            }
            catch (IOException iOException3) {}
            return buffer.indexOf("DEFINITIONS") > 0 && buffer.indexOf("::=") > 0 && buffer.indexOf("BEGIN") > 0;
        }
        if (in == null) return buffer.indexOf("DEFINITIONS") > 0 && buffer.indexOf("::=") > 0 && buffer.indexOf("BEGIN") > 0;
        try {
            in.close();
            return buffer.indexOf("DEFINITIONS") > 0 && buffer.indexOf("::=") > 0 && buffer.indexOf("BEGIN") > 0;
        }
        catch (IOException iOException) {}
        return buffer.indexOf("DEFINITIONS") > 0 && buffer.indexOf("::=") > 0 && buffer.indexOf("BEGIN") > 0;
    }
}

