/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpCompliance;

public class SnmpModule {
    private String module;
    private ArrayList groups;
    private ArrayList compliances;
    private String comment = null;

    public SnmpModule(String module, ArrayList groups, ArrayList compliances) {
        this.module = module;
        this.groups = groups;
        this.compliances = compliances;
    }

    void initialize(MibLoaderLog log) throws MibException {
        ArrayList<MibValue> list = new ArrayList<MibValue>();
        int i = 0;
        while (i < this.groups.size()) {
            list.add(((MibValue)this.groups.get(i)).initialize(log, null));
            ++i;
        }
        this.groups = list;
        i = 0;
        while (i < this.compliances.size()) {
            ((SnmpCompliance)this.compliances.get(i)).initialize(log);
            ++i;
        }
    }

    public String getModule() {
        return this.module;
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public ArrayList getCompliances() {
        return this.compliances;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (this.module != null || !"THIS MODULE".equalsIgnoreCase(comment)) {
            this.comment = comment;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.module != null) {
            buffer.append(this.module);
        }
        if (this.groups.size() > 0) {
            buffer.append("\n    Mandatory Groups: ");
            buffer.append(this.groups);
        }
        int i = 0;
        while (i < this.compliances.size()) {
            buffer.append("\n    Module: ");
            buffer.append(this.compliances.get(i));
            ++i;
        }
        return buffer.toString();
    }
}

