/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpVariation;

public class SnmpModuleSupport {
    private String module;
    private ArrayList groups;
    private ArrayList variations;

    public SnmpModuleSupport(String module, ArrayList groups, ArrayList variations) {
        this.module = module;
        this.groups = groups;
        this.variations = variations;
    }

    void initialize(MibLoaderLog log) throws MibException {
        ArrayList<MibValue> list = new ArrayList<MibValue>();
        int i = 0;
        while (i < this.groups.size()) {
            list.add(((MibValue)this.groups.get(i)).initialize(log, null));
            ++i;
        }
        this.groups = list;
        i = 0;
        while (i < this.variations.size()) {
            try {
                ((SnmpVariation)this.variations.get(i)).initialize(log);
            }
            catch (MibException e) {
                log.addError(e.getLocation(), e.getMessage());
            }
            ++i;
        }
    }

    public String getModule() {
        return this.module;
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public ArrayList getVariations() {
        return this.variations;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.module != null) {
            buffer.append(this.module);
        }
        buffer.append("\n    Includes: ");
        buffer.append(this.groups);
        int i = 0;
        while (i < this.variations.size()) {
            buffer.append("\n    Variation: ");
            buffer.append(this.variations.get(i));
            ++i;
        }
        return buffer.toString();
    }
}

