/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.ElementType;

public class ChoiceType
extends MibType {
    private ArrayList elements;

    public ChoiceType(ArrayList elements) {
        this(true, elements);
    }

    private ChoiceType(boolean primitive, ArrayList elements) {
        super("CHOICE", primitive);
        this.elements = elements;
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        int i = 0;
        while (i < this.elements.size()) {
            ElementType elem = (ElementType)this.elements.get(i);
            elem.initialize(symbol, log);
            ++i;
        }
        return this;
    }

    @Override
    public MibType createReference() {
        ChoiceType type = new ChoiceType(false, this.elements);
        type.setTag(true, this.getTag());
        return type;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        int i = 0;
        while (i < this.elements.size()) {
            ElementType elem = (ElementType)this.elements.get(i);
            if (elem.isCompatible(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ElementType[] getAllElements() {
        ElementType[] res = new ElementType[this.elements.size()];
        this.elements.toArray(res);
        return res;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.elements.toString();
    }
}

