/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.value.NumberValue;

public class IntegerType
extends MibType
implements MibContext {
    private Constraint constraint = null;
    private LinkedHashMap symbols = new LinkedHashMap();

    public IntegerType() {
        this(true, null, null);
    }

    public IntegerType(Constraint constraint) {
        this(true, constraint, null);
    }

    public IntegerType(ArrayList values) {
        this(true, null, null);
        this.createValueConstraints(values);
    }

    private IntegerType(boolean primitive, Constraint constraint, LinkedHashMap symbols) {
        super("INTEGER", primitive);
        if (constraint != null) {
            this.constraint = constraint;
        }
        if (symbols != null) {
            this.symbols = symbols;
        }
        this.setTag(true, MibTypeTag.INTEGER);
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        Iterator iter = this.symbols.values().iterator();
        if (this.constraint != null) {
            this.constraint.initialize(this, log);
        }
        while (iter.hasNext()) {
            MibValueSymbol sym = (MibValueSymbol)iter.next();
            sym.initialize(log);
            if (this.isCompatibleType(sym.getValue())) continue;
            String message = "value is not compatible with type";
            throw new MibException(sym.getLocation(), message);
        }
        return this;
    }

    @Override
    public MibType createReference() {
        IntegerType type = new IntegerType(false, this.constraint, this.symbols);
        type.setTag(true, this.getTag());
        return type;
    }

    @Override
    public MibType createReference(Constraint constraint) {
        IntegerType type = new IntegerType(false, constraint, null);
        type.setTag(true, this.getTag());
        return type;
    }

    @Override
    public MibType createReference(ArrayList values) {
        IntegerType type = new IntegerType(false, null, null);
        type.createValueConstraints(values);
        type.setTag(true, this.getTag());
        return type;
    }

    private void createValueConstraints(ArrayList values) {
        int i = 0;
        while (i < values.size()) {
            if (values.get(i) instanceof MibValueSymbol) {
                MibValueSymbol sym = (MibValueSymbol)values.get(i);
                this.symbols.put(sym.getName(), sym);
                ValueConstraint c = new ValueConstraint(null, sym.getValue());
                this.constraint = this.constraint == null ? c : new CompoundConstraint(this.constraint, c);
            }
            ++i;
        }
    }

    public boolean hasConstraint() {
        return this.constraint != null;
    }

    public boolean hasSymbols() {
        return this.symbols.size() > 0;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return this.isCompatibleType(value) && (this.constraint == null || this.constraint.isCompatible(value));
    }

    private boolean isCompatibleType(MibValue value) {
        return value instanceof NumberValue && !(value.toObject() instanceof Float);
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public MibValueSymbol getSymbol(String name) {
        return (MibValueSymbol)this.symbols.get(name);
    }

    public MibValueSymbol[] getAllSymbols() {
        Iterator iter = this.symbols.values().iterator();
        MibValueSymbol[] res = new MibValueSymbol[this.symbols.size()];
        int i = 0;
        while (iter.hasNext()) {
            res[i] = (MibValueSymbol)iter.next();
            ++i;
        }
        return res;
    }

    @Override
    public MibSymbol findSymbol(String name, boolean expanded) {
        return this.getSymbol(name);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        if (this.symbols.size() > 0) {
            buffer.append(" { ");
            Iterator iter = this.symbols.values().iterator();
            while (iter.hasNext()) {
                MibValueSymbol symbol = (MibValueSymbol)iter.next();
                buffer.append(symbol.getName());
                buffer.append("(");
                buffer.append(symbol.getValue());
                buffer.append(")");
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(" }");
        } else if (this.constraint != null) {
            buffer.append(" (");
            buffer.append(this.constraint.toString());
            buffer.append(")");
        }
        return buffer.toString();
    }
}

