/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.util.ArrayList;
import java.util.BitSet;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ValueReference;

public class BitSetValue
extends MibValue {
    private BitSet value;
    private ArrayList references;

    public BitSetValue(BitSet value) {
        this(value, null);
    }

    public BitSetValue(BitSet value, ArrayList references) {
        super("BIT STRING");
        this.value = value;
        this.references = references;
    }

    @Override
    public MibValue initialize(MibLoaderLog log, MibType type) throws MibException {
        if (this.references != null) {
            int i = 0;
            while (i < this.references.size()) {
                this.initialize(log, type, (ValueReference)this.references.get(i));
                ++i;
            }
            this.references = null;
        }
        return this;
    }

    @Override
    public MibValue createReference() {
        return new BitSetValue(this.value, this.references);
    }

    private void initialize(MibLoaderLog log, MibType type, ValueReference ref) throws MibException {
        MibValue value = ref.initialize(log, type);
        if (!(value instanceof NumberValue)) {
            throw new MibException(ref.getLocation(), "referenced value is not a number");
        }
        this.value.set(((Number)value.toObject()).intValue());
    }

    @Override
    protected void clear() {
        super.clear();
        this.value = null;
        this.references = null;
    }

    public ArrayList getBits() {
        ArrayList<NumberValue> components = new ArrayList<NumberValue>();
        int i = 0;
        while (i < this.value.size()) {
            if (this.value.get(i)) {
                components.add(new NumberValue(i));
            }
            ++i;
        }
        return components;
    }

    public int compareTo(Object obj) {
        return this.toString().compareTo(obj.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public String toAsn1String(MibValueSymbol[] values) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.value.size()) {
            if (this.value.get(i)) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.toAsn1String(i, values));
            }
            ++i;
        }
        if (buffer.length() > 0) {
            return "{ " + buffer.toString() + " }";
        }
        return "{}";
    }

    private String toAsn1String(Integer bit, MibValueSymbol[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i].getValue().equals(bit)) {
                return values[i].getName();
            }
            ++i;
        }
        return bit.toString();
    }
}

