/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.math.BigInteger;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.value.NumberValue;

public class HexNumberValue
extends NumberValue {
    private int minLength;

    public HexNumberValue(Number value) {
        this(value, 1);
    }

    public HexNumberValue(Number value, int minLength) {
        super(value);
        this.minLength = minLength;
    }

    @Override
    public MibValue initialize(MibLoaderLog log, MibType type) {
        int bytes = this.minLength / 2 + (this.minLength % 2 > 0 ? 1 : 0);
        int length = this.getByteSize(type, bytes) * 2;
        if (length > this.minLength) {
            this.minLength = length;
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("'");
        String value = this.toHexString();
        if (value.equals("0")) {
            value = "";
        }
        int i = value.length();
        while (i < this.minLength) {
            buffer.append("0");
            ++i;
        }
        buffer.append(value);
        buffer.append("'H");
        return buffer.toString();
    }

    private String toHexString() {
        Number num = (Number)this.toObject();
        if (num instanceof BigInteger) {
            return ((BigInteger)num).toString(16).toUpperCase();
        }
        if (num instanceof Long) {
            return Long.toHexString(num.longValue()).toUpperCase();
        }
        return Integer.toHexString(num.intValue()).toUpperCase();
    }
}

